import se.datadosen.jalbum.JAFilter;
import java.awt.*;
import java.awt.image.BufferedImage;

/**
 * Title:        JAlbum simple zooming image filter. Always use with "prescale" attribute
 * Copyright:    Copyright (c) 2003
 * Company:      Datadosen
 * @author David Ekholm
 * @version 1.0
 */
public class ZoomFilter implements JAFilter {

		private int zoomPercent = 30;

		// Implements JAFilter
    public String getName() {
        return "Zooming filter";
    }

		// Implements JAFilter
    public String getDescription() {
        return "Zooms images (preferrably thumbnails) a certain percent. Use with 'prefilter' attribute to enlarge focus area";
    }

		public int getZoomPercent() {
				return zoomPercent;
		}

		public void setZoomPercent(int zoomPercent) {
			if (zoomPercent > 99) {
				zoomPercent = 99;
			}
			this.zoomPercent = zoomPercent;
		}

		// Implements JAFilter
    public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
				int w = bi.getWidth();
				int h = bi.getHeight();
				int zoomedW = w*(100-zoomPercent)/100;
				int zoomedH = h*(100-zoomPercent)/100;

				return bi.getSubimage((w-zoomedW)/2, (h-zoomedH)/3, zoomedW, zoomedH);
    }
}
