import se.datadosen.jalbum.JAFilter;
import java.awt.*;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

/**
 * Title:        JAlbum simple image filter adding a JAlbum logo to the corner of images
 * Copyright:    Copyright (c) 2003
 * Company:      Datadosen
 * @author David Ekholm
 * @version 1.0
 */
public class SimpleFilter implements JAFilter {

		// Implements JAFilter
    public String getName() {
        return "Simple filter";
    }

		// Implements JAFilter
    public String getDescription() {
        return "Add a JAlbum logo to the corner of images";
    }

		// Implements JAFilter
    public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
				Graphics2D g = bi.createGraphics();
				ImageIcon windowIcon = new ImageIcon(se.datadosen.jalbum.JAlbumFrame.class.getResource("images/make_64.png"));
				g.drawImage(windowIcon.getImage(), 0, 0, null);
                g.dispose();
				return bi;
    }
}
