
import se.datadosen.jalbum.*;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.*;
import se.datadosen.util.Colors;

/**
 * Add a n pixel margin around images. Unlike the more flexible XBorderFilter, this one supports transparencies Image
 * width and height increases by 2 * margin
 *
 * @author David Ekholm, jAlbum 2019
 * @since 18.3
 * @version 1.0
 */
public class MarginFilter implements JAFilter, ModifiesSize {

    private int margin = 20;
    private Color color = new Color(0, 0, 0, 0);

    public int getMargin() {
        return margin;
    }

    /**
     * Sets the number of pixel for the margin. Defaults to 20
     *
     * @param margin
     */
    public void setMargin(int margin) {
        this.margin = margin;
    }

    public Color getColor() {
        return color;
    }

    /**
     * Set the margin's color. Defaults to fully transparent black
     *
     * @param color
     */
    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(String htmlColor) {
        this.color = Colors.getHTMLColor(htmlColor);
    }

    public String getName() {
        return "Margin filter";
    }

    // Implements JAFilter
    public String getDescription() {
        return "Adds an N pixel margin around images";
    }

    // Implements JAFilter
    public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
        BufferedImage larger = new BufferedImage(bi.getWidth() + 2 * margin, bi.getHeight() + 2 * margin, bi.getType());
        Graphics g = larger.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, larger.getWidth(), larger.getHeight());
        g.drawImage(bi, margin, margin, null);
        g.dispose();
        return larger;
    }

    // Implements ModifiesSize
    public Dimension getModifiedSize(Dimension originalSize, Map vars) {
        return new Dimension(originalSize.width + 2 * margin, originalSize.height + 2 * margin);
    }
}
