/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util.com.google.ical.util;

import biweekly.util.com.google.ical.util.Predicate;
import java.util.Collection;

public class Predicates {
    private static final Predicate<?> ALWAYS_TRUE = new AlwaysTruePredicate();
    private static final Predicate<?> ALWAYS_FALSE = new AlwaysFalsePredicate();

    public static <T> Predicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return new NotPredicate(predicate);
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        components = (Predicate[])components.clone();
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            Predicate<? super T> p = components[i];
            if (p == ALWAYS_FALSE) {
                return Predicates.alwaysFalse();
            }
            if (p != ALWAYS_TRUE) continue;
            components[i] = components[n - 1];
            --i;
            --n;
        }
        if (n == 0) {
            return Predicates.alwaysTrue();
        }
        if (n != components.length) {
            Predicate[] newComponents = new Predicate[n];
            System.arraycopy(newComponents, 0, components, 0, n);
            components = newComponents;
        }
        return new AndPredicate((Predicate[])components);
    }

    public static <T> Predicate<T> and(Collection<Predicate<? super T>> components) {
        return Predicates.and(components.toArray(new Predicate[0]));
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        components = (Predicate[])components.clone();
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            Predicate<? super T> p = components[i];
            if (p == ALWAYS_TRUE) {
                return Predicates.alwaysTrue();
            }
            if (p != ALWAYS_FALSE) continue;
            components[i] = components[n - 1];
            --i;
            --n;
        }
        if (n == 0) {
            return Predicates.alwaysFalse();
        }
        if (n != components.length) {
            Predicate[] newComponents = new Predicate[n];
            System.arraycopy(newComponents, 0, components, 0, n);
            components = newComponents;
        }
        return new OrPredicate((Predicate[])components);
    }

    private Predicates() {
    }

    private static class NotPredicate<T>
    implements Predicate<T> {
        private static final long serialVersionUID = -5113445916422049953L;
        private final Predicate<? super T> predicate;

        private NotPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean apply(T t) {
            return !this.predicate.apply(t);
        }
    }

    private static class AndPredicate<T>
    implements Predicate<T> {
        private static final long serialVersionUID = 1022358602593297546L;
        private final Predicate<? super T>[] components;

        private AndPredicate(Predicate<? super T> ... components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (predicate.apply(t)) continue;
                return false;
            }
            return true;
        }
    }

    private static class OrPredicate<T>
    implements Predicate<T> {
        private static final long serialVersionUID = -7942366790698074803L;
        private final Predicate<? super T>[] components;

        private OrPredicate(Predicate<? super T> ... components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (!predicate.apply(t)) continue;
                return true;
            }
            return false;
        }
    }

    private static class AlwaysTruePredicate<T>
    implements Predicate<T> {
        private static final long serialVersionUID = 8759914710239461322L;

        private AlwaysTruePredicate() {
        }

        @Override
        public boolean apply(T t) {
            return true;
        }

        public String toString() {
            return "true";
        }
    }

    private static class AlwaysFalsePredicate<T>
    implements Predicate<T> {
        private static final long serialVersionUID = -565481022115659695L;

        private AlwaysFalsePredicate() {
        }

        @Override
        public boolean apply(T t) {
            return false;
        }

        public String toString() {
            return "false";
        }
    }
}

