/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util.com.google.ical.iter;

import biweekly.util.ByDay;
import biweekly.util.DayOfWeek;
import biweekly.util.Frequency;
import biweekly.util.Google2445Utils;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import biweekly.util.com.google.ical.iter.CompoundIteratorImpl;
import biweekly.util.com.google.ical.iter.Conditions;
import biweekly.util.com.google.ical.iter.Filters;
import biweekly.util.com.google.ical.iter.Generator;
import biweekly.util.com.google.ical.iter.Generators;
import biweekly.util.com.google.ical.iter.InstanceGenerators;
import biweekly.util.com.google.ical.iter.IntSet;
import biweekly.util.com.google.ical.iter.RDateIteratorImpl;
import biweekly.util.com.google.ical.iter.RRuleIteratorImpl;
import biweekly.util.com.google.ical.iter.RecurrenceIterable;
import biweekly.util.com.google.ical.iter.RecurrenceIterator;
import biweekly.util.com.google.ical.iter.ThrottledGenerator;
import biweekly.util.com.google.ical.iter.Util;
import biweekly.util.com.google.ical.util.Predicate;
import biweekly.util.com.google.ical.util.Predicates;
import biweekly.util.com.google.ical.util.TimeUtils;
import biweekly.util.com.google.ical.values.DateTimeValueImpl;
import biweekly.util.com.google.ical.values.DateValue;
import biweekly.util.com.google.ical.values.DateValueImpl;
import biweekly.util.com.google.ical.values.TimeValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;

public class RecurrenceIteratorFactory {
    private static final int[] NO_INTS = new int[0];
    private static final ByDay[] NO_DAYS = new ByDay[0];

    public static RecurrenceIterator createRecurrenceIterator(Collection<? extends DateValue> dates) {
        DateValue[] datesArray = dates.toArray(new DateValue[0]);
        return new RDateIteratorImpl(datesArray);
    }

    public static RecurrenceIterable createRecurrenceIterable(final Recurrence rrule, final DateValue dtStart, final TimeZone tzid) {
        return new RecurrenceIterable(){

            @Override
            public RecurrenceIterator iterator() {
                return RecurrenceIteratorFactory.createRecurrenceIterator(rrule, dtStart, tzid);
            }
        };
    }

    public static RecurrenceIterator createRecurrenceIterator(Recurrence rrule, DateValue dtStart, TimeZone tzid) {
        Predicate filter;
        Predicate<DateValue> condition;
        Frequency freq = rrule.getFrequency();
        if (freq == null) {
            freq = Frequency.YEARLY;
        }
        DayOfWeek wkst = rrule.getWorkweekStarts();
        ICalDate until = rrule.getUntil();
        DateValue untilUtc = until == null ? null : Google2445Utils.convert(until, tzid);
        int count = RecurrenceIteratorFactory.toInt(rrule.getCount());
        int interval = RecurrenceIteratorFactory.toInt(rrule.getInterval());
        ByDay[] byDay = rrule.getByDay().toArray(new ByDay[0]);
        int[] byMonth = RecurrenceIteratorFactory.toIntArray(rrule.getByMonth());
        int[] byMonthDay = RecurrenceIteratorFactory.toIntArray(rrule.getByMonthDay());
        int[] byWeekNo = RecurrenceIteratorFactory.toIntArray(rrule.getByWeekNo());
        int[] byYearDay = RecurrenceIteratorFactory.toIntArray(rrule.getByYearDay());
        int[] bySetPos = RecurrenceIteratorFactory.toIntArray(rrule.getBySetPos());
        int[] byHour = RecurrenceIteratorFactory.toIntArray(rrule.getByHour());
        int[] byMinute = RecurrenceIteratorFactory.toIntArray(rrule.getByMinute());
        int[] bySecond = RecurrenceIteratorFactory.toIntArray(rrule.getBySecond());
        if (interval <= 0) {
            interval = 1;
        }
        if (wkst == null) {
            wkst = DayOfWeek.MONDAY;
        }
        if (bySetPos.length > 0) {
            switch (freq) {
                case HOURLY: {
                    if (byHour.length > 0 && byMinute.length <= 1 && bySecond.length <= 1) {
                        byHour = RecurrenceIteratorFactory.filterBySetPos(byHour, bySetPos);
                    }
                    bySetPos = NO_INTS;
                    break;
                }
                case MINUTELY: {
                    if (byMinute.length > 0 && bySecond.length <= 1) {
                        byMinute = RecurrenceIteratorFactory.filterBySetPos(byMinute, bySetPos);
                    }
                    bySetPos = NO_INTS;
                    break;
                }
                case SECONDLY: {
                    if (bySecond.length > 0) {
                        bySecond = RecurrenceIteratorFactory.filterBySetPos(bySecond, bySetPos);
                    }
                    bySetPos = NO_INTS;
                    break;
                }
            }
        }
        DateValue start = dtStart;
        if (bySetPos.length > 0) {
            switch (freq) {
                case YEARLY: {
                    start = dtStart instanceof TimeValue ? new DateTimeValueImpl(start.year(), 1, 1, 0, 0, 0) : new DateValueImpl(start.year(), 1, 1);
                    break;
                }
                case MONTHLY: {
                    start = dtStart instanceof TimeValue ? new DateTimeValueImpl(start.year(), start.month(), 1, 0, 0, 0) : new DateValueImpl(start.year(), start.month(), 1);
                    break;
                }
                case WEEKLY: {
                    int d = (7 + wkst.ordinal() - TimeUtils.dayOfWeek(dtStart).getCalendarConstant()) % 7;
                    start = TimeUtils.add(dtStart, new DateValueImpl(0, 0, -d));
                    break;
                }
            }
        }
        ThrottledGenerator yearGenerator = Generators.serialYearGenerator(freq == Frequency.YEARLY ? interval : 1, dtStart);
        Generator monthGenerator = null;
        Generator dayGenerator = null;
        Generator secondGenerator = null;
        Generator minuteGenerator = null;
        Generator hourGenerator = null;
        ArrayList filters = new ArrayList();
        switch (freq) {
            case SECONDLY: {
                if (bySecond.length != 0 && interval == 1) break;
                secondGenerator = Generators.serialSecondGenerator(interval, dtStart);
                if (bySecond.length <= 0) break;
                filters.add(Filters.bySecondFilter(bySecond));
                break;
            }
            case MINUTELY: {
                if (byMinute.length != 0 && interval == 1) break;
                minuteGenerator = Generators.serialMinuteGenerator(interval, dtStart);
                if (byMinute.length <= 0) break;
                filters.add(Filters.byMinuteFilter(byMinute));
                break;
            }
            case HOURLY: {
                if (byHour.length != 0 && interval == 1) break;
                hourGenerator = Generators.serialHourGenerator(interval, dtStart);
                if (byHour.length <= 0) break;
                filters.add(Filters.byHourFilter(bySecond));
                break;
            }
            case DAILY: {
                break;
            }
            case WEEKLY: {
                if (byDay.length > 0) {
                    dayGenerator = Generators.byDayGenerator(byDay, false, start);
                    byDay = NO_DAYS;
                    if (interval <= 1) break;
                    filters.add(Filters.weekIntervalFilter(interval, wkst, dtStart));
                    break;
                }
                dayGenerator = Generators.serialDayGenerator(interval * 7, dtStart);
                break;
            }
            case YEARLY: {
                if (byYearDay.length > 0) {
                    dayGenerator = Generators.byYearDayGenerator(byYearDay, start);
                    break;
                }
            }
            case MONTHLY: {
                if (byMonthDay.length > 0) {
                    dayGenerator = Generators.byMonthDayGenerator(byMonthDay, start);
                    byMonthDay = NO_INTS;
                    break;
                }
                if (byWeekNo.length > 0 && Frequency.YEARLY == freq) {
                    dayGenerator = Generators.byWeekNoGenerator(byWeekNo, wkst, start);
                    byWeekNo = NO_INTS;
                    break;
                }
                if (byDay.length > 0) {
                    dayGenerator = Generators.byDayGenerator(byDay, Frequency.YEARLY == freq && byMonth.length == 0, start);
                    byDay = NO_DAYS;
                    break;
                }
                if (Frequency.YEARLY == freq) {
                    monthGenerator = Generators.byMonthGenerator(new int[]{dtStart.month()}, start);
                }
                dayGenerator = Generators.byMonthDayGenerator(new int[]{dtStart.day()}, start);
            }
        }
        if (secondGenerator == null) {
            secondGenerator = Generators.bySecondGenerator(bySecond, start);
        }
        if (minuteGenerator == null) {
            minuteGenerator = byMinute.length == 0 && freq.compareTo(Frequency.MINUTELY) < 0 ? Generators.serialMinuteGenerator(1, dtStart) : Generators.byMinuteGenerator(byMinute, start);
        }
        if (hourGenerator == null) {
            hourGenerator = byHour.length == 0 && freq.compareTo(Frequency.HOURLY) < 0 ? Generators.serialHourGenerator(1, dtStart) : Generators.byHourGenerator(byHour, start);
        }
        if (dayGenerator == null) {
            boolean dailyOrMoreOften;
            boolean bl = dailyOrMoreOften = freq.compareTo(Frequency.DAILY) <= 0;
            if (byMonthDay.length > 0) {
                dayGenerator = Generators.byMonthDayGenerator(byMonthDay, start);
                byMonthDay = NO_INTS;
            } else if (byDay.length > 0) {
                dayGenerator = Generators.byDayGenerator(byDay, Frequency.YEARLY == freq, start);
                byDay = NO_DAYS;
            } else {
                dayGenerator = dailyOrMoreOften ? Generators.serialDayGenerator(Frequency.DAILY == freq ? interval : 1, dtStart) : Generators.byMonthDayGenerator(new int[]{dtStart.day()}, start);
            }
        }
        if (byDay.length > 0) {
            filters.add(Filters.byDayFilter(byDay, Frequency.YEARLY == freq, wkst));
            byDay = NO_DAYS;
        }
        if (byMonthDay.length > 0) {
            filters.add(Filters.byMonthDayFilter(byMonthDay));
        }
        if (byMonth.length > 0) {
            monthGenerator = Generators.byMonthGenerator(byMonth, start);
        } else if (monthGenerator == null) {
            monthGenerator = Generators.serialMonthGenerator(freq == Frequency.MONTHLY ? interval : 1, dtStart);
        }
        boolean canShortcutAdvance = true;
        if (count != 0) {
            condition = Conditions.countCondition(count);
            canShortcutAdvance = false;
        } else if (untilUtc != null) {
            if (untilUtc instanceof TimeValue != dtStart instanceof TimeValue) {
                untilUtc = dtStart instanceof TimeValue ? TimeUtils.dayStart(untilUtc) : TimeUtils.toDateValue(untilUtc);
            }
            condition = Conditions.untilCondition(untilUtc);
        } else {
            condition = Predicates.alwaysTrue();
        }
        switch (filters.size()) {
            case 0: {
                filter = Predicates.alwaysTrue();
                break;
            }
            case 1: {
                filter = (Predicate)filters.get(0);
                break;
            }
            default: {
                filter = Predicates.and(filters);
            }
        }
        Generator instanceGenerator = bySetPos.length > 0 ? InstanceGenerators.bySetPosInstanceGenerator(bySetPos, freq, wkst, filter, yearGenerator, monthGenerator, dayGenerator, hourGenerator, minuteGenerator, secondGenerator) : InstanceGenerators.serialInstanceGenerator(filter, yearGenerator, monthGenerator, dayGenerator, hourGenerator, minuteGenerator, secondGenerator);
        return new RRuleIteratorImpl(dtStart, tzid, condition, instanceGenerator, yearGenerator, monthGenerator, dayGenerator, hourGenerator, minuteGenerator, secondGenerator, canShortcutAdvance);
    }

    public static RecurrenceIterator join(RecurrenceIterator first, RecurrenceIterator ... rest) {
        ArrayList<RecurrenceIterator> all = new ArrayList<RecurrenceIterator>();
        all.add(first);
        all.addAll(Arrays.asList(rest));
        return new CompoundIteratorImpl(all, Collections.emptyList());
    }

    public static RecurrenceIterator except(RecurrenceIterator included, RecurrenceIterator excluded) {
        return new CompoundIteratorImpl(Collections.singleton(included), Collections.singleton(excluded));
    }

    private static int[] filterBySetPos(int[] members, int[] bySetPos) {
        members = Util.uniquify(members);
        IntSet iset = new IntSet();
        for (int pos : bySetPos) {
            if (pos == 0) continue;
            pos = pos < 0 ? (pos += members.length) : --pos;
            if (pos < 0 || pos >= members.length) continue;
            iset.add(members[pos]);
        }
        return iset.toIntArray();
    }

    private static int[] toIntArray(List<Integer> list) {
        int[] array = new int[list.size()];
        int i = 0;
        for (Integer intObj : list) {
            array[i++] = RecurrenceIteratorFactory.toInt(intObj);
        }
        return array;
    }

    private static int toInt(Integer integer) {
        return integer == null ? 0 : integer;
    }

    private RecurrenceIteratorFactory() {
    }
}

