/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import biweekly.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VersionNumber
implements Comparable<VersionNumber> {
    private final List<Integer> parts = new ArrayList<Integer>();

    public VersionNumber(String version) {
        int start = 0;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c != '.') continue;
            this.addNumber(version, start, i);
            start = i + 1;
        }
        this.addNumber(version, start, version.length());
    }

    private void addNumber(String version, int fromIndex, int toIndex) {
        String numberStr = version.substring(fromIndex, toIndex);
        Integer number = Integer.valueOf(numberStr);
        this.parts.add(number);
    }

    @Override
    public int compareTo(VersionNumber that) {
        Iterator<Integer> it = this.parts.iterator();
        Iterator<Integer> it2 = that.parts.iterator();
        while (it.hasNext() || it2.hasNext()) {
            Integer number = it.hasNext() ? it.next() : 0;
            Integer number2 = it2.hasNext() ? it2.next() : 0;
            if (number < number2) {
                return -1;
            }
            if (number <= number2) continue;
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.parts.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionNumber other = (VersionNumber)obj;
        return this.parts.equals(other.parts);
    }

    public String toString() {
        return StringUtils.join(this.parts, ".");
    }
}

