/*
 * Decompiled with CFR 0.152.
 */
package biweekly.parameter;

import biweekly.ICalVersion;
import biweekly.util.CaseClasses;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ParticipationLevel {
    private static final CaseClasses<ParticipationLevel, String> enums = new CaseClasses<ParticipationLevel, String>(ParticipationLevel.class){

        @Override
        protected ParticipationLevel create(String value) {
            return new ParticipationLevel(value);
        }

        @Override
        protected boolean matches(ParticipationLevel object, String value) {
            for (String v : object.values.values()) {
                if (!v.equalsIgnoreCase(value)) continue;
                return true;
            }
            return false;
        }
    };
    public static final ParticipationLevel REQUIRED;
    public static final ParticipationLevel OPTIONAL;
    public static final ParticipationLevel FYI;
    private final Map<ICalVersion, String> values;

    private ParticipationLevel(Map<ICalVersion, String> values) {
        this.values = Collections.unmodifiableMap(values);
    }

    private ParticipationLevel(String value) {
        HashMap<ICalVersion, String> values = new HashMap<ICalVersion, String>();
        for (ICalVersion version : ICalVersion.values()) {
            values.put(version, value);
        }
        this.values = Collections.unmodifiableMap(values);
    }

    public String getValue(ICalVersion version) {
        return this.values.get((Object)version);
    }

    public String toString() {
        return this.getValue(ICalVersion.V2_0);
    }

    public static ParticipationLevel find(String value) {
        return enums.find(value);
    }

    public static ParticipationLevel get(String value) {
        return enums.get(value);
    }

    public static Collection<ParticipationLevel> all() {
        return enums.all();
    }

    static {
        HashMap<ICalVersion, String> values = new HashMap<ICalVersion, String>();
        values.put(ICalVersion.V1_0, "REQUIRE");
        values.put(ICalVersion.V2_0_DEPRECATED, "REQ-PARTICIPANT");
        values.put(ICalVersion.V2_0, (String)values.get((Object)ICalVersion.V2_0_DEPRECATED));
        REQUIRED = new ParticipationLevel(values);
        values = new HashMap();
        values.put(ICalVersion.V1_0, "REQUEST");
        values.put(ICalVersion.V2_0_DEPRECATED, "OPT-PARTICIPANT");
        values.put(ICalVersion.V2_0, (String)values.get((Object)ICalVersion.V2_0_DEPRECATED));
        OPTIONAL = new ParticipationLevel(values);
        values = new HashMap();
        values.put(ICalVersion.V1_0, "FYI");
        values.put(ICalVersion.V2_0_DEPRECATED, "NON-PARTICIPANT");
        values.put(ICalVersion.V2_0, (String)values.get((Object)ICalVersion.V2_0_DEPRECATED));
        FYI = new ParticipationLevel(values);
    }
}

