/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.xml;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.io.CannotParseException;
import biweekly.io.ParseWarning;
import biweekly.io.SkipMeException;
import biweekly.io.StreamReader;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.component.ICalendarScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalNamespaceContext;
import biweekly.io.xml.XCalOutputProperties;
import biweekly.io.xml.XCalQNames;
import biweekly.io.xml.XCalWriterBase;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.property.Version;
import biweekly.property.Xml;
import biweekly.util.Utf8Writer;
import biweekly.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XCalDocument {
    private static final ICalendarScribe icalMarshaller = ScribeIndex.getICalendarScribe();
    private static final XCalNamespaceContext nsContext = new XCalNamespaceContext("xcal");
    private final Document document;
    private Element icalendarRootElement;

    public XCalDocument(String xml) throws SAXException {
        this(XmlUtils.toDocument(xml));
    }

    public XCalDocument(InputStream in) throws SAXException, IOException {
        this(XmlUtils.toDocument(in));
    }

    public XCalDocument(File file) throws SAXException, IOException {
        this(XmlUtils.toDocument(file));
    }

    public XCalDocument(Reader reader) throws SAXException, IOException {
        this(XmlUtils.toDocument(reader));
    }

    public XCalDocument(Document document) {
        this.document = document;
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsContext);
        try {
            String prefix = nsContext.getPrefix();
            this.icalendarRootElement = (Element)xpath.evaluate("//" + prefix + ":" + XCalQNames.ICALENDAR.getLocalPart(), document, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    public XCalDocument() {
        this.document = XmlUtils.createDocument();
        this.icalendarRootElement = this.document.createElementNS(XCalQNames.ICALENDAR.getNamespaceURI(), XCalQNames.ICALENDAR.getLocalPart());
        this.document.appendChild(this.icalendarRootElement);
    }

    public Document getDocument() {
        return this.document;
    }

    public List<ICalendar> getICalendars() {
        try {
            return this.reader().readAll();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addICalendar(ICalendar ical) {
        this.writer().write(ical);
    }

    public StreamReader reader() {
        return new XCalDocumentStreamReader();
    }

    public XCalDocumentStreamWriter writer() {
        return new XCalDocumentStreamWriter();
    }

    public String write() {
        return this.write((Integer)null);
    }

    public String write(Integer indent) {
        return this.write(indent, null);
    }

    public String write(Integer indent, String xmlVersion) {
        return this.write(new XCalOutputProperties(indent, xmlVersion));
    }

    public String write(Map<String, String> outputProperties) {
        StringWriter sw = new StringWriter();
        try {
            this.write((Writer)sw, outputProperties);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public void write(OutputStream out) throws TransformerException {
        this.write(out, (Integer)null);
    }

    public void write(OutputStream out, Integer indent) throws TransformerException {
        this.write(out, indent, null);
    }

    public void write(OutputStream out, Integer indent, String xmlVersion) throws TransformerException {
        this.write(out, (Map<String, String>)new XCalOutputProperties(indent, xmlVersion));
    }

    public void write(OutputStream out, Map<String, String> outputProperties) throws TransformerException {
        this.write((Writer)new Utf8Writer(out), outputProperties);
    }

    public void write(File file) throws TransformerException, IOException {
        this.write(file, (Integer)null);
    }

    public void write(File file, Integer indent) throws TransformerException, IOException {
        this.write(file, indent, null);
    }

    public void write(File file, Integer indent, String xmlVersion) throws TransformerException, IOException {
        this.write(file, (Map<String, String>)new XCalOutputProperties(indent, xmlVersion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, Map<String, String> outputProperties) throws TransformerException, IOException {
        try (Utf8Writer writer = new Utf8Writer(file);){
            this.write((Writer)writer, outputProperties);
        }
    }

    public void write(Writer writer) throws TransformerException {
        this.write(writer, (Integer)null);
    }

    public void write(Writer writer, Integer indent) throws TransformerException {
        this.write(writer, indent, null);
    }

    public void write(Writer writer, Integer indent, String xmlVersion) throws TransformerException {
        this.write(writer, (Map<String, String>)new XCalOutputProperties(indent, xmlVersion));
    }

    public void write(Writer writer, Map<String, String> outputProperties) throws TransformerException {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry<String, String> entry : outputProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            transformer.setOutputProperty(key, value);
        }
        DOMSource source = new DOMSource(this.document);
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
    }

    public String toString() {
        return this.write(2);
    }

    public class XCalDocumentStreamWriter
    extends XCalWriterBase {
        @Override
        public void write(ICalendar ical) {
            try {
                super.write(ical);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        protected void _write(ICalendar ical) {
            Element element = this.buildComponentElement(ical);
            if (XCalDocument.this.icalendarRootElement == null) {
                XCalDocument.this.icalendarRootElement = this.buildElement(XCalQNames.ICALENDAR);
                Element documentRoot = XCalDocument.this.document.getDocumentElement();
                if (documentRoot == null) {
                    XCalDocument.this.document.appendChild(XCalDocument.this.icalendarRootElement);
                } else {
                    documentRoot.appendChild(XCalDocument.this.icalendarRootElement);
                }
            }
            XCalDocument.this.icalendarRootElement.appendChild(element);
        }

        private Element buildComponentElement(ICalComponent component) {
            ICalComponentScribe<? extends ICalComponent> componentScribe = this.index.getComponentScribe(component);
            Element componentElement = this.buildElement(componentScribe.getComponentName().toLowerCase());
            Element propertiesWrapperElement = this.buildElement(XCalQNames.PROPERTIES);
            List<ICalProperty> propertyObjs = componentScribe.getProperties(component);
            if (component instanceof ICalendar && component.getProperty(Version.class) == null) {
                propertyObjs.add(0, new Version(this.targetVersion));
            }
            for (ICalProperty propertyObj : propertyObjs) {
                this.context.setParent(component);
                ICalProperty property = propertyObj;
                Element propertyElement = this.buildPropertyElement(property);
                if (propertyElement == null) continue;
                propertiesWrapperElement.appendChild(propertyElement);
            }
            if (propertiesWrapperElement.hasChildNodes()) {
                componentElement.appendChild(propertiesWrapperElement);
            }
            List<ICalComponent> subComponents = componentScribe.getComponents(component);
            if (component instanceof ICalendar) {
                Collection<VTimezone> tzs = this.getTimezoneComponents();
                for (VTimezone tz : tzs) {
                    if (subComponents.contains(tz)) continue;
                    subComponents.add(0, tz);
                }
            }
            Element componentsWrapperElement = this.buildElement(XCalQNames.COMPONENTS);
            for (ICalComponent subComponentObj : subComponents) {
                ICalComponent subComponent = subComponentObj;
                Element subComponentElement = this.buildComponentElement(subComponent);
                if (subComponentElement == null) continue;
                componentsWrapperElement.appendChild(subComponentElement);
            }
            if (componentsWrapperElement.hasChildNodes()) {
                componentElement.appendChild(componentsWrapperElement);
            }
            return componentElement;
        }

        private Element buildPropertyElement(ICalProperty property) {
            Element propertyElement;
            ICalPropertyScribe<? extends ICalProperty> scribe = this.index.getPropertyScribe(property);
            if (property instanceof Xml) {
                Xml xml = (Xml)property;
                Document value = (Document)xml.getValue();
                if (value == null) {
                    return null;
                }
                propertyElement = value.getDocumentElement();
                propertyElement = (Element)XCalDocument.this.document.importNode(propertyElement, true);
            } else {
                propertyElement = this.buildElement(scribe.getQName());
                try {
                    scribe.writeXml(property, propertyElement, this.context);
                }
                catch (SkipMeException e) {
                    return null;
                }
            }
            ICalParameters parameters = scribe.prepareParameters(property, this.context);
            if (!parameters.isEmpty()) {
                Element parametersElement = this.buildParametersElement(parameters);
                propertyElement.insertBefore(parametersElement, propertyElement.getFirstChild());
            }
            return propertyElement;
        }

        private Element buildParametersElement(ICalParameters parameters) {
            Element parametersWrapperElement = this.buildElement(XCalQNames.PARAMETERS);
            for (Map.Entry parameter : parameters) {
                String name = ((String)parameter.getKey()).toLowerCase();
                ICalDataType dataType = (ICalDataType)this.parameterDataTypes.get(name);
                String dataTypeStr = dataType == null ? "unknown" : dataType.getName().toLowerCase();
                Element parameterElement = this.buildAndAppendElement(name, parametersWrapperElement);
                for (String parameterValue : parameter.getValue()) {
                    Element parameterValueElement = this.buildAndAppendElement(dataTypeStr, parameterElement);
                    parameterValueElement.setTextContent(parameterValue);
                }
            }
            return parametersWrapperElement;
        }

        private Element buildElement(String localName) {
            return this.buildElement(new QName("urn:ietf:params:xml:ns:icalendar-2.0", localName));
        }

        private Element buildElement(QName qname) {
            return XCalDocument.this.document.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        }

        private Element buildAndAppendElement(String localName, Element parent) {
            return this.buildAndAppendElement(new QName("urn:ietf:params:xml:ns:icalendar-2.0", localName), parent);
        }

        private Element buildAndAppendElement(QName qname, Element parent) {
            Element child = XCalDocument.this.document.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
            parent.appendChild(child);
            return child;
        }

        @Override
        public void close() {
        }
    }

    private class XCalDocumentStreamReader
    extends StreamReader {
        private final Iterator<Element> vcalendarElements = this.getVCalendarElements().iterator();

        private XCalDocumentStreamReader() {
        }

        @Override
        protected ICalendar _readNext() throws IOException {
            if (!this.vcalendarElements.hasNext()) {
                return null;
            }
            this.context.setVersion(ICalVersion.V2_0);
            Element vcalendarElement = this.vcalendarElements.next();
            return this.parseICal(vcalendarElement);
        }

        private ICalendar parseICal(Element icalElement) {
            ICalComponent root = this.parseComponent(icalElement);
            if (root instanceof ICalendar) {
                return (ICalendar)root;
            }
            ICalendar ical = (ICalendar)icalMarshaller.emptyInstance();
            ical.addComponent(root);
            return ical;
        }

        private ICalComponent parseComponent(Element componentElement) {
            ICalComponentScribe<? extends ICalComponent> scribe = this.index.getComponentScribe(componentElement.getLocalName(), ICalVersion.V2_0);
            ICalComponent component = scribe.emptyInstance();
            boolean isICalendar = component instanceof ICalendar;
            for (Element propertyWrapperElement : this.getChildElements(componentElement, XCalQNames.PROPERTIES)) {
                for (Element propertyElement : XmlUtils.toElementList(propertyWrapperElement.getChildNodes())) {
                    Version version;
                    ICalVersion icalVersion;
                    ICalProperty property = this.parseProperty(propertyElement);
                    if (property == null) continue;
                    if (isICalendar && property instanceof Version && (icalVersion = (version = (Version)property).toICalVersion()) != null) {
                        this.context.setVersion(icalVersion);
                        continue;
                    }
                    component.addProperty(property);
                }
            }
            for (Element componentWrapperElement : this.getChildElements(componentElement, XCalQNames.COMPONENTS)) {
                for (Element subComponentElement : XmlUtils.toElementList(componentWrapperElement.getChildNodes())) {
                    if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(subComponentElement.getNamespaceURI())) continue;
                    ICalComponent subComponent = this.parseComponent(subComponentElement);
                    component.addComponent(subComponent);
                }
            }
            return component;
        }

        private ICalProperty parseProperty(Element propertyElement) {
            ICalParameters parameters = this.parseParameters(propertyElement);
            String propertyName = propertyElement.getLocalName();
            QName qname = new QName(propertyElement.getNamespaceURI(), propertyName);
            this.context.getWarnings().clear();
            this.context.setPropertyName(propertyName);
            ICalPropertyScribe<? extends ICalProperty> scribe = this.index.getPropertyScribe(qname);
            try {
                ICalProperty property = scribe.parseXml(propertyElement, parameters, this.context);
                this.warnings.addAll(this.context.getWarnings());
                return property;
            }
            catch (SkipMeException e) {
                this.warnings.add(new ParseWarning.Builder(this.context).message(0, e.getMessage()).build());
                return null;
            }
            catch (CannotParseException e) {
                this.warnings.add(new ParseWarning.Builder(this.context).message(e).build());
                scribe = this.index.getPropertyScribe(Xml.class);
                return scribe.parseXml(propertyElement, parameters, this.context);
            }
        }

        private ICalParameters parseParameters(Element propertyElement) {
            ICalParameters parameters = new ICalParameters();
            for (Element parametersElement : this.getChildElements(propertyElement, XCalQNames.PARAMETERS)) {
                List<Element> paramElements = XmlUtils.toElementList(parametersElement.getChildNodes());
                for (Element paramElement : paramElements) {
                    if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(paramElement.getNamespaceURI())) continue;
                    String name = paramElement.getLocalName().toUpperCase();
                    List<Element> valueElements = XmlUtils.toElementList(paramElement.getChildNodes());
                    if (valueElements.isEmpty()) {
                        String value = paramElement.getTextContent();
                        parameters.put(name, value);
                        continue;
                    }
                    for (Element valueElement : valueElements) {
                        if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(valueElement.getNamespaceURI())) continue;
                        String value = valueElement.getTextContent();
                        parameters.put(name, value);
                    }
                }
            }
            return parameters;
        }

        private List<Element> getVCalendarElements() {
            return XCalDocument.this.icalendarRootElement == null ? Collections.emptyList() : this.getChildElements(XCalDocument.this.icalendarRootElement, XCalQNames.VCALENDAR);
        }

        private List<Element> getChildElements(Element parent, QName qname) {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element child : XmlUtils.toElementList(parent.getChildNodes())) {
                QName childQName = new QName(child.getNamespaceURI(), child.getLocalName());
                if (!qname.equals(childQName)) continue;
                elements.add(child);
            }
            return elements;
        }

        @Override
        public void close() {
        }
    }
}

