/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.chain;

import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.io.chain.ChainingWriter;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.text.ICalWriter;
import biweekly.property.ICalProperty;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.TimeZone;

public class ChainingTextWriter
extends ChainingWriter<ChainingTextWriter> {
    private ICalVersion version;
    private boolean caretEncoding = false;
    private boolean foldLines = true;

    public ChainingTextWriter(Collection<ICalendar> icals) {
        super(icals);
    }

    public ChainingTextWriter version(ICalVersion version) {
        this.version = version;
        return this;
    }

    public ChainingTextWriter caretEncoding(boolean enable) {
        this.caretEncoding = enable;
        return this;
    }

    public ChainingTextWriter foldLines(boolean foldLines) {
        this.foldLines = foldLines;
        return this;
    }

    @Override
    public ChainingTextWriter tz(TimeZone defaultTimeZone, boolean outlookCompatible) {
        return (ChainingTextWriter)super.tz(defaultTimeZone, outlookCompatible);
    }

    @Override
    public ChainingTextWriter register(ICalPropertyScribe<? extends ICalProperty> scribe) {
        return (ChainingTextWriter)super.register(scribe);
    }

    @Override
    public ChainingTextWriter register(ICalComponentScribe<? extends ICalComponent> scribe) {
        return (ChainingTextWriter)super.register(scribe);
    }

    public String go() {
        StringWriter sw = new StringWriter();
        try {
            this.go(sw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public void go(OutputStream out) throws IOException {
        this.go(new ICalWriter(out, this.getICalWriterConstructorVersion()));
    }

    public void go(File file) throws IOException {
        this.go(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go(File file, boolean append) throws IOException {
        try (ICalWriter writer = new ICalWriter(file, append, this.getICalWriterConstructorVersion());){
            this.go(writer);
        }
    }

    public void go(Writer writer) throws IOException {
        this.go(new ICalWriter(writer, this.getICalWriterConstructorVersion()));
    }

    private void go(ICalWriter writer) throws IOException {
        writer.setCaretEncodingEnabled(this.caretEncoding);
        if (!this.foldLines) {
            writer.getVObjectWriter().getFoldedLineWriter().setLineLength(null);
        }
        if (this.defaultTimeZone != null) {
            writer.setGlobalTimezone(this.defaultTimeZone);
        }
        if (this.index != null) {
            writer.setScribeIndex(this.index);
        }
        for (ICalendar ical : this.icals) {
            if (this.version == null) {
                ICalVersion icalVersion = ical.getVersion();
                if (icalVersion == null) {
                    icalVersion = ICalVersion.V2_0;
                }
                writer.setTargetVersion(icalVersion);
            }
            writer.write(ical);
            writer.flush();
        }
    }

    private ICalVersion getICalWriterConstructorVersion() {
        return this.version == null ? ICalVersion.V2_0 : this.version;
    }
}

