/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.LogManager;
import org.jpedal.utils.LogScanner;
import org.jpedal.utils.TimeNow;

public final class LogWriter {
    private static final System.Logger LOG = System.getLogger("idrsolutions.log");
    public static LogScanner logScanner;
    public static String log_name;
    private static boolean verbose;
    private static final Set<String> filterValues;
    public static final boolean isRunningFromIDE;

    private static void createLogFileDirectories() {
        File logDirectory = new File(System.getProperty("user.home") + File.separator + ".idr" + File.separator + "logs");
        if (!logDirectory.exists() && !logDirectory.mkdirs()) {
            LogWriter.writeLog(System.Logger.Level.ERROR, null, "Unable to create log file directory at " + logDirectory.getAbsolutePath());
        }
    }

    private LogWriter() {
    }

    private static Set<String> getFilterSet() {
        String filters = System.getProperty("org.jpedal.inclusiveLogFilters");
        HashSet<String> filterSet = null;
        if (filters != null) {
            filterSet = new HashSet<String>(Arrays.asList(filters.toLowerCase().split(",")));
        }
        return filterSet;
    }

    public static void writeLog(Throwable throwable) {
        LogWriter.writeLog(System.Logger.Level.WARNING, throwable, throwable.toString());
    }

    public static void writeLog(String message) {
        if (message == null) {
            LogWriter.writeLog(System.Logger.Level.WARNING, null, "LogWriter received a null message.");
        } else if (message.toLowerCase().contains("exception")) {
            LogWriter.writeLog(System.Logger.Level.WARNING, null, message);
        } else {
            LogWriter.writeLog(System.Logger.Level.TRACE, null, message);
        }
    }

    public static void setVerbose(boolean verbose) {
        LogWriter.verbose = verbose;
    }

    public static void error(String message) {
        LogWriter.error(null, message);
    }

    public static void error(Throwable exception, String message) {
        LogWriter.writeLog(System.Logger.Level.ERROR, exception, message);
    }

    public static void warning(String message) {
        LogWriter.warning(null, message);
    }

    public static void warning(Throwable exception, String message) {
        LogWriter.writeLog(System.Logger.Level.WARNING, exception, message);
    }

    public static void info(String message) {
        LogWriter.info(null, message);
    }

    public static void info(Throwable exception, String message) {
        LogWriter.writeLog(System.Logger.Level.INFO, exception, message);
    }

    public static void debug(String message) {
        LogWriter.debug(null, message);
    }

    public static void debug(Throwable exception, String message) {
        LogWriter.writeLog(System.Logger.Level.DEBUG, exception, message);
    }

    public static void trace(String message) {
        LogWriter.trace(null, message);
    }

    public static void trace(Throwable exception, String message) {
        LogWriter.writeLog(System.Logger.Level.TRACE, exception, message);
    }

    public static void writeLog(System.Logger.Level level, Throwable exception, String message) {
        if (filterValues == null || filterValues.stream().anyMatch(s -> message.toLowerCase().contains((CharSequence)s))) {
            Object exceptionMessage;
            if (exception == null) {
                exceptionMessage = "";
            } else if (isRunningFromIDE) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                exceptionMessage = "\n    " + exception.getMessage() + "\n    " + String.valueOf(sw);
            } else {
                exceptionMessage = "\n    " + exception.getMessage();
            }
            String compiledMsg = message + (String)exceptionMessage;
            LOG.log(level, compiledMsg);
            if (logScanner != null) {
                logScanner.message(compiledMsg);
            }
            if (verbose) {
                System.out.println(compiledMsg);
            }
            if (log_name != null) {
                try (PrintWriter log_file = new PrintWriter(new FileWriter(log_name, true));){
                    log_file.println(TimeNow.getTimeNow() + " " + compiledMsg);
                }
                catch (Exception e) {
                    System.err.println("Exception " + String.valueOf(e) + " attempting to write to log file " + log_name);
                }
            }
        }
    }

    public static void setupLogFile(String command_line_values) {
        if (command_line_values != null) {
            if (command_line_values.indexOf(118) != -1) {
                verbose = true;
                LogWriter.writeLog("Verbose on");
            } else {
                verbose = false;
            }
        }
        LogWriter.writeLog("Software started - " + TimeNow.getTimeNow());
        LogWriter.writeLog("=======================================================");
    }

    static {
        if (System.getProperty("java.util.logging.config.file") == null) {
            String propertiesFile;
            String predefinedLogger = System.getProperty("org.jpedal.predefinedLogger");
            if (predefinedLogger != null) {
                try {
                    TYPE logType = TYPE.valueOf(predefinedLogger.toUpperCase());
                    switch (logType.ordinal()) {
                        case 0: {
                            propertiesFile = "/consoleLog.properties";
                            break;
                        }
                        case 1: {
                            propertiesFile = "/fileLog.properties";
                            LogWriter.createLogFileDirectories();
                            break;
                        }
                        case 2: {
                            propertiesFile = "/consoleAndFileLog.properties";
                            LogWriter.createLogFileDirectories();
                            break;
                        }
                        default: {
                            propertiesFile = "/noLog.properties";
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    LogWriter.writeLog(System.Logger.Level.ERROR, null, "Log properties called " + predefinedLogger + " does not exist, defaulting to no logging. Possible values are " + Arrays.toString((Object[])TYPE.values()));
                    propertiesFile = null;
                }
            } else {
                propertiesFile = null;
            }
            if (propertiesFile != null) {
                try {
                    URL url = LogWriter.class.getResource(propertiesFile);
                    if (url != null) {
                        LogManager.getLogManager().readConfiguration(url.openStream());
                    }
                }
                catch (IOException e) {
                    LogWriter.writeLog(System.Logger.Level.ERROR, e, "Unable to set up Logging configuration.");
                }
            }
        }
        filterValues = LogWriter.getFilterSet();
        isRunningFromIDE = System.getProperty("debugInIDE") != null && "true".equalsIgnoreCase(System.getProperty("debugInIDE")) && Objects.requireNonNull(LogWriter.class.getResource("LogWriter.class")).toString().startsWith("file:");
    }

    private static enum TYPE {
        CONSOLE,
        FILE,
        CONSOLE_AND_FILE,
        NONE;

    }
}

