/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.imageio;

import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.image.utility.SupportedFormats;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public final class ImageIOSupport {
    private static final Set<InputFormat> currentSupportedReaders = EnumSet.of(InputFormat.HEIC);
    private static final Set<OutputFormat> currentSupportedWriters = EnumSet.of(OutputFormat.HEIC);

    private ImageIOSupport() {
    }

    public static boolean jdeliSupportedformatsForDecoding(String formatName) {
        return SupportedFormats.hasDecoderSupportForImageFormat(formatName);
    }

    public static boolean jdeliSupportedformatsForEncoding(String formatName) {
        return SupportedFormats.hasEncoderSupportForImageFormat(formatName);
    }

    public static boolean isregisteredReader(InputFormat format) {
        return currentSupportedReaders.contains((Object)format);
    }

    public static boolean isregisteredWriter(OutputFormat format) {
        return currentSupportedWriters.contains((Object)format);
    }

    public static void registerReader(InputFormat format) {
        if (!ImageIOSupport.isregisteredReader(format)) {
            currentSupportedReaders.add(format);
        }
    }

    public static void registerReaders(InputFormat[] formats) {
        Arrays.stream(formats).iterator().forEachRemaining(format -> {
            if (!ImageIOSupport.isregisteredReader(format)) {
                currentSupportedReaders.add((InputFormat)((Object)format));
            }
        });
    }

    public static void unregisterReader(InputFormat format) {
        if (ImageIOSupport.isregisteredReader(format)) {
            currentSupportedReaders.remove((Object)format);
        }
    }

    public static void registerWriters(OutputFormat[] formats) {
        Arrays.stream(formats).iterator().forEachRemaining(format -> {
            if (!ImageIOSupport.isregisteredWriter(format)) {
                currentSupportedWriters.add((OutputFormat)((Object)format));
            }
        });
    }

    public static void registerWriter(OutputFormat format) {
        if (!ImageIOSupport.isregisteredWriter(format)) {
            currentSupportedWriters.add(format);
        }
    }

    public static void unregisterWriter(OutputFormat format) {
        if (ImageIOSupport.isregisteredWriter(format)) {
            currentSupportedWriters.remove((Object)format);
        }
    }

    public static enum InputFormat {
        BMP,
        DCM,
        HEIC,
        EMF,
        GIF,
        JPEG2000,
        JPEGXL,
        JPEG,
        PNG,
        PSD,
        SGI,
        TIF,
        WEBP,
        WMF;

    }
}

