/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.wmf;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.emf.data.DC;
import com.idrsolutions.image.emf.data.FM;
import com.idrsolutions.image.emf.data.ImageSpace;
import com.idrsolutions.image.emf.data.Space;
import com.idrsolutions.image.emf.data.SvgSpace;
import com.idrsolutions.image.utility.DataByteLittle;
import com.idrsolutions.image.utility.DataFileLittle;
import com.idrsolutions.image.utility.DataReader;
import com.idrsolutions.image.utility.WriterByteLittle;
import com.idrsolutions.image.utility.WriterFileBig;
import com.idrsolutions.image.wmf.data.WmfObject;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;

public class WmfDecoder
extends JDeliImage
implements Decoder {
    private static final int EOF = 0;
    private static final int REALIZEPALETTE = 53;
    private static final int SETPALENTRIES = 55;
    private static final int SETBKMODE = 258;
    private static final int SETMAPMODE = 259;
    private static final int SETROP2 = 260;
    private static final int SETRELABS = 261;
    private static final int SETPOLYFILLMODE = 262;
    private static final int SETSTRETCHBLTMODE = 263;
    private static final int SETTEXTCHAREXTRA = 264;
    private static final int RESTOREDC = 295;
    private static final int RESIZEPALETTE = 313;
    private static final int DIBCREATEPATTERNBRUSH = 322;
    private static final int SETLAYOUT = 329;
    private static final int SETBKCOLOR = 513;
    private static final int SETTEXTCOLOR = 521;
    private static final int OFFSETVIEWPORTORG = 529;
    private static final int LINETO = 531;
    private static final int MOVETO = 532;
    private static final int OFFSETCLIPRGN = 544;
    private static final int FILLREGION = 552;
    private static final int SETMAPPERFLAGS = 561;
    private static final int SELECTPALETTE = 564;
    private static final int POLYGON = 804;
    private static final int POLYLINE = 805;
    private static final int SETTEXTJUSTIFICATION = 522;
    private static final int SETWINDOWORG = 523;
    private static final int SETWINDOWEXT = 524;
    private static final int SETVIEWPORTORG = 525;
    private static final int SETVIEWPORTEXT = 526;
    private static final int OFFSETWINDOWORG = 527;
    private static final int SCALEWINDOWEXT = 1040;
    private static final int SCALEVIEWPORTEXT = 1042;
    private static final int EXCLUDECLIPRECT = 1045;
    private static final int INTERSECTCLIPRECT = 1046;
    private static final int ELLIPSE = 1048;
    private static final int FLOODFILL = 1049;
    private static final int FRAMEREGION = 1065;
    private static final int ANIMATEPALETTE = 1078;
    private static final int TEXTOUT = 1313;
    private static final int POLYPOLYGON = 1336;
    private static final int EXTFLOODFILL = 1352;
    private static final int RECTANGLE = 1051;
    private static final int SETPIXEL = 1055;
    private static final int ROUNDRECT = 1564;
    private static final int PATBLT = 1565;
    private static final int SAVEDC = 30;
    private static final int PIE = 2074;
    private static final int STRETCHBLT = 2851;
    private static final int ESCAPE = 1574;
    private static final int INVERTREGION = 298;
    private static final int PAINTREGION = 299;
    private static final int SELECTCLIPREGION = 300;
    private static final int SELECTOBJECT = 301;
    private static final int SETTEXTALIGN = 302;
    private static final int ARC = 2071;
    private static final int CHORD = 2096;
    private static final int BITBLT = 2338;
    private static final int EXTTEXTOUT = 2610;
    private static final int SETDIBTODEV = 3379;
    private static final int DIBBITBLT = 2368;
    private static final int DIBSTRETCHBLT = 2881;
    private static final int STRETCHDIB = 3907;
    private static final int DELETEOBJECT = 496;
    private static final int CREATEPALETTE = 247;
    private static final int CREATEPATTERNBRUSH = 505;
    private static final int CREATEPENINDIRECT = 762;
    private static final int CREATEFONTINDIRECT = 763;
    private static final int CREATEBRUSHINDIRECT = 764;
    private static final int CREATEREGION = 1791;
    private WmfObject[] objects = new WmfObject[1000];
    private final int[] pCmds = new int[32768];
    private int[] path;
    private int pc;
    private final ArrayDeque<DC> dcStack = new ArrayDeque();
    private int imageW = 1000;
    private int imageH = 1000;
    private int imageX;
    private int imageY;
    float[][] lbb = FM.getIdentity();
    private int wox;
    private int woy;

    @Override
    public BufferedImage read(File file) throws IOException {
        DataFileLittle reader = new DataFileLittle(file);
        this.parseHeader(reader);
        BufferedImage image = new BufferedImage(this.imageW, this.imageH, 2);
        ImageSpace space = new ImageSpace(image);
        this.parseRecords(reader, space);
        reader.close();
        return image;
    }

    @Override
    public BufferedImage read(byte[] data) throws Exception {
        DataByteLittle reader = new DataByteLittle(data);
        this.parseHeader(reader);
        BufferedImage image = new BufferedImage(this.imageW, this.imageH, 2);
        ImageSpace space = new ImageSpace(image);
        float[][] ctm = space.getMatrix();
        ctm[2][0] = this.imageX;
        ctm[2][1] = this.imageY;
        this.parseRecords(reader, space);
        reader.close();
        return image;
    }

    @Override
    public Rectangle readDimension(File file) throws Exception {
        DataFileLittle reader = new DataFileLittle(file);
        this.parseHeader(reader);
        reader.close();
        return new Rectangle(this.imageW, this.imageH);
    }

    @Override
    public Rectangle readDimension(byte[] wmfRawData) throws Exception {
        DataByteLittle reader = new DataByteLittle(wmfRawData);
        this.parseHeader(reader);
        return new Rectangle(this.imageW, this.imageH);
    }

    public static void toSVG(File wmfFile, File svgOutputFile) throws IOException {
        String sb = WmfDecoder.getSvgString(wmfFile);
        WriterFileBig fw = new WriterFileBig(svgOutputFile);
        fw.write(sb.getBytes());
        fw.close();
    }

    public static void toSVG(FileInputStream wmfInputStream, FileOutputStream svgOutputFile) throws IOException {
        File wmfFile = File.createTempFile("idr", "wmf");
        try (BufferedInputStream from = new BufferedInputStream(wmfInputStream);
             BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(wmfFile));){
            byte[] data = new byte[wmfInputStream.available()];
            from.read(data);
            fos.write(data);
        }
        String sb = WmfDecoder.getSvgString(wmfFile);
        WriterFileBig fw = new WriterFileBig(svgOutputFile);
        fw.write(sb.getBytes());
        fw.close();
        wmfFile.delete();
    }

    private static String getSvgString(File wmfFile) throws IOException {
        DataFileLittle reader = new DataFileLittle(wmfFile);
        StringBuilder sb = new StringBuilder();
        SvgSpace space = new SvgSpace(sb);
        WmfDecoder wmfDecoder = new WmfDecoder();
        wmfDecoder.parseHeader(reader);
        wmfDecoder.parseRecords(reader, space);
        space.close();
        return sb.toString();
    }

    private void parseHeader(DataReader reader) throws IOException {
        int key = reader.getU32();
        if (key == -1698247209) {
            int hwmf = reader.getU16();
            this.imageX = (short)reader.getU16();
            this.imageY = (short)reader.getU16();
            short imageX2 = (short)reader.getU16();
            short imageY2 = (short)reader.getU16();
            reader.getU16();
            this.imageW = imageX2 - this.imageX;
            this.imageH = imageY2 - this.imageY;
            reader.skip(6);
            reader.getU16();
            reader.getU16();
        }
        reader.skip(2);
        reader.getU32();
        int nObjects = reader.getU16();
        this.objects = new WmfObject[nObjects];
        reader.skip(6);
    }

    private void parseRecords(DataReader reader, Space space) throws IOException {
        boolean canRead = true;
        while (canRead && reader.getPosition() < reader.getLength()) {
            int pos = reader.getPosition();
            int size = reader.getU32() << 1;
            int type = reader.getU16();
            switch (type) {
                case 0: {
                    canRead = false;
                    break;
                }
                case 295: {
                    this.restoreDC(reader, space);
                    break;
                }
                case 521: {
                    WmfDecoder.setTextColor(reader, space);
                    break;
                }
                case 531: {
                    this.lineTo(reader);
                    break;
                }
                case 532: {
                    this.moveTO(reader);
                    break;
                }
                case 804: {
                    this.polygon(reader, space);
                    break;
                }
                case 805: {
                    this.polyline(reader, space);
                    break;
                }
                case 523: {
                    this.setwindoworg(reader);
                    break;
                }
                case 524: {
                    this.setwindowext(reader, space);
                    break;
                }
                case 2610: {
                    WmfDecoder.exttextout(reader, space);
                    break;
                }
                case 1313: {
                    WmfDecoder.textout(reader, space);
                    break;
                }
                case 1048: {
                    WmfDecoder.ellipse(reader, space);
                    break;
                }
                case 1336: {
                    this.polyPolygon(reader, space);
                    break;
                }
                case 1051: {
                    this.rectangle(reader, space);
                    break;
                }
                case 1055: {
                    this.setpixel(reader, space);
                    break;
                }
                case 1564: {
                    this.roundRectangle(reader, space);
                    break;
                }
                case 30: {
                    this.saveDC(space);
                    break;
                }
                case 300: 
                case 301: 
                case 564: {
                    this.selectObject(reader, space);
                    break;
                }
                case 3907: {
                    WmfDecoder.stretchdib(reader, space);
                    break;
                }
                case 496: {
                    this.deleteObject(reader);
                    break;
                }
                case 247: 
                case 505: 
                case 762: 
                case 763: 
                case 764: 
                case 1791: {
                    this.createObject(type, pos);
                }
            }
            reader.moveTo(pos + size);
        }
    }

    private void createObject(int type, int offset) {
        int op = 0;
        while (this.objects[op] != null) {
            ++op;
        }
        this.objects[op] = new WmfObject(type, offset);
    }

    private void deleteObject(DataReader reader) throws IOException {
        int pos = reader.getU16();
        this.objects[pos] = null;
    }

    private void selectObject(DataReader reader, Space space) throws IOException {
        int cp = reader.getU16();
        WmfObject obj = this.objects[cp];
        if (obj != null) {
            reader.moveTo(obj.offset + 6);
            switch (obj.type) {
                case 764: {
                    int brushStyle = reader.getU16();
                    int brushColor = 0xFF000000 | reader.getU8() << 16 | reader.getU8() << 8 | reader.getU8();
                    reader.getU8();
                    int brushHatch = reader.getU16();
                    switch (brushStyle) {
                        case 0: {
                            space.setFC(brushColor);
                            break;
                        }
                        case 1: {
                            space.setFC(0);
                        }
                    }
                    break;
                }
                case 505: {
                    break;
                }
                case 762: {
                    int pStyle = reader.getU16();
                    int pWidth = reader.getU16();
                    reader.skip(2);
                    space.sStyle(pStyle);
                    space.setSW(pWidth);
                    int penColor = 0xFF000000 | reader.getU8() << 16 | reader.getU8() << 8 | reader.getU8();
                    reader.getU8();
                    space.setSC(penColor);
                    break;
                }
                case 763: {
                    int c;
                    int fontSize = Math.abs((short)reader.getU16());
                    int width = reader.getU16();
                    int esc = reader.getU16();
                    int orient = reader.getU16();
                    int weight = reader.getU16();
                    int italic = reader.getU8();
                    int underline = reader.getU8();
                    int strikeout = reader.getU8();
                    int charset = reader.getU8();
                    reader.skip(4);
                    int fontWeight = weight == 700 ? 1 : 0;
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < 32 && (c = reader.getU8()) != 0; ++i) {
                        sb.append((char)c);
                    }
                    String name = sb.toString();
                    if (name.isEmpty()) break;
                    space.font(name, Math.abs(fontSize), fontWeight);
                }
            }
        }
    }

    private void saveDC(Space space) {
        DC dc = new DC();
        dc.fc = space.getFC();
        dc.sc = space.getSC();
        dc.fontC = space.getFontC();
        dc.mm = space.getMatrix();
        dc.fontName = space.getFontName();
        dc.fontSize = space.getFontSize();
        dc.design = space.getDesign();
        this.dcStack.push(dc);
    }

    private void restoreDC(DataReader reader, Space space) throws IOException {
        if (!this.dcStack.isEmpty()) {
            DC dc = this.dcStack.pop();
            for (int loc = reader.getU16(); loc < -1; ++loc) {
                dc = this.dcStack.pop();
            }
            space.setFC(dc.fc);
            space.setSC(dc.sc);
            space.setFontC(dc.fontC);
            space.setMatrix(dc.mm);
            space.setFontName(dc.fontName);
            space.setFontSize(dc.fontSize);
            space.setDesign(dc.design);
        }
    }

    private void lineTo(DataReader reader) throws IOException {
        short curY = (short)reader.getU16();
        short curX = (short)reader.getU16();
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = curX;
        this.pCmds[this.pc++] = curY;
    }

    private void moveTO(DataReader reader) throws IOException {
        short curY = (short)reader.getU16();
        short curX = (short)reader.getU16();
        this.pCmds[this.pc++] = 0;
        this.pCmds[this.pc++] = curX;
        this.pCmds[this.pc++] = curY;
    }

    private void rectangle(DataReader reader, Space space) throws IOException {
        short b0 = (short)reader.getU16();
        short b1 = (short)reader.getU16();
        short b2 = (short)reader.getU16();
        short b3 = (short)reader.getU16();
        this.pCmds[this.pc++] = 0;
        this.pCmds[this.pc++] = b0;
        this.pCmds[this.pc++] = b1;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b2;
        this.pCmds[this.pc++] = b1;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b2;
        this.pCmds[this.pc++] = b3;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b0;
        this.pCmds[this.pc++] = b3;
        this.pCmds[this.pc++] = 4;
        this.path = new int[this.pc];
        System.arraycopy(this.pCmds, 0, this.path, 0, this.pc);
        this.pc = 0;
        space.fPath(this.path);
        space.sPath(this.path);
    }

    private void setpixel(DataReader reader, Space space) throws IOException {
        short b0 = (short)reader.getU16();
        short b1 = (short)reader.getU16();
        int b2 = b0 + 1;
        int b3 = b1 + 1;
        int oldColor = space.getFC();
        int color = 0xFF000000 | reader.getU8() << 16 | reader.getU8() << 8 | reader.getU8();
        space.setFC(color);
        this.pCmds[this.pc++] = 0;
        this.pCmds[this.pc++] = b0;
        this.pCmds[this.pc++] = b1;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b2;
        this.pCmds[this.pc++] = b1;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b2;
        this.pCmds[this.pc++] = b3;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b0;
        this.pCmds[this.pc++] = b3;
        this.pCmds[this.pc++] = 4;
        this.path = new int[this.pc];
        System.arraycopy(this.pCmds, 0, this.path, 0, this.pc);
        this.pc = 0;
        space.fPath(this.path);
        space.setFC(oldColor);
    }

    private static void ellipse(DataReader reader, Space space) throws IOException {
        short b1 = (short)reader.getU16();
        short b0 = (short)reader.getU16();
        short b3 = (short)reader.getU16();
        short b2 = (short)reader.getU16();
        int w = Math.abs(b2 - b0);
        int h = Math.abs(b3 - b1);
        int x = Math.min(b0, b2);
        int y = Math.min(b3, b1);
        space.ellipse(x, y, w, h);
    }

    private void roundRectangle(DataReader reader, Space space) throws IOException {
        short b0 = (short)reader.getU16();
        short b1 = (short)reader.getU16();
        short b2 = (short)reader.getU16();
        short b3 = (short)reader.getU16();
        this.pCmds[this.pc++] = 0;
        this.pCmds[this.pc++] = b0;
        this.pCmds[this.pc++] = b1;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b2;
        this.pCmds[this.pc++] = b1;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b2;
        this.pCmds[this.pc++] = b3;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b0;
        this.pCmds[this.pc++] = b3;
        this.pCmds[this.pc++] = 4;
        this.path = new int[this.pc];
        System.arraycopy(this.pCmds, 0, this.path, 0, this.pc);
        this.pc = 0;
        space.fPath(this.path);
        space.sPath(this.path);
    }

    private void polyline(DataReader reader, Space space) throws IOException {
        int count = reader.getU16();
        for (int i = 0; i < count; ++i) {
            int x = reader.getU16();
            int y = reader.getU16();
            this.pCmds[this.pc++] = i == 0 ? 0 : 1;
            this.pCmds[this.pc++] = x;
            this.pCmds[this.pc++] = y;
        }
        this.strokePath(space);
    }

    private void polygon(DataReader reader, Space space) throws IOException {
        int count = reader.getU16();
        for (int i = 0; i < count; ++i) {
            short x = (short)reader.getU16();
            short y = (short)reader.getU16();
            this.pCmds[this.pc++] = i == 0 ? 0 : 1;
            this.pCmds[this.pc++] = x;
            this.pCmds[this.pc++] = y;
        }
        this.closeFigure();
        this.strokeFillPath(space);
    }

    private void polyPolygon(DataReader reader, Space space) throws IOException {
        int nPolygons = reader.getU16();
        int[] ppCount = new int[nPolygons];
        for (int i = 0; i < nPolygons; ++i) {
            ppCount[i] = reader.getU16();
        }
        for (int i = 0; i < nPolygons; ++i) {
            int c = 0;
            for (int j = 0; j < ppCount[i]; ++j) {
                short x = (short)reader.getU16();
                short y = (short)reader.getU16();
                this.pCmds[this.pc++] = c == 0 ? 0 : 1;
                this.pCmds[this.pc++] = x;
                this.pCmds[this.pc++] = y;
                ++c;
            }
            this.closeFigure();
            this.strokeFillPath(space);
        }
    }

    private void closeFigure() {
        if (this.pc > 2) {
            this.pCmds[this.pc++] = 4;
        }
    }

    private static void stretchdib(DataReader reader, Space space) throws IOException {
        int ras = reader.getU32();
        int colUsage = reader.getU16();
        short srcH = (short)reader.getU16();
        short srcW = (short)reader.getU16();
        short ySrc = (short)reader.getU16();
        short xSrc = (short)reader.getU16();
        short dstH = (short)reader.getU16();
        short dstW = (short)reader.getU16();
        short yDest = (short)reader.getU16();
        short xDest = (short)reader.getU16();
        float[][] cm = space.getMatrix();
        float[][] im = FM.getIdentity();
        if (xDest != 0) {
            im[0][0] = (float)xDest * 1.0f / (float)xSrc;
        }
        if (yDest != 0) {
            im[1][1] = (float)yDest * 1.0f / (float)ySrc;
        }
        space.setMatrix(FM.concatenate(cm, im));
        int headerSize = reader.getU32();
        int width = reader.getU32();
        int height = reader.getU32();
        int planes = reader.getU16();
        int bitcount = reader.getU16();
        int compression = reader.getU32();
        int imageSize = reader.getU32();
        reader.skip(16);
        reader.moveTo(reader.getPosition() - 40);
        byte[] bHeader = new byte[headerSize];
        reader.read(bHeader);
        byte[] bData = new byte[imageSize];
        reader.read(bData);
        byte[] output = new byte[14 + headerSize + imageSize];
        WriterByteLittle writer = new WriterByteLittle(output);
        writer.putU16(19778);
        writer.putU32(output.length);
        writer.putU32(0);
        writer.putU32(14 + headerSize);
        writer.write(bHeader);
        writer.write(bData);
        space.bmpImage(xDest, yDest, output);
        space.setMatrix(cm);
    }

    private void strokePath(Space space) {
        this.path = new int[this.pc];
        System.arraycopy(this.pCmds, 0, this.path, 0, this.pc);
        this.pc = 0;
        space.sPath(this.path);
    }

    private void strokeFillPath(Space space) {
        this.path = new int[this.pc];
        System.arraycopy(this.pCmds, 0, this.path, 0, this.pc);
        this.pc = 0;
        space.sfPath(this.path);
    }

    private static void setTextColor(DataReader reader, Space space) throws IOException {
        int fontColor = 0xFF000000 | reader.getU8() << 16 | reader.getU8() << 8 | reader.getU8();
        reader.skip(1);
        space.setFontC(fontColor);
    }

    private static void exttextout(DataReader reader, Space space) throws IOException {
        short y = (short)reader.getU16();
        short x = (short)reader.getU16();
        int sLen = reader.getU16();
        int fwOpts = reader.getU16();
        if ((fwOpts & 6) > 0) {
            reader.skip(8);
        }
        byte[] data = new byte[sLen];
        reader.read(data);
        space.text(x, y, new String(data));
    }

    private static void textout(DataReader reader, Space space) throws IOException {
        int sLen = reader.getU16();
        byte[] data = new byte[sLen];
        reader.read(data);
        short y = (short)reader.getU16();
        short x = (short)reader.getU16();
        space.text(x, y, new String(data));
    }

    private void setwindoworg(DataReader reader) throws IOException {
        this.woy = (short)reader.getU16();
        this.wox = (short)reader.getU16();
    }

    private void setwindowext(DataReader reader, Space space) throws IOException {
        short wey = (short)reader.getU16();
        short wex = (short)reader.getU16();
        float windowW = Math.abs(this.wox + wex - this.wox);
        float windowH = Math.abs(this.woy + wey - this.woy);
        float sx = (float)this.imageW / windowW;
        float sy = (float)this.imageH / windowH;
        float[][] ww = FM.getIdentity();
        if (wex < 0) {
            ww[0][0] = -1.0f;
            ww[2][0] = this.wox;
        } else {
            ww[0][0] = 1.0f;
            ww[2][0] = -this.wox;
        }
        if (wey < 0) {
            ww[1][1] = -1.0f;
            ww[2][1] = this.woy;
        } else {
            ww[1][1] = 1.0f;
            ww[2][1] = -this.woy;
        }
        if (sx != 1.0f || sy != 1.0f) {
            float[][] w2 = FM.getIdentity();
            w2[0][0] = sx;
            w2[1][1] = sy;
            ww = FM.multiply(ww, w2);
        }
        space.setMatrix(ww);
    }
}

