/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.utility.Access;
import com.idrsolutions.image.utility.PixGet;
import com.idrsolutions.image.utility.WriterByteLittle;
import com.idrsolutions.image.webp.enc.AlgoFlags;
import com.idrsolutions.image.webp.enc.CXInterface;
import com.idrsolutions.image.webp.enc.CodecAlgPRiv;
import com.idrsolutions.image.webp.enc.CodecEncCfg;
import com.idrsolutions.image.webp.enc.CodecPkt;
import com.idrsolutions.image.webp.enc.ExtraCFG;
import com.idrsolutions.image.webp.enc.Picture;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Iterator;

public final class VP8Encoder {
    static final short INT_TO_BYTE_OFFSET = 128;
    final CodecEncCfg cfg = new CodecEncCfg();
    final ExtraCFG vp8Cfg = new ExtraCFG();
    CodecAlgPRiv ctx;
    int pts;

    public static void encodeWEBP(BufferedImage bImg, OutputStream out, int qp) throws IOException {
        VP8Encoder enc = new VP8Encoder((short)qp);
        Picture pic = VP8Encoder.getPictureFromBuffer(bImg);
        byte[] bufData = enc.encodeFrame(pic);
        int frameSize = bufData.length;
        int frameAdd = frameSize % 2 != 0 ? frameSize + 1 : frameSize;
        byte[] temp = new byte[frameAdd];
        System.arraycopy(bufData, 0, temp, 0, frameSize);
        int dataLen = 20 + frameAdd;
        byte[] data = new byte[dataLen];
        WriterByteLittle endian = new WriterByteLittle(data);
        endian.write("RIFF".getBytes());
        endian.putU32(data.length - 8);
        endian.write("WEBP".getBytes());
        endian.write("VP8 ".getBytes());
        endian.putU32(frameAdd);
        endian.write(temp);
        out.write(data);
    }

    private static Picture getPictureFromBuffer(BufferedImage img) {
        int b;
        int g;
        int r;
        int p;
        int x;
        int y;
        int w = img.getWidth();
        int h = img.getHeight();
        int dim = w * h;
        int strideC = w / 2;
        int cw = (w + 1) / 2;
        int ch = (h + 1) / 2;
        byte[][] data = new byte[][]{new byte[dim], new byte[ch * cw], new byte[ch * cw]};
        PixGet pg = Access.getPixGet(img);
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                p = pg.getRGB(x, y);
                r = p >> 16 & 0xFF;
                g = p >> 8 & 0xFF;
                b = p & 0xFF;
                data[0][y * w + x] = (byte)((128 + 66 * r + 129 * g + 25 * b >> 8) - 112);
            }
        }
        for (y = 0; y < h; y += 2) {
            for (x = 0; x < w; x += 2) {
                p = pg.getRGB(x, y);
                r = p >> 16 & 0xFF;
                g = p >> 8 & 0xFF;
                b = p & 0xFF;
                p = y / 2 * strideC + x / 2;
                data[1][p] = (byte)(128 - 38 * r - 74 * g + 112 * b >> 8);
                data[2][p] = (byte)(128 + 112 * r - 94 * g - 18 * b >> 8);
            }
        }
        return Picture.createPicture(img.getWidth(), img.getHeight(), data);
    }

    private VP8Encoder(short qp) {
        if (qp >= 0) {
            this.cfg.setRc_max_quantizer(qp);
        }
    }

    private byte[] encodeFrame(Picture pic) {
        if (this.ctx == null) {
            this.cfg.setG_w(pic.getWidth());
            this.cfg.setG_h(pic.getHeight());
            this.ctx = new CodecAlgPRiv(this.cfg, this.vp8Cfg);
        }
        CXInterface.vp8e_encode(this.ctx, pic, this.pts++, EnumSet.noneOf(AlgoFlags.class));
        CodecPkt ret = CodecAlgPRiv.vpx_codec_get_cx_data(this.ctx.base, new Iterator[1]);
        CodecPkt.FramePacket fp = (CodecPkt.FramePacket)ret.packet;
        byte[] temp = new byte[fp.sz];
        for (int i = 0; i < fp.sz; ++i) {
            temp[i] = (byte)fp.buf.getRel(i);
        }
        return temp;
    }
}

