/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.BlockD;
import com.idrsolutions.image.webp.enc.Compressor;
import com.idrsolutions.image.webp.enc.DCTValueConstants;
import com.idrsolutions.image.webp.enc.EntropyPlanes;
import com.idrsolutions.image.webp.enc.FullGenArrPointer;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.Macroblock;
import com.idrsolutions.image.webp.enc.MacroblockD;
import com.idrsolutions.image.webp.enc.PlaneType;
import com.idrsolutions.image.webp.enc.TokenAlphabet;
import com.idrsolutions.image.webp.enc.TokenExtra;
import com.idrsolutions.image.webp.enc.TokenValue;
import com.idrsolutions.image.webp.enc.VP8Util;
import com.idrsolutions.image.webp.enc.WebpConst;

final class Tokenize {
    private Tokenize() {
    }

    private static TokenExtra configureToken(FullGenArrPointer<TokenExtra> tp, TokenAlphabet tok, Compressor cpi, PlaneType type, int band, int pt, boolean skip) {
        int typ = type.ordinal();
        TokenExtra t = tp.get();
        if (t == null) {
            t = new TokenExtra();
            tp.setAndInc(t);
        } else {
            tp.inc();
        }
        t.Token = tok;
        t.context_tree = cpi.common.fc.coef_probs[typ][band][pt];
        t.skip_eob_node = skip;
        int[] nArray = cpi.mb.coef_counts[typ][band][pt];
        int n = tok.ordinal();
        nArray[n] = nArray[n] + 1;
        return t;
    }

    private static void configureAsEob(FullGenArrPointer<TokenExtra> tp, Compressor cpi, PlaneType type, int band, int pt) {
        Tokenize.configureToken(tp, TokenAlphabet.DCT_EOB_TOKEN, cpi, type, band, pt, false);
    }

    private static int configureAsGeneric(FullGenArrPointer<TokenExtra> tp, Compressor cpi, int v, PlaneType type, int band, int pt, boolean skip) {
        TokenValue tv = DCTValueConstants.getTokenValue(v);
        TokenAlphabet token = tv.token;
        TokenExtra t = Tokenize.configureToken(tp, token, cpi, type, band, pt, skip);
        t.Extra = tv.extra;
        return token.previousTokenClass;
    }

    static void tokenize2nd_order_b(Macroblock x, FullGenArrPointer<TokenExtra> tp, Compressor cpi) {
        MacroblockD xd = x.e_mbd;
        Tokenize.singleBlockfinalizeTokenize(PlaneType.Y2, tp, cpi, 24, xd.above_context.get().panes, xd.left_context.panes);
    }

    static void tokenize1st_order_b(Macroblock x, FullGenArrPointer<TokenExtra> tp, PlaneType type, Compressor cpi) {
        int block;
        MacroblockD xd = x.e_mbd;
        FullGetSetPointer a = xd.above_context.get().panes;
        FullGetSetPointer l = xd.left_context.panes;
        for (block = 0; block < 16; ++block) {
            Tokenize.singleBlockfinalizeTokenize(type, tp, cpi, block, a, l);
        }
        for (block = 16; block < 24; ++block) {
            Tokenize.singleBlockfinalizeTokenize(PlaneType.UV, tp, cpi, block, a, l);
        }
    }

    private static void singleBlockfinalizeTokenize(PlaneType type, FullGenArrPointer<TokenExtra> tp, Compressor cpi, int block, FullGetSetPointer a, FullGetSetPointer l) {
        BlockD bd = cpi.mb.e_mbd.block.getRel(block);
        short eob = bd.eob.get();
        FullGetSetPointer qcoeff_ptr = bd.qcoeff;
        int aPos = BlockD.vp8_block2above[block];
        int lPos = BlockD.vp8_block2left[block];
        int pt = a.getRel(aPos) + l.getRel(lPos);
        int c = type.start_coeff;
        if (c >= eob) {
            Tokenize.configureAsEob(tp, cpi, type, c, pt);
            a.setRel(aPos, l.setRel(lPos, (short)0));
            return;
        }
        short v = qcoeff_ptr.getRel(c);
        pt = Tokenize.configureAsGeneric(tp, cpi, v, type, c, pt, false);
        ++c;
        assert (eob <= 16);
        while (c < eob) {
            int rc = WebpConst.zigzag[c];
            v = qcoeff_ptr.getRel(rc);
            pt = Tokenize.configureAsGeneric(tp, cpi, v, type, VP8Util.SubblockKeys.vp8CoefBands[c], pt, pt == 0);
            ++c;
        }
        if (c < 16) {
            Tokenize.configureAsEob(tp, cpi, type, VP8Util.SubblockKeys.vp8CoefBands[c], pt);
        }
        a.setRel(aPos, l.setRel(lPos, (short)1));
    }

    private static void stuffOrderHelper(FullGenArrPointer<TokenExtra> tp, FullGetSetPointer a, FullGetSetPointer l, Compressor cpi, PlaneType plane, int band) {
        int pt = a.get() + l.get();
        Tokenize.configureAsEob(tp, cpi, plane, band, pt);
        a.set(l.set((short)0));
    }

    static void stuff2nd_order_b(FullGenArrPointer<TokenExtra> tp, FullGetSetPointer a, FullGetSetPointer l, Compressor cpi) {
        Tokenize.stuffOrderHelper(tp, a, l, cpi, PlaneType.Y2, 0);
    }

    static void stuff1st_order_b(FullGenArrPointer<TokenExtra> tp, FullGetSetPointer a, FullGetSetPointer l, PlaneType type, Compressor cpi) {
        Tokenize.stuffOrderHelper(tp, a, l, cpi, type, type == PlaneType.Y_NO_DC ? 0 : 1);
    }

    static void stuff1st_order_buv(FullGenArrPointer<TokenExtra> tp, FullGetSetPointer a, FullGetSetPointer l, Compressor cpi) {
        Tokenize.stuffOrderHelper(tp, a, l, cpi, PlaneType.UV, 0);
    }

    static void vp8_stuff_mb(Compressor cpi, Macroblock x, FullGenArrPointer<TokenExtra> t) {
        int b;
        MacroblockD xd = x.e_mbd;
        EntropyPlanes A = xd.above_context.get();
        EntropyPlanes L = xd.left_context;
        PlaneType plane_type = PlaneType.Y_WITH_DC;
        if (xd.hasSecondOrder()) {
            Tokenize.stuff2nd_order_b(t, A.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[24]), L.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[24]), cpi);
            plane_type = PlaneType.Y_NO_DC;
        }
        for (b = 0; b < 16; ++b) {
            Tokenize.stuff1st_order_b(t, A.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[b]), L.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[b]), plane_type, cpi);
        }
        for (b = 16; b < 24; ++b) {
            Tokenize.stuff1st_order_buv(t, A.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[b]), L.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[b]), cpi);
        }
    }

    static boolean mb_is_skippable(MacroblockD x, boolean has_y2_block) {
        boolean skip = true;
        int i = 0;
        int imax = 24;
        if (has_y2_block) {
            ++imax;
            for (i = 0; i < 16 && skip; skip &= x.eobs.getRel(i) < 2, ++i) {
            }
        }
        while (i < imax && skip) {
            skip &= x.eobs.getRel(i) == 0;
            ++i;
        }
        return skip;
    }

    static void vp8_fix_contexts(MacroblockD x) {
        if (x.hasSecondOrder()) {
            x.above_context.get().panes.memset(0, (short)0, x.above_context.get().panes.size());
            x.left_context.panes.memset(0, (short)0, x.left_context.panes.size());
        } else {
            x.above_context.get().panes.memset(0, (short)0, x.above_context.get().panes.size() - 1);
            x.left_context.panes.memset(0, (short)0, x.left_context.panes.size() - 1);
        }
    }

    static void vp8_tokenize_mb(Compressor cpi, Macroblock x, FullGenArrPointer<TokenExtra> t) {
        boolean hasSkip;
        MacroblockD xd = x.e_mbd;
        boolean has_y2_block = xd.hasSecondOrder();
        xd.mode_info_context.get().mbmi.mb_skip_coeff = hasSkip = Tokenize.mb_is_skippable(xd, has_y2_block);
        if (hasSkip) {
            if (!cpi.common.mb_no_coeff_skip) {
                Tokenize.vp8_stuff_mb(cpi, x, t);
            } else {
                Tokenize.vp8_fix_contexts(xd);
                ++x.skip_true_count;
            }
            return;
        }
        PlaneType plane_type = PlaneType.Y_WITH_DC;
        if (has_y2_block) {
            Tokenize.tokenize2nd_order_b(x, t, cpi);
            plane_type = PlaneType.Y_NO_DC;
        }
        Tokenize.tokenize1st_order_b(x, t, plane_type, cpi);
    }
}

