/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.CommonData;
import com.idrsolutions.image.webp.enc.FullGenArrPointer;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.LFFilters;
import com.idrsolutions.image.webp.enc.LoopFilterInfo;
import com.idrsolutions.image.webp.enc.LoopFilterInfoN;
import com.idrsolutions.image.webp.enc.LoopFilterType;
import com.idrsolutions.image.webp.enc.MBLvlFeatures;
import com.idrsolutions.image.webp.enc.MVReferenceFrame;
import com.idrsolutions.image.webp.enc.MacroblockD;
import com.idrsolutions.image.webp.enc.ModeInfo;
import com.idrsolutions.image.webp.enc.YV12buffer;
import java.util.Arrays;

final class LoopFilter {
    static final short MAX_LOOP_FILTER = 63;
    static final int PARTIAL_FRAME_FRACTION = 8;
    static final LoopFilterCore normalCore = (mb_col, mb_row, lfi_n, skip_lf, frame_type, filter_level, y_ptr, post_y_stride, u_ptr, v_ptr, post_uv_stride, dontSkipFirstRow) -> {
        LoopFilterInfo lfi = new LoopFilterInfo(frame_type, lfi_n, filter_level);
        if (mb_col > 0) {
            LFFilters.vp8_loop_filter_mbv(y_ptr, u_ptr, v_ptr, post_y_stride, post_uv_stride, lfi);
        }
        if (!skip_lf) {
            LFFilters.vp8_loop_filter_bv(y_ptr, u_ptr, v_ptr, post_y_stride, post_uv_stride, lfi);
        }
        if (dontSkipFirstRow || mb_row > 0) {
            LFFilters.vp8_loop_filter_mbh(y_ptr, u_ptr, v_ptr, post_y_stride, post_uv_stride, lfi);
        }
        if (!skip_lf) {
            LFFilters.vp8_loop_filter_bh(y_ptr, u_ptr, v_ptr, post_y_stride, post_uv_stride, lfi);
        }
    };
    static final LoopFilterCore simpleCore = (mb_col, mb_row, lfi_n, skip_lf, frame_type, filter_level, y_ptr, post_y_stride, u_ptr, v_ptr, post_uv_stride, dontSkipFirstRow) -> {
        LoopFilterInfo lfi = new LoopFilterInfo(frame_type, lfi_n, filter_level);
        if (mb_col > 0) {
            LFFilters.vp8_loop_filter_simple_vertical_edge(y_ptr, post_y_stride, lfi.mblim);
        }
        if (!skip_lf) {
            LFFilters.vp8_loop_filter_bvs(y_ptr, post_y_stride, lfi.blim);
        }
        if (mb_row > 0) {
            LFFilters.vp8_loop_filter_simple_horizontal_edge(y_ptr, post_y_stride, lfi.mblim);
        }
        if (!skip_lf) {
            LFFilters.vp8_loop_filter_bhs(y_ptr, post_y_stride, lfi.blim);
        }
    };
    static final LoopFilterCore yOnlySimpleCore = (mb_col, mb_row, lfi_n, skip_lf, frame_type, filter_level, y_ptr, post_y_stride, u_ptr, v_ptr, post_uv_stride, dontSkipFirstRow) -> {
        if (mb_col > 0) {
            LFFilters.vp8_loop_filter_simple_vertical_edge(y_ptr, post_y_stride, new GetPointer(lfi_n.mblim[filter_level], 0));
        }
        if (!skip_lf) {
            LFFilters.vp8_loop_filter_bvs(y_ptr, post_y_stride, new GetPointer(lfi_n.blim[filter_level], 0));
        }
        if (dontSkipFirstRow || mb_row > 0) {
            LFFilters.vp8_loop_filter_simple_horizontal_edge(y_ptr, post_y_stride, new GetPointer(lfi_n.mblim[filter_level], 0));
        }
        if (!skip_lf) {
            LFFilters.vp8_loop_filter_bhs(y_ptr, post_y_stride, new GetPointer(lfi_n.blim[filter_level], 0));
        }
    };
    static final PtrIncrementor regularIncrementor = new PtrIncrementor(){

        @Override
        public void nextRow(FullGetSetPointer y_ptr, FullGetSetPointer u_ptr, FullGetSetPointer v_ptr, YV12buffer post) {
            y_ptr.incBy(post.y_stride * 16 - post.y_width);
            u_ptr.incBy(post.uv_stride * 8 - post.uv_width);
            v_ptr.incBy(post.uv_stride * 8 - post.uv_width);
        }

        @Override
        public void nextMB(FullGetSetPointer y_ptr, FullGetSetPointer u_ptr, FullGetSetPointer v_ptr) {
            y_ptr.incBy(16);
            u_ptr.incBy(8);
            v_ptr.incBy(8);
        }
    };
    static final PtrIncrementor yOnlyIncrementor = new PtrIncrementor(){

        @Override
        public void nextRow(FullGetSetPointer y_ptr, FullGetSetPointer u_ptr, FullGetSetPointer v_ptr, YV12buffer post) {
            y_ptr.incBy(post.y_stride * 16 - post.y_width);
        }

        @Override
        public void nextMB(FullGetSetPointer y_ptr, FullGetSetPointer u_ptr, FullGetSetPointer v_ptr) {
            y_ptr.incBy(16);
        }
    };

    private LoopFilter() {
    }

    static void vp8_loop_filter_frame_init(CommonData cm, MacroblockD mbd, short default_filt_lvl) {
        LoopFilterInfoN lfi = cm.lf_info;
        if (cm.last_sharpness_level != cm.sharpness_level) {
            lfi.vp8_loop_filter_update_sharpness(cm.sharpness_level);
            cm.last_sharpness_level = cm.sharpness_level;
        }
        for (int seg = 0; seg < 4; ++seg) {
            int mode;
            int lvl_seg = default_filt_lvl;
            if (mbd.segmentation_enabled != 0) {
                lvl_seg = mbd.mb_segement_abs_delta ? mbd.segment_feature_data[MBLvlFeatures.ALT_LF.ordinal()][seg] : (int)(lvl_seg + mbd.segment_feature_data[MBLvlFeatures.ALT_LF.ordinal()][seg]);
                int n = lvl_seg > 0 ? (lvl_seg > 63 ? 63 : lvl_seg) : (lvl_seg = 0);
            }
            if (!mbd.mode_ref_lf_delta_enabled) {
                for (int i = 0; i < lfi.lvl[seg].length; ++i) {
                    Arrays.fill(lfi.lvl[seg][i], (short)lvl_seg);
                }
                continue;
            }
            int ref = MVReferenceFrame.INTRA_FRAME.ordinal();
            int lvl_ref = lvl_seg + mbd.ref_lf_deltas[ref];
            int lvl_mode = lvl_ref + mbd.mode_lf_deltas[mode = 0];
            lfi.lvl[seg][ref][mode] = lvl_mode = lvl_mode > 0 ? (lvl_mode > 63 ? 63 : lvl_mode) : 0;
            mode = 1;
            lfi.lvl[seg][ref][mode] = lvl_mode = (int)((short)(lvl_ref > 0 ? Math.min(lvl_ref, 63) : 0));
            for (ref = 1; ref < MVReferenceFrame.count; ++ref) {
                lvl_ref = lvl_seg + mbd.ref_lf_deltas[ref];
                for (mode = 1; mode < 4; ++mode) {
                    lvl_mode = (short)(lvl_ref + mbd.mode_lf_deltas[mode]);
                    lfi.lvl[seg][ref][mode] = lvl_mode = lvl_mode > 0 ? (lvl_mode > 63 ? 63 : lvl_mode) : 0;
                }
            }
        }
    }

    static void filterThrough(LoopFilterCore actualFilter, PtrIncrementor incrementor, CommonData cm, int frame_type, int mb_rows, int mb_cols, FullGetSetPointer y_ptr, FullGetSetPointer u_ptr, FullGetSetPointer v_ptr, FullGenArrPointer<ModeInfo> mode_info_context, boolean dontSkipFirstRow) {
        YV12buffer post = cm.frame_to_show;
        LoopFilterInfoN lfi_n = cm.lf_info;
        for (int mb_row = 0; mb_row < mb_rows; ++mb_row) {
            for (int mb_col = 0; mb_col < mb_cols; ++mb_col) {
                ModeInfo mi = mode_info_context.get();
                boolean skip_lf = ModeInfo.hasSecondOrder(mode_info_context) && mi.mbmi.mb_skip_coeff;
                short mode_index = lfi_n.mode_lf_lut.get((Object)mi.mbmi.mode);
                int seg = mi.mbmi.segment_id;
                MVReferenceFrame ref_frame = mi.mbmi.ref_frame;
                short filter_level = lfi_n.lvl[seg][ref_frame.ordinal()][mode_index];
                if (filter_level != 0) {
                    actualFilter.call(mb_col, mb_row, lfi_n, skip_lf, frame_type, filter_level, y_ptr, post.y_stride, u_ptr, v_ptr, post.uv_stride, dontSkipFirstRow);
                }
                incrementor.nextMB(y_ptr, u_ptr, v_ptr);
                mode_info_context.inc();
            }
            incrementor.nextRow(y_ptr, u_ptr, v_ptr, post);
            mode_info_context.inc();
        }
    }

    static void vp8_loop_filter_frame(CommonData cm, MacroblockD mbd, int frame_type) {
        LoopFilter.vp8_loop_filter_frame_init(cm, mbd, cm.filter_level);
        YV12buffer post = cm.frame_to_show;
        FullGetSetPointer y_ptr = post.y_buffer.shallowCopy();
        FullGetSetPointer u_ptr = post.u_buffer.shallowCopy();
        FullGetSetPointer v_ptr = post.v_buffer.shallowCopy();
        LoopFilter.filterThrough(cm.filter_type == LoopFilterType.NORMAL ? normalCore : simpleCore, regularIncrementor, cm, frame_type, cm.mb_rows, cm.mb_cols, y_ptr, u_ptr, v_ptr, cm.mi.shallowCopy(), false);
    }

    static void vp8_loop_filter_frame_yonly(CommonData cm, MacroblockD mbd, short default_filt_lvl) {
        YV12buffer post = cm.frame_to_show;
        LoopFilter.vp8_loop_filter_partial_frame_spec(cm, mbd, default_filt_lvl, cm.mb_rows << 4, post.y_buffer.shallowCopy(), cm.mi.shallowCopy(), false);
    }

    private static void vp8_loop_filter_partial_frame_spec(CommonData cm, MacroblockD mbd, short default_filt_lvl, int linestocopy, FullGetSetPointer y_ptr, FullGenArrPointer<ModeInfo> mic, boolean alwaysMBH) {
        LoopFilter.vp8_loop_filter_frame_init(cm, mbd, default_filt_lvl);
        LoopFilter.filterThrough(cm.filter_type == LoopFilterType.NORMAL ? normalCore : yOnlySimpleCore, yOnlyIncrementor, cm, cm.frame_type, linestocopy >> 4, cm.mb_cols, y_ptr, null, null, mic, alwaysMBH);
    }

    static void vp8_loop_filter_partial_frame(CommonData cm, MacroblockD mbd, short default_filt_lvl) {
        YV12buffer post = cm.frame_to_show;
        int linestocopy = cm.mb_rows / 8;
        linestocopy = linestocopy != 0 ? linestocopy << 4 : 16;
        FullGetSetPointer y_ptr = post.y_buffer.shallowCopyWithPosInc((post.y_height >> 5) * 16 * post.y_stride);
        FullGenArrPointer<ModeInfo> mode_info_context = cm.mi.shallowCopyWithPosInc((post.y_height >> 5) * (cm.mb_cols + 1));
        LoopFilter.vp8_loop_filter_partial_frame_spec(cm, mbd, default_filt_lvl, linestocopy, y_ptr, mode_info_context, true);
    }

    static interface LoopFilterCore {
        public void call(int var1, int var2, LoopFilterInfoN var3, boolean var4, int var5, int var6, FullGetSetPointer var7, int var8, FullGetSetPointer var9, FullGetSetPointer var10, int var11, boolean var12);
    }

    static interface PtrIncrementor {
        public void nextMB(FullGetSetPointer var1, FullGetSetPointer var2, FullGetSetPointer var3);

        public void nextRow(FullGetSetPointer var1, FullGetSetPointer var2, FullGetSetPointer var3, YV12buffer var4);
    }
}

