/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.IntraPredFN;
import com.idrsolutions.image.webp.enc.VP8Util;

class D63Predictor4x4
implements IntraPredFN {
    D63Predictor4x4() {
    }

    @Override
    public void call(FullGetSetPointer dst, int stride, GetPointer above, GetPointer left) {
        short A = above.getRel(0);
        short B = above.getRel(1);
        short C = above.getRel(2);
        short D2 = above.getRel(3);
        short E2 = above.getRel(4);
        short F = above.getRel(5);
        short G = above.getRel(6);
        D63Predictor4x4.vpx_d63_helper(dst, stride, VP8Util.avg2(A, B), VP8Util.avg2(B, C), VP8Util.avg2(C, D2), VP8Util.avg2(D2, E2), VP8Util.avg2(E2, F), VP8Util.avg3(A, B, C), VP8Util.avg3(B, C, D2), VP8Util.avg3(C, D2, E2), VP8Util.avg3(D2, E2, F), VP8Util.avg3(E2, F, G));
    }

    static void vpx_d63_helper(FullGetSetPointer dst, int stride, short ... vals) {
        dst = dst.shallowCopy();
        dst.set(vals[0]);
        dst.setRel(1, dst.setRel(2 * stride, vals[1]));
        dst.setRel(2, dst.setRel(1 + 2 * stride, vals[2]));
        dst.setRel(3, dst.setRel(2 + 2 * stride, vals[3]));
        dst.setRel(3 + 2 * stride, vals[4]);
        dst.setRel(stride, vals[5]);
        dst.setRel(1 + stride, dst.setRel(3 * stride, vals[6]));
        dst.setRel(2 + stride, dst.setRel(1 + 3 * stride, vals[7]));
        dst.setRel(3 + stride, dst.setRel(2 + 3 * stride, vals[8]));
        dst.setRel(3 + 3 * stride, vals[9]);
    }
}

