/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.data;

final class Transform {
    private Transform() {
    }

    static int[][] cosine(int[] input, int[] output) {
        int d1;
        int c1;
        int t2;
        int t1;
        int b1;
        int a1;
        int i;
        int offset = 0;
        for (i = 0; i < 4; ++i) {
            int i0 = input[offset];
            int i4 = input[offset + 4];
            int i8 = input[offset + 8];
            int i12 = input[offset + 12];
            a1 = i0 + i8;
            b1 = i0 - i8;
            t1 = i4 * 35468 >> 16;
            t2 = i12 + (i12 * 20091 >> 16);
            c1 = t1 - t2;
            t1 = i4 + (i4 * 20091 >> 16);
            t2 = i12 * 35468 >> 16;
            d1 = t1 + t2;
            output[offset] = a1 + d1;
            output[offset + 12] = a1 - d1;
            output[offset + 4] = b1 + c1;
            output[offset + 8] = b1 - c1;
            ++offset;
        }
        int diffo = 0;
        int[][] diff = new int[4][4];
        offset = 0;
        for (i = 0; i < 4; ++i) {
            int o4 = offset * 4;
            a1 = output[o4] + output[o4 + 2];
            b1 = output[o4] - output[o4 + 2];
            t1 = output[o4 + 1] * 35468 >> 16;
            t2 = output[o4 + 3] + (output[o4 + 3] * 20091 >> 16);
            c1 = t1 - t2;
            t1 = output[o4 + 1] + (output[o4 + 1] * 20091 >> 16);
            t2 = output[o4 + 3] * 35468 >> 16;
            d1 = t1 + t2;
            output[o4] = a1 + d1 + 4 >> 3;
            output[o4 + 3] = a1 - d1 + 4 >> 3;
            output[o4 + 1] = b1 + c1 + 4 >> 3;
            output[o4 + 2] = b1 - c1 + 4 >> 3;
            diff[0][diffo] = a1 + d1 + 4 >> 3;
            diff[3][diffo] = a1 - d1 + 4 >> 3;
            diff[1][diffo] = b1 + c1 + 4 >> 3;
            diff[2][diffo] = b1 - c1 + 4 >> 3;
            ++offset;
            ++diffo;
        }
        return diff;
    }

    static int[][] walsh(int[] input, int[] output) {
        int d1;
        int c1;
        int b1;
        int a1;
        int i;
        int[][] diff = new int[4][4];
        int offset = 0;
        for (i = 0; i < 4; ++i) {
            a1 = input[offset] + input[offset + 12];
            b1 = input[offset + 4] + input[offset + 8];
            c1 = input[offset + 4] - input[offset + 8];
            d1 = input[offset] - input[offset + 12];
            output[offset] = a1 + b1;
            output[offset + 4] = c1 + d1;
            output[offset + 8] = a1 - b1;
            output[offset + 12] = d1 - c1;
            ++offset;
        }
        offset = 0;
        for (i = 0; i < 4; ++i) {
            a1 = output[offset] + output[offset + 3];
            b1 = output[offset + 1] + output[offset + 2];
            c1 = output[offset + 1] - output[offset + 2];
            d1 = output[offset] - output[offset + 3];
            int a2 = a1 + b1;
            int b2 = c1 + d1;
            int c2 = a1 - b1;
            int d2 = d1 - c1;
            output[offset] = a2 + 3 >> 3;
            output[offset + 1] = b2 + 3 >> 3;
            output[offset + 2] = c2 + 3 >> 3;
            output[offset + 3] = d2 + 3 >> 3;
            diff[0][i] = a2 + 3 >> 3;
            diff[1][i] = b2 + 3 >> 3;
            diff[2][i] = c2 + 3 >> 3;
            diff[3][i] = d2 + 3 >> 3;
            offset += 4;
        }
        return diff;
    }

    static void fdct4x4(int[] coef) {
        int d1;
        int c1;
        int b1;
        int a1;
        int i;
        for (i = 0; i < 16; i += 4) {
            a1 = coef[i] + coef[i + 3] << 3;
            b1 = coef[i + 1] + coef[i + 2] << 3;
            c1 = coef[i + 1] - coef[i + 2] << 3;
            d1 = coef[i] - coef[i + 3] << 3;
            coef[i] = a1 + b1;
            coef[i + 2] = a1 - b1;
            coef[i + 1] = c1 * 2217 + d1 * 5352 + 14500 >> 12;
            coef[i + 3] = d1 * 2217 - c1 * 5352 + 7500 >> 12;
        }
        for (i = 0; i < 4; ++i) {
            a1 = coef[i] + coef[i + 12];
            b1 = coef[i + 4] + coef[i + 8];
            c1 = coef[i + 4] - coef[i + 8];
            d1 = coef[i] - coef[i + 12];
            coef[i] = a1 + b1 + 7 >> 4;
            coef[i + 8] = a1 - b1 + 7 >> 4;
            coef[i + 4] = (c1 * 2217 + d1 * 5352 + 12000 >> 16) + (d1 != 0 ? 1 : 0);
            coef[i + 12] = d1 * 2217 - c1 * 5352 + 51000 >> 16;
        }
    }

    static void walsh4x4(int[] coef) {
        int b1;
        int c1;
        int d1;
        int a1;
        int i;
        for (i = 0; i < 16; i += 4) {
            a1 = coef[i] + coef[i + 2] << 2;
            d1 = coef[i + 1] + coef[i + 3] << 2;
            c1 = coef[i + 1] - coef[i + 3] << 2;
            b1 = coef[i] - coef[i + 2] << 2;
            coef[i] = a1 + d1 + (a1 != 0 ? 1 : 0);
            coef[i + 1] = b1 + c1;
            coef[i + 2] = b1 - c1;
            coef[i + 3] = a1 - d1;
        }
        for (i = 0; i < 4; ++i) {
            a1 = coef[i] + coef[i + 8];
            d1 = coef[i + 4] + coef[i + 12];
            c1 = coef[i + 4] - coef[i + 12];
            b1 = coef[i] - coef[i + 8];
            int a2 = a1 + d1;
            int b2 = b1 + c1;
            int c2 = b1 - c1;
            int d2 = a1 - d1;
            a2 += a2 < 0 ? 1 : 0;
            int n = d2 < 0 ? 1 : 0;
            coef[i] = a2 + 3 >> 3;
            coef[i + 4] = (b2 += b2 < 0 ? 1 : 0) + 3 >> 3;
            coef[i + 8] = (c2 += c2 < 0 ? 1 : 0) + 3 >> 3;
            coef[i + 12] = (d2 += n) + 3 >> 3;
        }
    }

    static void idct4x4(int[] coef) {
        int d1;
        int c1;
        int temp2;
        int temp1;
        int b1;
        int a1;
        int i;
        for (i = 0; i < 4; ++i) {
            a1 = coef[i] + coef[i + 8];
            b1 = coef[i] - coef[i + 8];
            temp1 = coef[i + 4] * 35468 >> 16;
            temp2 = coef[i + 12] + (coef[i + 12] * 20091 >> 16);
            c1 = temp1 - temp2;
            temp1 = coef[i + 4] + (coef[i + 4] * 20091 >> 16);
            temp2 = coef[i + 12] * 35468 >> 16;
            d1 = temp1 + temp2;
            coef[i] = a1 + d1;
            coef[i + 12] = a1 - d1;
            coef[i + 4] = b1 + c1;
            coef[i + 8] = b1 - c1;
        }
        for (i = 0; i < 16; i += 4) {
            a1 = coef[i] + coef[i + 2];
            b1 = coef[i] - coef[i + 2];
            temp1 = coef[i + 1] * 35468 >> 16;
            temp2 = coef[i + 3] + (coef[i + 3] * 20091 >> 16);
            c1 = temp1 - temp2;
            temp1 = coef[i + 1] + (coef[i + 1] * 20091 >> 16);
            temp2 = coef[i + 3] * 35468 >> 16;
            d1 = temp1 + temp2;
            coef[i] = a1 + d1 + 4 >> 3;
            coef[i + 3] = a1 - d1 + 4 >> 3;
            coef[i + 1] = b1 + c1 + 4 >> 3;
            coef[i + 2] = b1 - c1 + 4 >> 3;
        }
    }

    static void iwalsh4x4(int[] coef) {
        int d1;
        int c1;
        int b1;
        int a1;
        int i;
        for (i = 0; i < 4; ++i) {
            a1 = coef[i] + coef[i + 12];
            b1 = coef[i + 4] + coef[i + 8];
            c1 = coef[i + 4] - coef[i + 8];
            d1 = coef[i] - coef[i + 12];
            coef[i] = a1 + b1;
            coef[i + 4] = c1 + d1;
            coef[i + 8] = a1 - b1;
            coef[i + 12] = d1 - c1;
        }
        for (i = 0; i < 16; i += 4) {
            a1 = coef[i] + coef[i + 3];
            b1 = coef[i + 1] + coef[i + 2];
            c1 = coef[i + 1] - coef[i + 2];
            d1 = coef[i] - coef[i + 3];
            int a2 = a1 + b1;
            int b2 = c1 + d1;
            int c2 = a1 - b1;
            int d2 = d1 - c1;
            coef[i] = a2 + 3 >> 3;
            coef[i + 1] = b2 + 3 >> 3;
            coef[i + 2] = c2 + 3 >> 3;
            coef[i + 3] = d2 + 3 >> 3;
        }
    }
}

