/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.viewer;

import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.image.heic.HeicDecoder;
import com.idrsolutions.image.metadata.Exif;
import com.idrsolutions.image.metadata.Metadata;
import com.idrsolutions.image.metadata.ifd.IFDData;
import com.idrsolutions.image.process.ImageProcessingOperations;
import com.idrsolutions.image.process.MirrorOperations;
import com.idrsolutions.image.process.Watermark;
import com.idrsolutions.image.tiff.TiffDecoder;
import com.idrsolutions.image.viewer.JavaImageViewer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.IntStream;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jpedal.utils.LogWriter;

public final class JDeliImageViewer
extends JavaImageViewer
implements ItemListener {
    private static final String noZoomMessage = "No Image to zoom";
    private JComboBox<String> zoomCombo;
    private JButton zoomIn;
    private JButton zoomOut;
    private JButton rotateClockwise;
    private JButton rotateAntiClockwise;
    private JButton metadataMenu;
    private JMenu processOptions;
    private JButton blur;
    private JButton brighten;
    private JButton crop;
    private JButton darken;
    private JButton edgeDetection;
    private JButton emboss;
    private JButton gaussianBlur;
    private JButton invertColors;
    private JButton mirrorV;
    private JButton mirrorH;
    private JButton sharpen;
    private JButton stretch;
    private JButton watermark;
    private JButton reset;
    private JButton undo;
    private JButton redo;
    private JButton toARGB;
    private JButton toBinary;
    private JButton toGrayscale;
    private JButton toIndexed;
    private JButton toRGB;
    private double zoom;
    private double scale;
    private static BufferedImage image;
    private ImageProcessingOperations operations = new ImageProcessingOperations();
    private CroppingLabel cropLabel;
    private ClippingLabel clippingLabel;
    private Dimension imageLabelSize;
    public Metadata metadata;
    private JFrame info;
    private int cropOpIndex;
    private int clipOpIndex;
    private File tmp;
    private boolean isMulti;
    private int imageCount = 1;
    private int currIm = 0;

    private JDeliImageViewer() {
        super("JDeli Viewer");
    }

    public static void main(String[] args) {
        JDeliImageViewer viewer = new JDeliImageViewer();
        try {
            viewer.run();
            if (args.length == 1) {
                viewer.setAndDisplayFile(new File(args[0]));
            }
        }
        catch (Exception e) {
            LogWriter.error(e, "Exception thrown starting the JDeliImageViewer");
        }
    }

    @Override
    BufferedImage getImage() {
        try {
            if (this.isMulti) {
                TiffDecoder tiff = new TiffDecoder();
                return tiff.readImageAt(this.currIm, this.file);
            }
            return this.tmp == null ? JDeli.read(this.file) : JDeli.read(this.tmp);
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to read file: " + e.getMessage());
            JOptionPane.showMessageDialog(this, "Unable to read file: " + this.file.getName());
            this.file = null;
            return null;
        }
    }

    @Override
    protected Rectangle getImageDimension() {
        try {
            return JDeli.readDimension(this.tmp == null ? this.file : this.tmp);
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to read file for dimensions: " + e.getMessage());
            return new Rectangle(0, 0);
        }
    }

    @Override
    protected String getImageType() {
        try {
            this.metadata = JDeli.getImageInfo(this.tmp == null ? this.file : this.tmp);
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to get image type: " + e.getMessage());
            return "N/A";
        }
        return this.metadata.getImageMetadataType().toString();
    }

    @Override
    void displayImage() {
        try {
            if ("tif".equals(this.getExtension()) || "tiff".equals(this.getExtension())) {
                TiffDecoder tiff = new TiffDecoder();
                this.imageCount = tiff.getImageCount(this.file);
                boolean bl = this.isMulti = this.imageCount > 1;
                if (this.isMulti) {
                    this.setUpMulti();
                }
            }
        }
        catch (IOException e) {
            LogWriter.error(e, "Exception thrown reading tiff image");
        }
        this.resetImage();
        this.draw();
        this.resetScale();
        this.reset();
        this.imageLabelSize = new Dimension(this.imageLabel.getWidth(), this.imageLabel.getHeight());
        this.enableMenus(true);
    }

    private void setUpMulti() {
        JButton next = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/jdeli/viewer/next.gif"))));
        JButton prev = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/jdeli/viewer/prev.gif"))));
        JComboBox<Integer> img = new JComboBox<Integer>((Integer[])IntStream.iterate(0, x -> x + 1).limit(this.imageCount).boxed().toArray(Integer[]::new));
        next.setToolTipText("Next Image");
        next.addActionListener(a -> {
            if (this.currIm < this.imageCount - 1) {
                ++this.currIm;
                this.draw();
                img.setSelectedIndex(this.currIm);
            }
        });
        prev.setToolTipText("Previous Image");
        prev.addActionListener(a -> {
            if (this.currIm > 0) {
                --this.currIm;
                this.draw();
                img.setSelectedIndex(this.currIm);
            }
        });
        img.addItemListener(i -> {
            if (i.getStateChange() == 1) {
                this.currIm = img.getSelectedIndex();
                this.draw();
            }
        });
        JPanel multiButtons = new JPanel();
        multiButtons.setLayout(new GridLayout(1, 5));
        multiButtons.setVisible(true);
        multiButtons.add(prev);
        multiButtons.add(img);
        multiButtons.add(next);
        this.add((Component)multiButtons, "Last");
        JPanel thumbnails = new JPanel();
        thumbnails.setLayout(new GridLayout(this.imageCount, 1, 0, 5));
        thumbnails.setVisible(true);
        JScrollPane sp = new JScrollPane(thumbnails);
        int i2 = 0;
        while (i2 < this.imageCount) {
            this.currIm = i2;
            BufferedImage im = this.getImage();
            ImageProcessingOperations imops = new ImageProcessingOperations();
            imops.thumbnail(100, 100);
            im = imops.apply(im);
            JButton t = new JButton(String.valueOf(i2), new ImageIcon(im));
            int finalI = i2++;
            t.addActionListener(a -> img.setSelectedIndex(finalI));
            thumbnails.add(t);
        }
        this.currIm = 0;
        this.add((Component)sp, "East");
        this.pack();
    }

    void resetImage() {
        image = Objects.requireNonNull(this.getImage());
    }

    void resetScale() {
        this.scale = JDeliImageViewer.calculateFitToScreen(image.getWidth(), image.getHeight());
    }

    @Override
    boolean isImageFormatSupported(String format) {
        return JDeli.isImageSupportedForInput(format);
    }

    @Override
    void run() throws Exception {
        super.run();
        JMenuBar buttonPanel = new JMenuBar();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        this.processOptions = new JMenu("Process");
        this.processOptions.setToolTipText("Process image");
        buttonPanel.add(this.processOptions);
        this.zoomIn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/jdeli/viewer/zoom.gif"))));
        this.zoomIn.setToolTipText("Zoom in");
        this.zoomIn.addActionListener(this);
        this.zoomOut = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/jdeli/viewer/minimise.gif"))));
        this.zoomOut.setToolTipText("Zoom out");
        this.zoomOut.addActionListener(this);
        this.zoomCombo = new JComboBox<String>(new String[]{"fit page", "fit height", "fit width", "10%", "20%", "30%", "40%", "50%", "60%", "70%", "80%", "90%", "100%", "110%", "120%", "130%", "140%", "150%", "160%", "170%", "180%", "190%", "200%", "210%", "220%", "230%", "240%", "250%"});
        this.zoomCombo.setSelectedIndex(0);
        this.zoomCombo.setMaximumSize(this.zoomCombo.getPreferredSize());
        this.zoomCombo.setToolTipText("Change zoom");
        this.zoomCombo.addItemListener(this);
        this.metadataMenu = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/jdeli/viewer/metadataIcon.png"))));
        this.metadataMenu.setToolTipText("Image info");
        this.metadataMenu.addActionListener(this);
        buttonPanel.add(this.metadataMenu);
        this.rotateAntiClockwise = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/jdeli/viewer/rotateLeft.gif"))));
        this.rotateAntiClockwise.setToolTipText("Rotate anticlockwise");
        this.rotateAntiClockwise.addActionListener(this);
        this.rotateClockwise = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/jdeli/viewer/rotateRight.gif"))));
        this.rotateClockwise.setToolTipText("Rotate clockwise");
        this.rotateClockwise.addActionListener(this);
        this.rotateAntiClockwise.setBounds(0, 0, 20, 20);
        this.rotateClockwise.setBounds(0, 0, 20, 20);
        buttonPanel.add(this.rotateAntiClockwise);
        buttonPanel.add(this.rotateClockwise);
        this.zoomIn.setBounds(0, 0, 20, 20);
        this.zoomOut.setBounds(0, 0, 20, 20);
        this.undo = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/jdeli/viewer/undo.png"))));
        this.undo.setToolTipText("undo");
        this.undo.addActionListener(this);
        this.redo = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/jdeli/viewer/redo.png"))));
        this.redo.setToolTipText("redo");
        this.redo.addActionListener(this);
        this.undo.setBounds(0, 0, 20, 20);
        this.redo.setBounds(0, 0, 20, 20);
        buttonPanel.add(this.undo);
        buttonPanel.add(this.redo);
        this.reset = new JButton("Reset");
        this.reset.setToolTipText("Reset Image");
        this.reset.addActionListener(this);
        this.addProcesses();
        buttonPanel.add(this.zoomIn);
        buttonPanel.add(this.zoomOut);
        buttonPanel.add(this.zoomCombo);
        buttonPanel.add(this.reset);
        this.add((Component)buttonPanel, "First");
        this.setJMenuBar(this.toolBar);
        this.setVisible(true);
        if (image == null) {
            this.enableMenus(false);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (e.getComponent() == JDeliImageViewer.this && image != null && (JavaImageViewer.frameWidth != e.getComponent().getWidth() || JavaImageViewer.frameHeight != e.getComponent().getHeight())) {
                    JDeliImageViewer.this.windowWidth = JavaImageViewer.frameWidth - 20;
                    JDeliImageViewer.this.windowHeight = JavaImageViewer.frameHeight - 100;
                    JDeliImageViewer.this.resetScale();
                    JDeliImageViewer.this.draw();
                }
            }
        });
    }

    @Override
    void draw() {
        BufferedImage im = Objects.requireNonNull(this.getImage());
        ImageProcessingOperations zoomOps = new ImageProcessingOperations();
        switch (this.zoomCombo.getSelectedIndex()) {
            case 0: {
                zoomOps.resizeToFit(this.windowWidth, this.windowHeight);
                break;
            }
            case 1: {
                zoomOps.resizeToHeight(this.windowHeight);
                break;
            }
            case 2: {
                zoomOps.resizeToWidth(this.windowWidth);
                break;
            }
            default: {
                zoomOps.scale(this.zoom);
            }
        }
        im = zoomOps.apply(im);
        image = this.operations.apply(im);
        this.imageLabel.setIcon(new ImageIcon(image));
    }

    void enableMenus(boolean status) {
        this.metadataMenu.setEnabled(status);
        this.processOptions.setEnabled(status);
        this.redo.setEnabled(status);
        this.reset.setEnabled(status);
        this.rotateAntiClockwise.setEnabled(status);
        this.rotateClockwise.setEnabled(status);
        this.undo.setEnabled(status);
        this.zoomCombo.setEnabled(status);
        this.zoomIn.setEnabled(status);
        this.zoomOut.setEnabled(status);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.zoomIn) {
            this.actionZoomIn();
        } else if (source == this.zoomOut) {
            this.actionZoomOut();
        } else if (source == this.rotateClockwise) {
            this.actionRotateClockwise();
        } else if (source == this.rotateAntiClockwise) {
            this.actonRotateAntiClockwise();
        } else if (source == this.undo) {
            this.actionUndo();
            this.draw();
        } else if (source == this.redo) {
            this.actionRedo();
            this.draw();
        } else if (source == this.metadataMenu) {
            this.showImageInfo();
        } else if (source == this.blur) {
            this.operations.blur();
            this.draw();
        } else if (source == this.brighten) {
            this.operations.brighten(10.0f);
            this.draw();
        } else if (source == this.crop) {
            this.zoomCombo.setSelectedIndex(0);
            this.processOptions.setSelected(false);
            this.processOptions.setPopupMenuVisible(false);
            this.actionCrop();
        } else if (source == this.darken) {
            this.operations.brighten(-10.0f);
            this.draw();
        } else if (source == this.edgeDetection) {
            this.operations.edgeDetection();
            this.draw();
        } else if (source == this.emboss) {
            this.operations.emboss();
            this.draw();
        } else if (source == this.gaussianBlur) {
            this.operations.gaussianBlur();
            this.draw();
        } else if (source == this.invertColors) {
            this.operations.invertColors();
            this.draw();
        } else if (source == this.mirrorH) {
            this.operations.mirror(MirrorOperations.HORIZONTAL);
            this.draw();
        } else if (source == this.mirrorV) {
            this.operations.mirror(MirrorOperations.VERTICAL);
            this.draw();
        } else if (source == this.sharpen) {
            this.operations.sharpen();
            this.draw();
        } else if (source == this.stretch) {
            this.operations.stretchToFill(this.windowWidth, this.windowHeight);
            this.draw();
        } else if (source == this.toARGB) {
            this.operations.toARGB();
            this.draw();
        } else if (source == this.toBinary) {
            this.operations.toBinary();
            this.draw();
        } else if (source == this.toGrayscale) {
            this.operations.toGrayscale();
            this.draw();
        } else if (source == this.toIndexed) {
            this.operations.toIndexed();
            this.draw();
        } else if (source == this.toRGB) {
            this.operations.toRGB();
            this.draw();
        } else if (source == this.watermark) {
            this.watermarkPopup();
        } else if (source == this.reset) {
            this.reset();
            this.draw();
        } else {
            super.actionPerformed(e);
        }
    }

    private void actionUndo() {
        if (this.cropOpIndex == 5) {
            try {
                File temp = this.clipOpIndex == 6 ? this.tmp : this.file;
                image = JDeli.read(temp);
                this.cropLabel.imops.undo().undo();
                this.tmp = this.cropLabel.applyCrop(temp);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            --this.cropOpIndex;
            this.clipOpIndex = this.clipOpIndex != -1 ? this.clipOpIndex - 1 : -1;
        } else if (this.clipOpIndex == 5) {
            try {
                image = JDeli.read(this.file);
                this.clippingLabel.imops.undo().undo();
                this.tmp = this.clippingLabel.applyClip(this.file);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            --this.clipOpIndex;
            this.cropOpIndex = this.cropOpIndex != -1 ? this.cropOpIndex - 1 : -1;
        } else if (this.operations.operationsListSize() != 0) {
            this.operations.undo();
            this.cropOpIndex = this.cropOpIndex > 0 ? this.cropOpIndex - 1 : -1;
            this.clipOpIndex = this.clipOpIndex > 0 ? this.clipOpIndex - 1 : -1;
        }
    }

    private void actionRedo() {
        if (this.cropOpIndex == 4) {
            try {
                this.cropLabel.imops.redo().redo();
                this.tmp = this.cropLabel.applyCrop(this.file);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            ++this.cropOpIndex;
            this.clipOpIndex = this.clipOpIndex > 0 ? this.clipOpIndex + 1 : -1;
        } else if (this.clipOpIndex == 4) {
            try {
                this.clippingLabel.imops.redo().redo();
                this.tmp = this.clippingLabel.applyClip(this.file);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            ++this.clipOpIndex;
            this.cropOpIndex = this.cropOpIndex > 0 ? this.cropOpIndex + 1 : -1;
        } else {
            this.cropOpIndex = this.cropOpIndex > 0 ? this.cropOpIndex + 1 : -1;
            this.clipOpIndex = this.clipOpIndex > 0 ? this.clipOpIndex + 1 : -1;
            this.operations.redo();
        }
    }

    private void actionClip(ClippingLabel.shape clipShape) {
        int topX = 0;
        int topY = 0;
        if (this.clippingLabel == null) {
            this.clippingLabel = new ClippingLabel(this, clipShape);
        } else {
            this.clippingLabel.clip(this, clipShape);
        }
        if ((double)image.getWidth() < this.imageLabelSize.getWidth()) {
            topX = (int)(this.imageLabelSize.getWidth() / 2.0 - (double)image.getWidth() / 2.0);
        }
        if ((double)image.getHeight() < this.imageLabelSize.getHeight()) {
            topY = (int)(this.imageLabelSize.getHeight() / 2.0 - (double)image.getHeight() / 2.0);
        }
        this.clippingLabel.setBounds(topX, topY, image.getWidth(), image.getHeight());
        this.imageLabel.add(this.clippingLabel);
        this.clipOpIndex = 5;
        this.cropOpIndex = this.cropOpIndex == 5 ? this.cropOpIndex + 1 : this.cropOpIndex;
    }

    private void actionCrop() {
        int topX = 0;
        int topY = 0;
        if (this.cropLabel == null) {
            this.cropLabel = new CroppingLabel(this);
        } else {
            this.cropLabel.crop(this);
        }
        if ((double)image.getWidth() < this.imageLabelSize.getWidth()) {
            topX = (int)(this.imageLabelSize.getWidth() / 2.0 - (double)image.getWidth() / 2.0);
        } else if ((double)image.getHeight() < this.imageLabelSize.getHeight()) {
            topY = (int)(this.imageLabelSize.getHeight() / 2.0 - (double)image.getHeight() / 2.0);
        }
        this.cropLabel.setBounds(topX, topY, image.getWidth(), image.getHeight());
        this.imageLabel.add(this.cropLabel);
        this.cropOpIndex = 5;
        this.clipOpIndex = this.clipOpIndex == 5 ? this.clipOpIndex + 1 : this.clipOpIndex;
    }

    private void actonRotateAntiClockwise() {
        if (image != null) {
            this.operations.rotate(270.0);
            int temp = this.windowWidth;
            this.windowWidth = this.windowHeight;
            this.windowHeight = temp;
            this.draw();
        } else {
            JOptionPane.showMessageDialog(this, "No Image to rotate");
        }
    }

    private void actionRotateClockwise() {
        if (image != null) {
            this.operations.rotate(90.0);
            int temp = this.windowWidth;
            this.windowWidth = this.windowHeight;
            this.windowHeight = temp;
            this.draw();
        } else {
            JOptionPane.showMessageDialog(this, "No Image to rotate");
        }
    }

    private void actionZoomOut() {
        if (image != null) {
            int selectedIndex = this.zoomCombo.getSelectedIndex();
            if (selectedIndex < 3) {
                double s = Math.round(this.scale * 10.0) * 10L;
                this.zoomCombo.setSelectedItem((int)s + "%");
                if (s > 250.0) {
                    this.zoomCombo.setSelectedItem("250%");
                } else if (s / 100.0 > this.scale) {
                    this.zoomCombo.setSelectedIndex(this.zoomCombo.getSelectedIndex() - 1);
                }
            } else if (selectedIndex > 3 && selectedIndex < this.zoomCombo.getItemCount() - 3) {
                this.zoomCombo.setSelectedIndex(selectedIndex - 1);
                this.zoom = this.parseZoomCombo();
            }
            this.draw();
        } else {
            JOptionPane.showMessageDialog(this, noZoomMessage);
        }
    }

    private void actionZoomIn() {
        if (image != null) {
            int selectedIndex = this.zoomCombo.getSelectedIndex();
            if (selectedIndex < this.zoomCombo.getItemCount() - 1) {
                if (selectedIndex < 3) {
                    double s = Math.round(this.scale * 10.0) * 10L;
                    this.zoomCombo.setSelectedItem((int)s + "%");
                    if (s < 10.0) {
                        this.zoomCombo.setSelectedItem("10%");
                    }
                    if (s / 100.0 < this.scale) {
                        this.zoomCombo.setSelectedIndex(this.zoomCombo.getSelectedIndex() + 1);
                    }
                } else {
                    this.zoomCombo.setSelectedIndex(selectedIndex + 1);
                    this.zoom = this.parseZoomCombo();
                }
            }
            this.draw();
        } else {
            JOptionPane.showMessageDialog(this, noZoomMessage);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.zoomCombo && e.getStateChange() == 1) {
            if (image != null) {
                if (this.zoomCombo.getSelectedIndex() > 3) {
                    this.zoom = this.parseZoomCombo();
                }
                this.draw();
            } else {
                this.zoomCombo.removeItemListener(this);
                JOptionPane.showMessageDialog(this, noZoomMessage);
                this.zoomCombo.setSelectedIndex(0);
                this.zoomCombo.addItemListener(this);
            }
        }
    }

    private double parseZoomCombo() {
        String zoom = Objects.requireNonNull(this.zoomCombo.getSelectedItem()).toString();
        return Double.parseDouble(zoom.substring(0, zoom.lastIndexOf(37))) / 100.0;
    }

    private void addProcesses() {
        JButton[] processes;
        JButton[] colorSpace;
        JMenu colorSpaceChange = new JMenu("change colorSpace");
        colorSpaceChange.setBorderPainted(true);
        this.processOptions.add(colorSpaceChange);
        this.processOptions.addSeparator();
        this.blur = new JButton("Blur");
        this.brighten = new JButton("Brighten");
        this.crop = new JButton("Crop");
        this.darken = new JButton("Darken");
        this.edgeDetection = new JButton("Edge Detection");
        this.emboss = new JButton("Emboss");
        this.gaussianBlur = new JButton("Gaussian Blur");
        this.invertColors = new JButton("Invert Colors");
        this.mirrorH = new JButton("Mirror Horizontally");
        this.mirrorV = new JButton("Mirror Vertically");
        JMenu mirror = new JMenu("mirror");
        colorSpaceChange.setBorderPainted(true);
        this.processOptions.add(mirror);
        this.processOptions.addSeparator();
        this.sharpen = new JButton("Sharpen");
        this.stretch = new JButton("Stretch");
        this.watermark = new JButton("Watermark");
        this.toARGB = new JButton("To ARGB");
        this.toBinary = new JButton("To Binary");
        this.toGrayscale = new JButton("To Grayscale");
        this.toIndexed = new JButton("To Indexed");
        this.toRGB = new JButton("To RGB");
        for (JButton b : colorSpace = new JButton[]{this.toARGB, this.toBinary, this.toGrayscale, this.toIndexed, this.toRGB}) {
            b.addActionListener(this);
            colorSpaceChange.add(b);
            colorSpaceChange.addSeparator();
        }
        this.mirrorH.addActionListener(this);
        mirror.add(this.mirrorH);
        colorSpaceChange.addSeparator();
        this.mirrorV.addActionListener(this);
        mirror.add(this.mirrorV);
        colorSpaceChange.addSeparator();
        for (JButton b : processes = new JButton[]{this.blur, this.brighten, this.crop, this.darken, this.edgeDetection, this.emboss, this.gaussianBlur, this.invertColors, this.sharpen, this.stretch, this.watermark}) {
            b.addActionListener(this);
            this.processOptions.add(b);
            this.processOptions.addSeparator();
        }
        JMenu clip = new JMenu("Clip");
        this.processOptions.add(clip);
        JButton rec = new JButton("Rectangle");
        rec.addActionListener(e -> {
            this.zoomCombo.setSelectedIndex(0);
            this.actionClip(ClippingLabel.shape.RECTANGLE);
            this.processOptions.setSelected(false);
            this.processOptions.setPopupMenuVisible(false);
        });
        clip.add(rec);
        JButton circ = new JButton("Circle");
        circ.addActionListener(e -> {
            this.zoomCombo.setSelectedIndex(0);
            this.actionClip(ClippingLabel.shape.CIRCLE);
            this.processOptions.setSelected(false);
            this.processOptions.setPopupMenuVisible(false);
        });
        clip.add(circ);
        JButton polygon = new JButton("Polygon");
        polygon.addActionListener(e -> {
            this.zoomCombo.setSelectedIndex(0);
            this.actionClip(ClippingLabel.shape.POLYGON);
            this.processOptions.setSelected(false);
            this.processOptions.setPopupMenuVisible(false);
        });
        clip.add(polygon);
        this.cropOpIndex = -1;
        this.clipOpIndex = -1;
    }

    void showImageInfo() {
        if (this.info == null) {
            this.info = new JFrame("Image Info");
            JPanel infoPanel = new JPanel();
            infoPanel.setLayout(new GridLayout(22, 2, 1, 1));
            Exif exif = null;
            try (FileImageInputStream fios = new FileImageInputStream(this.tmp == null ? this.file : this.tmp);){
                byte[] data = new byte[(int)fios.length()];
                fios.read(data);
                this.metadata = JDeli.getImageInfo(data);
                TreeMap metadataMap = (TreeMap)this.metadata.toMap();
                if (this.getImageType().equals(ImageFormat.HEIC_IMAGE.toString())) {
                    HeicDecoder hdec = new HeicDecoder();
                    exif = hdec.readExif(data);
                } else if (this.getImageType().equals(ImageFormat.JPEG_IMAGE.toString())) {
                    if (data[0] == 69 && data[1] == 120 && data[2] == 105 && data[3] == 102) {
                        byte[] edata = new byte[data.length - 6];
                        System.arraycopy(data, 6, edata, 0, edata.length);
                        exif = Exif.readExif(edata);
                    }
                } else if (this.getImageType().equals(ImageFormat.TIFF_IMAGE.toString())) {
                    exif = Exif.readExif(data);
                }
                if (exif != null && !exif.getIfdDataList().isEmpty()) {
                    List<IFDData> exifList = exif.getIfdDataList();
                    String remainingexif = exifList.get(0).toString();
                    int p = 0;
                    while (p < remainingexif.length() && remainingexif.contains("\n")) {
                        if (!remainingexif.startsWith("imageHeight") && !remainingexif.startsWith("imageWidth")) {
                            metadataMap.put(remainingexif.substring(0, remainingexif.indexOf(58) + 1), remainingexif.substring(remainingexif.indexOf(58) + 1, remainingexif.indexOf(10)));
                        }
                        p = remainingexif.indexOf(10) + 1;
                        remainingexif = remainingexif.substring(p);
                    }
                }
                metadataMap.forEach((k, v) -> {
                    JTextField text = new JTextField("   " + k + " : " + v);
                    text.setEditable(false);
                    infoPanel.add(text);
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            infoPanel.setSize(400, 500);
            this.info.add(infoPanel);
            this.info.setLocation(300, 250);
            this.info.setSize(450, 500);
        }
        this.info.setVisible(true);
    }

    private void watermarkPopup() {
        Field[] fields;
        JFrame watermarkFrame = new JFrame("Watermark");
        JPanel popup = new JPanel();
        popup.setLayout(new BoxLayout(popup, 1));
        JTabbedPane tabsPane = new JTabbedPane();
        tabsPane.setPreferredSize(new Dimension(450, 550));
        JPanel textPanel = new JPanel();
        textPanel.setPreferredSize(new Dimension(400, 500));
        textPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        JLabel textLabel = new JLabel("Text : ");
        JTextArea text = new JTextArea();
        JLabel tColorLabel = new JLabel("Color : ");
        JColorChooser tColor = new JColorChooser();
        JLabel fontLabel = new JLabel("Font : ");
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        JComboBox<String> font = new JComboBox<String>(gEnv.getAvailableFontFamilyNames());
        JLabel fontSizeLabel = new JLabel("Font Size : ");
        JComboBox<Integer> fontSize = new JComboBox<Integer>((Integer[])IntStream.iterate(10, i -> i + 2).limit(96L).boxed().toArray(Integer[]::new));
        JLabel fontStyleLabel = new JLabel("Font Style : ");
        JComboBox<String> fontStyle = new JComboBox<String>(new String[]{"Plain", "Bold", "Italic"});
        JLabel tPosLabel = new JLabel("Text position : ");
        JComboBox<Watermark.WatermarkPosition> tPos = new JComboBox<Watermark.WatermarkPosition>(Watermark.WatermarkPosition.values());
        textPanel.add((Component)textLabel, c);
        ++c.gridx;
        textPanel.add((Component)text, c);
        ++c.gridx;
        textPanel.add((Component)tPosLabel, c);
        ++c.gridx;
        textPanel.add(tPos, c);
        ++c.gridy;
        c.gridx = 0;
        textPanel.add((Component)tColorLabel, c);
        ++c.gridy;
        c.gridwidth = 4;
        textPanel.add((Component)tColor, c);
        c.gridwidth = 1;
        ++c.gridy;
        textPanel.add((Component)fontLabel, c);
        ++c.gridx;
        textPanel.add(font, c);
        ++c.gridx;
        textPanel.add((Component)fontSizeLabel, c);
        ++c.gridx;
        textPanel.add(fontSize, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.5;
        textPanel.add((Component)fontStyleLabel, c);
        ++c.gridx;
        textPanel.add(fontStyle, c);
        JPanel shapePanel = new JPanel();
        shapePanel.setLayout(new GridBagLayout());
        JLabel shapeLabel = new JLabel("Shape : ");
        HashMap<String, Shape> shapeHashMap = new HashMap<String, Shape>();
        shapeHashMap.put("Tall Rectangle", new Rectangle(0, 0, 80, 100));
        shapeHashMap.put("Wide Rectangle", new Rectangle(0, 0, 100, 80));
        shapeHashMap.put("Square", new Rectangle(0, 0, 100, 100));
        shapeHashMap.put("Triangle", new Polygon(new int[]{0, 100, 200}, new int[]{100, 0, 100}, 3));
        JComboBox<String> shape2 = new JComboBox<String>(shapeHashMap.keySet().toArray(new String[4]));
        JLabel colorLabel = new JLabel("Color : ");
        JColorChooser sColor = new JColorChooser();
        JLabel posLabel = new JLabel("Shape position : ");
        JComboBox<Watermark.WatermarkPosition> sPos = new JComboBox<Watermark.WatermarkPosition>(Watermark.WatermarkPosition.values());
        JLabel shapePropLabel = new JLabel("Properties : ");
        JComboBox<Watermark.WatermarkShapeProperties> properties = new JComboBox<Watermark.WatermarkShapeProperties>(Watermark.WatermarkShapeProperties.values());
        JLabel shapeAlphaLabel = new JLabel("Alpha Composite : ");
        HashMap<String, AlphaComposite> alphaHashMap = new HashMap<String, AlphaComposite>();
        for (Field f : fields = AlphaComposite.class.getDeclaredFields()) {
            int modifiers = f.getModifiers();
            if (!Modifier.isStatic(modifiers) || f.getType() != AlphaComposite.class) continue;
            try {
                alphaHashMap.put(f.toString().substring(f.toString().lastIndexOf(46) + 1), (AlphaComposite)f.get(AlphaComposite.class));
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
        }
        JComboBox<String> alpha = new JComboBox<String>(alphaHashMap.keySet().toArray(new String[12]));
        c.gridx = 0;
        c.gridy = 0;
        shapePanel.add((Component)shapeLabel, c);
        ++c.gridx;
        shapePanel.add(shape2, c);
        ++c.gridy;
        --c.gridx;
        shapePanel.add((Component)colorLabel, c);
        ++c.gridy;
        c.gridwidth = 5;
        shapePanel.add((Component)sColor, c);
        c.gridwidth = 1;
        ++c.gridy;
        shapePanel.add((Component)posLabel, c);
        ++c.gridx;
        shapePanel.add(sPos, c);
        ++c.gridx;
        shapePanel.add((Component)shapePropLabel, c);
        ++c.gridx;
        shapePanel.add(properties, c);
        c.gridx = 0;
        ++c.gridy;
        shapePanel.add((Component)shapeAlphaLabel, c);
        ++c.gridx;
        shapePanel.add(alpha, c);
        JPanel imagePanel = new JPanel();
        imagePanel.setLayout(new GridBagLayout());
        JLabel fileLabel = new JLabel("Image file : ");
        JButton selectFile = new JButton("Select File");
        String[] filename = new String[]{""};
        selectFile.addActionListener(e -> {
            FileDialog imFile = new FileDialog((Frame)watermarkFrame, "File chooser");
            imFile.setMode(0);
            imFile.setFilenameFilter((file, name) -> this.isImageFormatSupported(name.substring(name.lastIndexOf(46) + 1)));
            imFile.setVisible(true);
            if (imFile.getDirectory() != null && imFile.getFile() != null) {
                filename[0] = imFile.getDirectory() + imFile.getFile();
                fileLabel.setText("Image file : " + filename[0]);
            }
        });
        JLabel imPropLabel = new JLabel("Image position : ");
        JComboBox<Watermark.WatermarkPosition> imPos = new JComboBox<Watermark.WatermarkPosition>(Watermark.WatermarkPosition.values());
        JLabel imAlphaLabel = new JLabel("Alpha Composite : ");
        JComboBox<String> imAlpha = new JComboBox<String>(alphaHashMap.keySet().toArray(new String[12]));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        imagePanel.add((Component)fileLabel, c);
        ++c.gridy;
        c.gridwidth = 1;
        imagePanel.add((Component)selectFile, c);
        ++c.gridy;
        imagePanel.add((Component)imPropLabel, c);
        ++c.gridx;
        imagePanel.add(imPos, c);
        ++c.gridx;
        imagePanel.add((Component)imAlphaLabel, c);
        ++c.gridx;
        imagePanel.add(imAlpha, c);
        tabsPane.addTab("Text", textPanel);
        tabsPane.addTab("Shape", shapePanel);
        tabsPane.addTab("Image", imagePanel);
        popup.add(tabsPane);
        JButton applyWatermark = new JButton("Apply");
        applyWatermark.addActionListener(e -> {
            if (tabsPane.getSelectedComponent() == textPanel) {
                Font f = new Font((String)font.getSelectedItem(), fontStyle.getSelectedIndex(), (Integer)fontSize.getSelectedItem());
                this.operations.watermark(text.getText(), tColor.getColor(), f, (Watermark.WatermarkPosition)((Object)((Object)tPos.getSelectedItem())));
            } else if (tabsPane.getSelectedComponent() == shapePanel) {
                this.operations.watermark((Shape)shapeHashMap.get(shape2.getSelectedItem()), sColor.getColor(), (Watermark.WatermarkPosition)((Object)((Object)sPos.getSelectedItem())), (AlphaComposite)alphaHashMap.get(alpha.getSelectedItem()), (Watermark.WatermarkShapeProperties)((Object)((Object)properties.getSelectedItem())));
            } else if (tabsPane.getSelectedComponent() == imagePanel) {
                try {
                    this.operations.watermark(JDeli.read(new File(filename[0])), (Watermark.WatermarkPosition)((Object)((Object)imPos.getSelectedItem())), (AlphaComposite)alphaHashMap.get(imAlpha.getSelectedItem()));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(popup, "Cannot read image file");
                }
            }
            this.draw();
        });
        popup.add(applyWatermark);
        watermarkFrame.add((Component)popup, "First");
        watermarkFrame.setLocation(250, 250);
        watermarkFrame.setSize(650, 650);
        watermarkFrame.setVisible(true);
    }

    private void reset() {
        this.operations = new ImageProcessingOperations();
        this.zoom = this.scale;
        if (this.cropLabel != null) {
            this.imageLabel.remove(this.cropLabel);
        }
        if (this.clippingLabel != null) {
            this.imageLabel.remove(this.clippingLabel);
        }
        this.zoomCombo.setSelectedIndex(0);
        if (this.tmp != null) {
            try {
                Files.delete(this.tmp.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.tmp = null;
        }
        this.info = null;
    }

    @Override
    protected void saveFile() {
        JFileChooser fileChooser = new JFileChooser();
        Arrays.stream(OutputFormat.values()).forEach(x -> fileChooser.addChoosableFileFilter(new FileNameExtensionFilter(x.name(), x.name())));
        fileChooser.setFileHidingEnabled(true);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.showSaveDialog(this);
        try {
            if (fileChooser.getSelectedFile() != null) {
                String format = fileChooser.getFileFilter().getDescription();
                JDeli.write(image, format, new File(fileChooser.getSelectedFile().getAbsolutePath() + "." + format));
                JOptionPane.showMessageDialog(this, "File saved");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Cannot save file");
        }
    }

    static class CroppingLabel
    extends JLabel {
        private Rectangle rec;
        protected ImageProcessingOperations imops;

        public CroppingLabel(JDeliImageViewer v) {
            this.crop(v);
        }

        protected void crop(final JDeliImageViewer viewer) {
            this.setCursor(new Cursor(1));
            final Point[] start = new Point[]{null};
            final Dimension[] d = new Dimension[]{null};
            final boolean[] cropSelected = new boolean[]{true};
            final MouseAdapter ma = new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (cropSelected[0] && start[0] != null) {
                        rec.setBounds(start[0].x, start[0].y, e.getX() - start[0].x, e.getY() - start[0].y);
                        this.repaint();
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (cropSelected[0]) {
                        if (e.getX() < 0 || e.getY() < 0 || e.getX() > e.getComponent().getWidth() || e.getY() > e.getComponent().getHeight()) {
                            this.setCursor(new Cursor(0));
                        } else {
                            this.setCursor(new Cursor(1));
                        }
                    }
                }
            };
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (cropSelected[0] && start[0] == null) {
                        if (e.getX() > 0 && e.getY() > 0) {
                            start[0] = new Point(e.getX(), e.getY());
                        } else {
                            JOptionPane.showMessageDialog(e.getComponent(), "Please select on the image");
                        }
                        rec = new Rectangle();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (rec.width != 0 || rec.height != 0) {
                        Rectangle r = viewer.getImageDimension();
                        int imageh = image.getHeight();
                        int imagew = image.getWidth();
                        if (cropSelected[0] && d[0] == null && start[0] != null) {
                            if (e.getX() > e.getComponent().getWidth() || e.getY() > e.getComponent().getHeight()) {
                                JOptionPane.showMessageDialog(e.getComponent(), "Please select on the image");
                                this.getGraphics().clearRect(rec.x, rec.y, rec.width, rec.height);
                            } else {
                                int x = start[0].x;
                                int y = start[0].y;
                                d[0] = new Dimension(e.getX() - x, e.getY() - y);
                                rec = null;
                                cropSelected[0] = false;
                                imops = new ImageProcessingOperations();
                                imops = imops.crop(new Rectangle(new Point(x, y), d[0]));
                                try {
                                    double imh = (float)d[0].height / (float)imageh * (float)r.height / (float)d[0].height;
                                    double imw = (float)d[0].width / (float)imagew * (float)r.width / (float)d[0].width;
                                    imops = imops.scale(Math.max(imh, imw));
                                    viewer.tmp = viewer.tmp == null ? this.applyCrop(viewer.file) : this.applyCrop(viewer.tmp);
                                }
                                catch (Exception ex) {
                                    throw new RuntimeException(ex);
                                }
                                viewer.draw();
                            }
                        }
                    }
                    this.setCursor(new Cursor(0));
                    this.removeMouseListener(this);
                    this.removeMouseListener(ma);
                    viewer.imageLabel.remove(viewer.cropLabel);
                }
            });
            this.addMouseMotionListener(ma);
        }

        protected File applyCrop(File prevFile) throws Exception {
            String format = prevFile.getName().substring(prevFile.getName().lastIndexOf(46) + 1);
            File newFile = File.createTempFile("tmp", "." + format);
            image = this.imops.apply(image);
            JDeli.write(image, format, newFile);
            return newFile;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.rec != null) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.BLACK);
                BasicStroke dashedStroke = new BasicStroke(2.5f, 2, 0, 1.5f, new float[]{6.0f, 6.0f}, 0.0f);
                g2d.fill(dashedStroke.createStrokedShape(this.rec));
            }
        }
    }

    static class ClippingLabel
    extends JLabel {
        private Shape clipShape;
        private final Shape[] polyLines;
        private final Point[] points = new Point[20];
        private int pointsNum = 0;
        protected ImageProcessingOperations imops;

        public ClippingLabel(JDeliImageViewer v, shape s) {
            this.polyLines = new Shape[18];
            this.clip(v, s);
        }

        protected void clip(final JDeliImageViewer v, final shape s) {
            this.setCursor(new Cursor(1));
            final boolean[] drawing = new boolean[]{false};
            final boolean[] clipSelected = new boolean[]{true};
            final MouseAdapter ma = new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (clipSelected[0]) {
                        if (e.getX() < 0 || e.getY() < 0 || e.getX() > e.getComponent().getWidth() || e.getY() > e.getComponent().getHeight()) {
                            this.setCursor(new Cursor(0));
                        } else if (drawing[0]) {
                            this.setCursor(new Cursor(1));
                            clipShape = this.updateShape(s, new Point(e.getX(), e.getY()), false, false);
                            this.repaint();
                        } else {
                            this.setCursor(new Cursor(1));
                        }
                    }
                }
            };
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (clipSelected[0]) {
                        if (e.getX() > 0 && e.getY() > 0) {
                            if (e.getButton() == 1 && !e.isControlDown()) {
                                clipShape = this.updateShape(s, new Point(e.getX(), e.getY()), !drawing[0], false);
                                if (s == shape.POLYGON) {
                                    if (drawing[0]) {
                                        points[pointsNum] = new Point(e.getX(), e.getY());
                                        ++pointsNum;
                                    }
                                    if (pointsNum > 1) {
                                        polyLines[pointsNum - 2] = new Line2D.Double(points[pointsNum - 2], points[pointsNum - 1]);
                                        if (pointsNum == 18) {
                                            JOptionPane.showMessageDialog(e.getComponent(), "Polygon sides limit reached");
                                        }
                                        this.repaint();
                                    }
                                }
                                drawing[0] = true;
                            } else if (e.getButton() == 3 || e.isControlDown() && e.getButton() == 1) {
                                drawing[0] = false;
                                this.removeMouseListener(ma);
                                clipSelected[0] = false;
                                JPopupMenu popup = new JPopupMenu();
                                JButton clipToShape = new JButton("Clip to shape");
                                clipToShape.addActionListener(ev -> {
                                    v2.tmp = v2.tmp == null ? this.clipImage(v2.file, s, new Point(e.getX(), e.getY()), true) : this.clipImage(v2.tmp, s, new Point(e.getX(), e.getY()), true);
                                    v.draw();
                                    this.setCursor(new Cursor(0));
                                    popup.setVisible(false);
                                    this.removeMouseListener(this);
                                    v2.imageLabel.remove(v2.clippingLabel);
                                });
                                popup.add(clipToShape);
                                popup.addSeparator();
                                JButton clipShape = new JButton("Clip shape");
                                clipShape.addActionListener(ev -> {
                                    v2.tmp = v2.tmp == null ? this.clipImage(v2.file, s, new Point(e.getX(), e.getY()), false) : this.clipImage(v2.tmp, s, new Point(e.getX(), e.getY()), false);
                                    v.draw();
                                    popup.setVisible(false);
                                    this.setCursor(new Cursor(0));
                                    this.removeMouseListener(this);
                                    v2.imageLabel.remove(v2.clippingLabel);
                                });
                                popup.add(clipShape);
                                popup.addSeparator();
                                JButton cancel = new JButton("Cancel");
                                cancel.addActionListener(ev -> {
                                    this.setCursor(new Cursor(0));
                                    popup.setVisible(false);
                                    this.removeMouseListener(this);
                                    v.draw();
                                    v2.imageLabel.remove(v2.clippingLabel);
                                });
                                popup.add(cancel);
                                popup.addSeparator();
                                v.clippingLabel.setComponentPopupMenu(popup);
                                popup.show((Component)e.getSource(), e.getX(), e.getY());
                            } else {
                                v.clippingLabel.remove(0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(e.getComponent(), "Please select on the image");
                        }
                    }
                }
            });
            this.addMouseMotionListener(ma);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.clipShape != null) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.BLACK);
                BasicStroke dashedStroke = new BasicStroke(2.5f, 2, 0, 1.5f, new float[]{6.0f, 6.0f}, 0.0f);
                g2d.fill(dashedStroke.createStrokedShape(this.clipShape));
            }
            if (this.polyLines != null && this.pointsNum > 1) {
                for (int i = 0; i < this.pointsNum - 1; ++i) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setColor(Color.BLACK);
                    BasicStroke dashedStroke = new BasicStroke(2.5f, 2, 0, 1.5f, new float[]{6.0f, 6.0f}, 0.0f);
                    g2d.fill(dashedStroke.createStrokedShape(this.polyLines[i]));
                }
            }
        }

        private Shape updateShape(shape s, Point p, boolean starting, boolean finishing) {
            if (starting) {
                this.points[0] = p;
                ++this.pointsNum;
            } else if (this.pointsNum >= 1) {
                Point start = this.points[0];
                switch (s.ordinal()) {
                    case 0: {
                        return new Rectangle(start.x, start.y, p.x - start.x, p.y - start.y);
                    }
                    case 1: {
                        return new Arc2D.Double(new Rectangle(start.x, start.y, p.x - start.x, p.y - start.y), 0.0, 360.0, 2);
                    }
                    case 2: {
                        if (finishing) {
                            int[] x = new int[this.pointsNum];
                            int[] y = new int[this.pointsNum];
                            for (int f = 0; f < this.pointsNum; ++f) {
                                x[f] = (int)this.points[f].getX();
                                y[f] = (int)this.points[f].getY();
                            }
                            return new Polygon(x, y, this.pointsNum);
                        }
                        return new Line2D.Double(this.points[this.pointsNum - 1].x, this.points[this.pointsNum - 1].y, p.x, p.y);
                    }
                }
            }
            return null;
        }

        private File clipImage(File file, shape s, Point p, boolean clipToShape) {
            this.imops = new ImageProcessingOperations();
            this.imops.clip(this.updateShape(s, p, false, true), clipToShape);
            return this.applyClip(file);
        }

        protected File applyClip(File file) {
            File tmp;
            String format = file.getName().substring(file.getName().lastIndexOf(46) + 1);
            try {
                tmp = File.createTempFile("tmp", "." + format);
                image = this.imops.apply(image);
                JDeli.write(image, format, tmp);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return tmp;
        }

        private static enum shape {
            RECTANGLE,
            CIRCLE,
            POLYGON;

        }
    }
}

