/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.viewer;

import com.idrsolutions.image.viewer.JavaImageViewer;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jpedal.utils.LogWriter;

final class ImageIOImageViewer
extends JavaImageViewer {
    private ImageIOImageViewer() {
        super("ImageIO Viewer");
    }

    public static void main(String[] args) throws Exception {
        ImageIOImageViewer viewer = new ImageIOImageViewer();
        viewer.run();
    }

    @Override
    void run() throws Exception {
        super.run();
        this.setJMenuBar(this.toolBar);
        this.setVisible(true);
    }

    @Override
    BufferedImage getImage() {
        try {
            return ImageIO.read(this.file);
        }
        catch (IOException e) {
            LogWriter.error(e, "Exception thrown whilst loading image file");
            return null;
        }
    }

    @Override
    Rectangle getImageDimension() {
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(this.file);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                reader.setInput(iis, true);
                return new Rectangle(reader.getWidth(0), reader.getHeight(0));
            }
        }
        catch (IOException e) {
            LogWriter.writeLog("Unable to get image dimensions: " + String.valueOf(e));
        }
        return new Rectangle(0, 0);
    }

    @Override
    String getImageType() {
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(this.file);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                reader.setInput(iis, true);
                reader.getImageMetadata(0);
                return reader.getFormatName();
            }
        }
        catch (IOException e) {
            LogWriter.writeLog("Unable to get image type: " + String.valueOf(e));
        }
        return null;
    }

    @Override
    protected boolean isImageFormatSupported(String format) {
        String[] supportedFormats;
        for (String imageFormat : supportedFormats = ImageIO.getReaderFormatNames()) {
            if (!imageFormat.equals(format)) continue;
            return true;
        }
        return false;
    }

    @Override
    void saveFile() {
        BufferedImage image = this.getImage();
        if (image != null) {
            JFileChooser fileChooser = new JFileChooser();
            Arrays.stream(ImageIO.getWriterFormatNames()).forEach(a -> {
                if (!a.equals(a.toLowerCase())) {
                    fileChooser.addChoosableFileFilter(new FileNameExtensionFilter((String)a, (String)a));
                }
            });
            fileChooser.setFileHidingEnabled(true);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.showSaveDialog(this);
            try {
                if (fileChooser.getSelectedFile() != null) {
                    String format = fileChooser.getFileFilter().getDescription();
                    ImageIO.write((RenderedImage)image, format, new File(fileChooser.getSelectedFile().getAbsolutePath() + "." + format));
                    JOptionPane.showMessageDialog(this, "File saved");
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Cannot save file");
            }
        } else {
            JOptionPane.showMessageDialog(this, "Cannot save file");
        }
    }
}

