/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.DataWriter;
import java.io.IOException;
import java.io.OutputStream;

public class WriterStreamBig
implements DataWriter {
    private int bp;
    private OutputStream stream;

    public void WriterStreamBig(OutputStream stream) {
        this.stream = stream;
    }

    @Override
    public void putU8(int x) throws IOException {
        this.stream.write(x);
        ++this.bp;
    }

    @Override
    public void putU16(int v) throws IOException {
        byte[] bb = new byte[]{(byte)(v >> 8 & 0xFF), (byte)(v & 0xFF)};
        this.write(bb);
    }

    @Override
    public void putU24(int v) throws IOException {
        byte[] bb = new byte[4];
        bb[0] = (byte)(v >> 16 & 0xFF);
        bb[1] = (byte)(v >> 8 & 0xFF);
        bb[2] = (byte)(v & 0xFF);
        this.write(bb);
    }

    @Override
    public void putU32(int v) throws IOException {
        byte[] bb = new byte[]{(byte)(v >> 24 & 0xFF), (byte)(v >> 16 & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v & 0xFF)};
        this.write(bb);
    }

    @Override
    public void putU64(long v) throws IOException {
        this.putU32((int)(v >> 32));
        this.putU32((int)v);
    }

    @Override
    public void write(byte[] copyTo) throws IOException {
        this.stream.write(copyTo);
        this.bp += copyTo.length;
    }

    @Override
    public int getLength() {
        return this.bp;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

