/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.Tooler;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;

public class ToolRGB565
implements Tooler {
    private final int w;
    private final short[] dd;
    private final BufferedImage img;

    public ToolRGB565(int width, int height) {
        this.img = new BufferedImage(width, height, 8);
        this.w = width;
        this.dd = ((DataBufferUShort)this.img.getRaster().getDataBuffer()).getData();
    }

    @Override
    public void set(int x, int y, int v) {
        this.dd[y * this.w + x] = (short)v;
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.img;
    }

    @Override
    public void setData(byte[] data) {
        int p = 0;
        int ii = data.length >> 1;
        for (int i = 0; i < ii; ++i) {
            this.dd[i] = (short)((data[p++] & 0xF800) << 11 | (data[p++] & 0x7E0) << 5 | data[p++] & 0x1F);
        }
    }

    @Override
    public void setStrips(int y, byte[] data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

