/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.Tooler;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import org.jpedal.utils.LogWriter;

public class ToolIndex
implements Tooler {
    private final byte[] dd;
    private final int s;
    private final int wp;
    private final int m;
    private final BufferedImage img;
    private final int stripPixels;

    public ToolIndex(int width, int height, int bps, byte[] rr, byte[] gg, byte[] bb) {
        IndexColorModel cm = new IndexColorModel(bps, 1 << bps, rr, gg, bb);
        this.img = bps > 4 ? new BufferedImage(width, height, 13, cm) : new BufferedImage(width, height, 12, cm);
        this.s = bps;
        this.wp = (width * bps + 7) / bps;
        this.m = (bps << 1) - 1;
        this.dd = ((DataBufferByte)this.img.getRaster().getDataBuffer()).getData();
        this.stripPixels = (width * bps + 7) / 8;
    }

    @Override
    public void set(int x, int y, int v) {
        try {
            if (this.s == 8) {
                this.dd[y * this.wp + x] = (byte)v;
            } else {
                v &= this.m;
                int a = y * this.wp + x * this.s;
                int b = a >> 3;
                int c = a & 7;
                int d = this.dd[b] & 0xFF;
                int r = 8 - c - this.s;
                if (r >= 0) {
                    int mm = ~(0xFFFFFF00 | this.m << r);
                    this.dd[b] = (byte)(v << r | d & mm);
                } else {
                    d = d << 8 | this.dd[b + 1] & 0xFF;
                    r = 16 - c - this.s;
                    int mm = ~(0xFFFF0000 | this.m << r);
                    d = v << r | d & mm;
                    this.dd[b] = (byte)(d >> 8);
                    this.dd[b + 1] = (byte)(d & 0xFF);
                }
            }
        }
        catch (Exception e) {
            LogWriter.error(e, e.getMessage());
        }
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.img;
    }

    @Override
    public void setData(byte[] data) {
        System.arraycopy(data, 0, this.dd, 0, data.length);
    }

    @Override
    public void setStrips(int y, byte[] data) {
        System.arraycopy(data, 0, this.dd, y * this.stripPixels, data.length);
    }
}

