/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.Tooler;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class ToolARGB
implements Tooler {
    private final int w;
    private final BufferedImage img;
    private final int[] dd;

    public ToolARGB(int width, int height) {
        this.img = new BufferedImage(width, height, 2);
        this.dd = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
        this.w = width;
    }

    @Override
    public void set(int x, int y, int v) {
        this.dd[y * this.w + x] = v;
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.img;
    }

    @Override
    public void setData(byte[] data) {
        int p = 0;
        int ii = data.length / 4;
        for (int i = 0; i < ii; ++i) {
            this.dd[i] = (data[p++] & 0xFF) << 16 | (data[p++] & 0xFF) << 8 | data[p++] & 0xFF | (data[p++] & 0xFF) << 24;
        }
    }

    @Override
    public void setStrips(int y, byte[] data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

