/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.util;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;

class CustomColorConvertOp
implements BufferedImageOp {
    private final RenderingHints hints;

    public CustomColorConvertOp(RenderingHints hints) {
        this.hints = hints;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        if (dest == null) {
            dest = this.createCompatibleDestImage(src, null);
        }
        if (src.getType() == dest.getType()) {
            dest.getRaster().setRect(src.getRaster());
        } else if (dest.getType() == 12) {
            for (int i = 0; i < src.getHeight(); ++i) {
                for (int j = 0; j < src.getWidth(); ++j) {
                    int b;
                    int g;
                    int px = src.getRGB(j, i);
                    int r = px >> 16 & 0xFF;
                    int m = r + (g = px >> 8 & 0xFF) + (b = px & 0xFF);
                    if (m >= 383) {
                        dest.setRGB(j, i, Color.WHITE.getRGB());
                        continue;
                    }
                    dest.setRGB(j, i, 0);
                }
            }
        } else if (src.getType() == 10) {
            int srcWidth = src.getWidth();
            byte[] srcPixels = ((DataBufferByte)src.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < srcPixels.length; ++i) {
                int px = srcPixels[i] & 0xFF;
                dest.setRGB(i % srcWidth, i / srcWidth, 0xFF000000 | px << 16 | px << 8 | px);
            }
        } else {
            try {
                ColorConvertOp xformOp = new ColorConvertOp(this.hints);
                xformOp.filter(src, dest);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception " + String.valueOf(e) + " creating argb image");
            }
        }
        return dest;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle2D.Float(0.0f, 0.0f, src.getWidth(), src.getHeight());
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        return new BufferedImage(destCM, src.getRaster().createCompatibleWritableRaster(), src.isAlphaPremultiplied(), null);
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return srcPt;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }
}

