/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.filter.LZWFilterOptions;
import com.idrsolutions.image.jpeg.JpegEncoder;
import com.idrsolutions.image.metadata.ifd.IFDKeys;
import com.idrsolutions.image.tiff.IFDColorSpace;
import com.idrsolutions.image.tiff.IFDCompression;
import com.idrsolutions.image.tiff.options.TiffCompressionFormat;
import com.idrsolutions.image.tiff.options.TiffEncoderOptions;
import com.idrsolutions.image.tiff.options.TiffResolutionUnit;
import com.idrsolutions.image.util.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.jpedal.io.filter.Flate;
import org.jpedal.io.filter.LZW;

public class TiffEncoder
extends JDeliImage
implements Encoder {
    private TiffEncoderOptions tiffEncoderOptions = new TiffEncoderOptions();

    public TiffEncoder(TiffEncoderOptions tiffOptions) {
        if (tiffOptions != null) {
            this.tiffEncoderOptions = tiffOptions;
        }
    }

    public TiffEncoder() {
    }

    @Override
    public void write(BufferedImage image, OutputStream outputStream) throws IOException {
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        BufferedImage imageToCompress = ImageUtils.fixSubBufferedImage(image);
        TiffEncoder.optimiseImage(image);
        int offsetIFD = 8;
        TiffEncoder.writeIdentifier(outputStream);
        this.writeContents(true, imageToCompress, outputStream, imageW, imageH, 8);
    }

    public void append(BufferedImage image, String fileName) throws IOException {
        BufferedImage img = ImageUtils.fixSubBufferedImage(TiffEncoder.optimiseImage(image));
        File file = new File(fileName);
        if (file.exists() && file.length() > 0L) {
            int endFile = (int)file.length();
            int padding = endFile % 8;
            try (RandomAccessFile rFile = new RandomAccessFile(fileName, "rw");){
                byte[] ends = new byte[2];
                rFile.read(ends);
                boolean isBig = ends[0] == 77 && ends[1] == 77;
                rFile.seek(endFile);
                for (int i = 0; i < padding; ++i) {
                    rFile.write(0);
                }
                TiffEncoder.alterLastIFDOffset(isBig, rFile, endFile += padding);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                this.writeContents(isBig, img, bos, img.getWidth(), img.getHeight(), endFile);
                bos.close();
                byte[] data = bos.toByteArray();
                rFile.seek(endFile);
                rFile.write(data);
            }
        }
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(fileName, new String[0]), new OpenOption[0]));){
            this.createImage(img, out);
        }
    }

    public byte[] append(BufferedImage image, byte[] out) throws IOException {
        int h = image.getHeight();
        int w = image.getWidth();
        BufferedImage img = ImageUtils.fixSubBufferedImage(image);
        if (out != null && out.length != 0 && out[0] != 0) {
            int p;
            int end = out.length;
            int padding = end % 8;
            boolean isBig = out[0] == 77 && out[1] == 77;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(w * h * 3);
            this.writeContents(isBig, img, bos, w, h, end + padding);
            bos.close();
            byte[] data = new byte[out.length + bos.size() + padding];
            System.arraycopy(out, 0, data, 0, out.length);
            int offsetIFD = isBig ? (data[4] & 0xFF) << 24 | (data[5] & 0xFF) << 16 | (data[6] & 0xFF) << 8 | data[7] & 0xFF : (data[7] & 0xFF) << 24 | (data[6] & 0xFF) << 16 | (data[5] & 0xFF) << 8 | data[4] & 0xFF;
            end += padding;
            do {
                int dirs = isBig ? (data[offsetIFD] & 0xFF) << 8 | data[offsetIFD + 1] & 0xFF : (data[offsetIFD + 1] & 0xFF) << 8 | data[offsetIFD] & 0xFF;
                p = offsetIFD + 2 + dirs * 12;
            } while ((offsetIFD = isBig ? (data[p] & 0xFF) << 24 | (data[p + 1] & 0xFF) << 16 | (data[p + 2] & 0xFF) << 8 | data[p + 3] & 0xFF : (data[p + 3] & 0xFF) << 24 | (data[p + 2] & 0xFF) << 16 | (data[p + 1] & 0xFF) << 8 | data[p] & 0xFF) != 0);
            if (isBig) {
                data[p] = (byte)(end >> 24);
                data[p + 1] = (byte)(end >> 16);
                data[p + 2] = (byte)(end >> 8);
                data[p + 3] = (byte)(end & 0xFF);
            } else {
                data[p] = (byte)(end & 0xFF);
                data[p + 1] = (byte)(end >> 8);
                data[p + 2] = (byte)(end >> 16);
                data[p + 3] = (byte)(end >> 24);
            }
            byte[] b = bos.toByteArray();
            System.arraycopy(b, 0, data, end, b.length);
            return data;
        }
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            int offsetIFD = 8;
            TiffEncoder.writeIdentifier(outStream);
            this.writeContents(true, img, outStream, w, h, 8);
            byte[] byArray = outStream.toByteArray();
            return byArray;
        }
    }

    @Deprecated(since="8.18.25 (2019)")
    public boolean isCompressed() {
        return this.tiffEncoderOptions.getCompressionFormat() != TiffCompressionFormat.NONE;
    }

    @Override
    public TiffEncoderOptions getEncoderOptions() {
        return this.tiffEncoderOptions;
    }

    public void setEncoderOptions(TiffEncoderOptions tiffEncoderOptions) {
        this.tiffEncoderOptions = tiffEncoderOptions;
    }

    @Deprecated(since="8.18.25 (2019)")
    public void setCompressed(boolean compress) {
        if (compress) {
            this.tiffEncoderOptions.setCompressionFormat(TiffCompressionFormat.DEFLATE);
        } else {
            this.tiffEncoderOptions.setCompressionFormat(TiffCompressionFormat.NONE);
        }
    }

    private static void alterLastIFDOffset(boolean isBig, RandomAccessFile rFile, int fileLen) throws IOException {
        rFile.seek(0L);
        rFile.skipBytes(4);
        int offsetIFD = TiffEncoder.get32(rFile, isBig);
        do {
            rFile.seek(offsetIFD);
            int dirs = TiffEncoder.get16(rFile, isBig);
            rFile.skipBytes(dirs * 12);
        } while ((offsetIFD = TiffEncoder.get32(rFile, isBig)) != 0);
        int pointer = (int)rFile.getFilePointer();
        rFile.seek(pointer - 4);
        TiffEncoder.put32(rFile, isBig, fileLen);
    }

    private void createImage(BufferedImage image, OutputStream out) throws IOException {
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        int offsetIFD = 8;
        TiffEncoder.writeIdentifier(out);
        this.writeContents(true, image, out, imageW, imageH, 8);
    }

    private static byte[] handleDefault(BufferedImage image) {
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        byte[] raw = new byte[imageH * imageW * 3];
        int p = 0;
        BufferedImage bImage = new BufferedImage(imageW, imageH, 1);
        bImage.createGraphics().drawImage((Image)image, 0, 0, null);
        int[] pixInts = ((DataBufferInt)bImage.getRaster().getDataBuffer()).getData();
        int ii = imageH * imageW;
        for (int i = 0; i < ii; ++i) {
            int xx = pixInts[i];
            raw[p++] = (byte)(xx >> 16 & 0xFF);
            raw[p++] = (byte)(xx >> 8 & 0xFF);
            raw[p++] = (byte)(xx & 0xFF);
        }
        return raw;
    }

    private static byte[] handle4ByteABGR(BufferedImage image) {
        byte[] pByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        byte[] raw = new byte[imageH * imageW * 4];
        int index = 0;
        int pb4 = 0;
        for (int i = 0; i < imageH; ++i) {
            for (int j = 0; j < imageW; ++j) {
                raw[index++] = pByte[pb4 + 3];
                raw[index++] = pByte[pb4 + 2];
                raw[index++] = pByte[pb4 + 1];
                raw[index++] = pByte[pb4];
                pb4 += 4;
            }
        }
        return raw;
    }

    private static byte[] handleUShortGray(BufferedImage image) {
        short[] pix = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        byte[] raw = new byte[image.getWidth() * image.getHeight() * 2];
        int p = 0;
        int ii = raw.length / 2;
        for (int i = 0; i < ii; ++i) {
            int xx = pix[i] & 0xFFFF;
            raw[p++] = (byte)(xx >> 8);
            raw[p++] = (byte)(xx & 0xFF);
        }
        return raw;
    }

    private static byte[] handleByteBGR(BufferedImage image) {
        byte[] pByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        byte[] raw = new byte[imageH * imageW * 3];
        int index = 0;
        int pb = 0;
        int ii = imageW * imageH;
        for (int i = 0; i < ii; ++i) {
            raw[index++] = pByte[pb + 2];
            raw[index++] = pByte[pb + 1];
            raw[index++] = pByte[pb];
            pb += 3;
        }
        return raw;
    }

    private static byte[] handleIntBGR(BufferedImage image) {
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        byte[] raw = new byte[imageH * imageW * 3];
        int index = 0;
        int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int ii = imageH * imageW;
        for (int i = 0; i < ii; ++i) {
            int xx = pixInts[i];
            raw[index++] = (byte)(xx & 0xFF);
            raw[index++] = (byte)(xx >> 8 & 0xFF);
            raw[index++] = (byte)(xx >> 16 & 0xFF);
        }
        return raw;
    }

    private static byte[] handleIntARGB(BufferedImage image) {
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        byte[] raw = new byte[imageH * imageW * 4];
        int index = 0;
        int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int ii = imageH * imageW;
        for (int i = 0; i < ii; ++i) {
            int xx = pixInts[i];
            raw[index++] = (byte)(xx >> 16 & 0xFF);
            raw[index++] = (byte)(xx >> 8 & 0xFF);
            raw[index++] = (byte)(xx & 0xFF);
            raw[index++] = (byte)(xx >> 24 & 0xFF);
        }
        return raw;
    }

    private static byte[] handleIntRGB(BufferedImage image) {
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        byte[] raw = new byte[imageH * imageW * 3];
        int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int index = 0;
        int ii = imageH * imageW;
        for (int i = 0; i < ii; ++i) {
            int xx = pixInts[i];
            raw[index++] = (byte)(xx >> 16 & 0xFF);
            raw[index++] = (byte)(xx >> 8 & 0xFF);
            raw[index++] = (byte)(xx & 0xFF);
        }
        return raw;
    }

    private static void writeIdentifier(OutputStream out) throws IOException {
        out.write(new byte[]{77, 77});
        out.write(new byte[]{0, 42});
        out.write(TiffEncoder.intToBytes());
    }

    private static void writePadding(OutputStream out, int rawLen) throws IOException {
        int balance = rawLen % 8;
        for (int i = 0; i < balance; ++i) {
            out.write(0);
        }
    }

    private static int getNComp(BufferedImage image) {
        return switch (image.getType()) {
            case 10, 11, 12, 13 -> 1;
            case 2, 3, 6, 7 -> 4;
            default -> 3;
        };
    }

    private static int getBPS(BufferedImage image) {
        return switch (image.getType()) {
            case 12 -> image.getColorModel().getPixelSize();
            case 11 -> 16;
            default -> 8;
        };
    }

    private static byte[] grabData(BufferedImage image, TiffCompressionFormat compressionType) throws IOException {
        byte[] raw = switch (image.getType()) {
            case 10, 12, 13 -> ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            case 11 -> TiffEncoder.handleUShortGray(image);
            case 1 -> TiffEncoder.handleIntRGB(image);
            case 2, 3 -> TiffEncoder.handleIntARGB(image);
            case 4 -> TiffEncoder.handleIntBGR(image);
            case 5 -> TiffEncoder.handleByteBGR(image);
            case 6, 7 -> TiffEncoder.handle4ByteABGR(image);
            default -> TiffEncoder.handleDefault(image);
        };
        switch (compressionType) {
            case JPEG: {
                ByteArrayOutputStream jpegBuff = new ByteArrayOutputStream();
                JpegEncoder enc = new JpegEncoder();
                enc.write(image, jpegBuff);
                return jpegBuff.toByteArray();
            }
            case DEFLATE: {
                return Flate.encode(raw, -1);
            }
            case DEFLATE_BETTER_COMPRESSION: {
                return Flate.encode(raw, 9);
            }
            case DEFLATE_BETTER_SPEED: {
                return Flate.encode(raw, 1);
            }
            case LZW: {
                LZW lzw = new LZW(new LZWFilterOptions(), image.getWidth(), image.getHeight());
                return lzw.encode(raw);
            }
        }
        return raw;
    }

    private static int getMapSize(BufferedImage image) {
        return switch (image.getType()) {
            case 12, 13 -> {
                IndexColorModel model = (IndexColorModel)image.getColorModel();
                yield (int)Math.pow(2.0, model.getPixelSize());
            }
            default -> 0;
        };
    }

    private static byte[] grabCmapData(BufferedImage image) {
        int p = 0;
        return switch (image.getType()) {
            case 12, 13 -> {
                int i;
                IndexColorModel model = (IndexColorModel)image.getColorModel();
                int mapSize = TiffEncoder.getMapSize(image);
                byte[] cmap = new byte[mapSize * 3 * 2];
                byte[] rr = new byte[mapSize];
                model.getReds(rr);
                byte[] gg = new byte[mapSize];
                model.getGreens(gg);
                byte[] bb = new byte[mapSize];
                model.getBlues(bb);
                for (i = 0; i < mapSize; ++i) {
                    cmap[p] = rr[i];
                    p += 2;
                }
                for (i = 0; i < mapSize; ++i) {
                    cmap[p] = gg[i];
                    p += 2;
                }
                for (i = 0; i < mapSize; ++i) {
                    cmap[p] = bb[i];
                    p += 2;
                }
                yield cmap;
            }
            default -> null;
        };
    }

    private void writeContents(boolean isBig, BufferedImage image, OutputStream out, int imageWidth, int imageHeight, int offsetIFD) throws IOException {
        int i;
        int totalEntries;
        String xmpMeta = this.tiffEncoderOptions.getXmpMetaData();
        byte[] xmpDataBytes = xmpMeta != null ? xmpMeta.getBytes() : null;
        int nComp = TiffEncoder.getNComp(image);
        int bps = TiffEncoder.getBPS(image);
        byte[] cmapData = TiffEncoder.grabCmapData(image);
        boolean isGray = image.getType() == 10 || image.getType() == 11;
        int compressValue = 1;
        int photoMetric = isGray ? 1 : (cmapData != null ? IFDColorSpace.RGB_Palette.value : IFDColorSpace.RGB.value);
        switch (this.tiffEncoderOptions.getCompressionFormat()) {
            case JPEG: {
                compressValue = IFDCompression.JPEG_TechNote.value;
                photoMetric = isGray ? 1 : IFDColorSpace.YCbCr.value;
                nComp = switch (image.getType()) {
                    case 10, 11 -> 1;
                    default -> 3;
                };
                cmapData = null;
                bps = 8;
                break;
            }
            case DEFLATE: 
            case DEFLATE_BETTER_COMPRESSION: 
            case DEFLATE_BETTER_SPEED: {
                compressValue = IFDCompression.ADOBEDEFLATE.value;
                break;
            }
            case LZW: {
                compressValue = IFDCompression.LZW.value;
            }
        }
        int n = totalEntries = cmapData != null ? 13 : 12;
        if (xmpDataBytes != null) {
            ++totalEntries;
        }
        byte[] data = TiffEncoder.grabData(image, this.tiffEncoderOptions.getCompressionFormat());
        int sampleOffset = offsetIFD + 2 + totalEntries * 12 + 4;
        int offsetXR = nComp > 1 ? sampleOffset + 2 * nComp : sampleOffset;
        int offsetYR = offsetXR + 8;
        int offsetXMP = offsetYR + 8;
        int offsetStrip = offsetYR + 8;
        if (xmpDataBytes != null) {
            offsetStrip = offsetXMP + xmpDataBytes.length;
        }
        int cmapOffset = offsetStrip;
        if (cmapData != null) {
            offsetStrip += cmapData.length;
        }
        TiffEncoder.putU16(out, isBig, totalEntries);
        TiffEncoder.writeDimension(out, isBig, IFDKeys.ImageWidth.value, imageWidth);
        TiffEncoder.writeDimension(out, isBig, IFDKeys.ImageHeight.value, imageHeight);
        TiffEncoder.putU16(out, isBig, IFDKeys.BitsPerSample.value);
        TiffEncoder.putU16(out, isBig, 3);
        if (nComp == 1) {
            TiffEncoder.putU32(out, isBig, 1);
            TiffEncoder.putU16(out, isBig, bps);
            TiffEncoder.putU16(out, isBig, 0);
        } else {
            TiffEncoder.putU32(out, isBig, nComp);
            TiffEncoder.putU32(out, isBig, sampleOffset);
        }
        TiffEncoder.write5Values(out, isBig, IFDKeys.Compression.value, compressValue);
        TiffEncoder.write5Values(out, isBig, IFDKeys.PhotometricInterpolation.value, photoMetric);
        TiffEncoder.write4Values(out, isBig, IFDKeys.StripOffsets.value, offsetStrip);
        TiffEncoder.write5Values(out, isBig, IFDKeys.SamplesPerPixel.value, nComp);
        TiffEncoder.write4Values(out, isBig, IFDKeys.RowsPerStrip.value, imageHeight);
        TiffEncoder.write4Values(out, isBig, IFDKeys.StripByteCounts.value, data.length);
        TiffEncoder.writeResolution(out, isBig, IFDKeys.Xresolution.value, offsetXR);
        TiffEncoder.writeResolution(out, isBig, IFDKeys.Yresolution.value, offsetYR);
        TiffResolutionUnit resolutionUnit = this.tiffEncoderOptions.getResolutionUnit();
        TiffEncoder.write5Values(out, isBig, IFDKeys.ResolutionUnit.value, resolutionUnit.value);
        if (xmpDataBytes != null) {
            TiffEncoder.putU16(out, isBig, IFDKeys.XMP.value);
            TiffEncoder.putU16(out, isBig, 1);
            TiffEncoder.putU32(out, isBig, xmpDataBytes.length);
            TiffEncoder.putU32(out, isBig, offsetXMP);
        }
        if (cmapData != null) {
            TiffEncoder.putU16(out, isBig, IFDKeys.ColorMap.value);
            TiffEncoder.putU16(out, isBig, 3);
            TiffEncoder.putU32(out, isBig, TiffEncoder.getMapSize(image) * 3);
            TiffEncoder.putU32(out, isBig, cmapOffset);
        }
        TiffEncoder.putU32(out, isBig, 0);
        if (nComp > 1) {
            for (i = 0; i < nComp; ++i) {
                TiffEncoder.putU16(out, isBig, bps);
            }
        }
        if (resolutionUnit != TiffResolutionUnit.NONE) {
            TiffEncoder.putU32(out, isBig, this.tiffEncoderOptions.getXResolution());
            TiffEncoder.putU32(out, isBig, 1);
            TiffEncoder.putU32(out, isBig, this.tiffEncoderOptions.getYResolution());
            TiffEncoder.putU32(out, isBig, 1);
        } else {
            for (i = 0; i < 4; ++i) {
                TiffEncoder.putU32(out, isBig, 1);
            }
        }
        if (xmpDataBytes != null) {
            out.write(xmpDataBytes);
        }
        if (cmapData != null) {
            out.write(cmapData);
        }
        out.write(data);
        TiffEncoder.writePadding(out, data.length);
    }

    private static void write4Values(OutputStream out, boolean isBig, int tag, int value) throws IOException {
        TiffEncoder.putU16(out, isBig, tag);
        TiffEncoder.putU16(out, isBig, 4);
        TiffEncoder.putU32(out, isBig, 1);
        TiffEncoder.putU32(out, isBig, value);
    }

    private static void write5Values(OutputStream out, boolean isBig, int tag, int value) throws IOException {
        TiffEncoder.putU16(out, isBig, tag);
        TiffEncoder.putU16(out, isBig, 3);
        TiffEncoder.putU32(out, isBig, 1);
        TiffEncoder.putU16(out, isBig, value);
        TiffEncoder.putU16(out, isBig, 0);
    }

    private static void writeDimension(OutputStream out, boolean isBig, int tag, int dim) throws IOException {
        TiffEncoder.putU16(out, isBig, tag);
        TiffEncoder.putU16(out, isBig, 3);
        TiffEncoder.putU32(out, isBig, 1);
        TiffEncoder.putU16(out, isBig, dim);
        TiffEncoder.putU16(out, isBig, 0);
    }

    private static void writeResolution(OutputStream out, boolean isBig, int tag, int offset) throws IOException {
        TiffEncoder.putU16(out, isBig, tag);
        TiffEncoder.putU16(out, isBig, 5);
        TiffEncoder.putU32(out, isBig, 1);
        TiffEncoder.putU32(out, isBig, offset);
    }

    private static int get32(RandomAccessFile os, boolean isBig) throws IOException {
        byte[] bb = new byte[4];
        os.read(bb);
        if (isBig) {
            return (bb[0] & 0xFF) << 24 | (bb[1] & 0xFF) << 16 | (bb[2] & 0xFF) << 8 | bb[3] & 0xFF;
        }
        return (bb[3] & 0xFF) << 24 | (bb[2] & 0xFF) << 16 | (bb[1] & 0xFF) << 8 | bb[0] & 0xFF;
    }

    private static int get16(RandomAccessFile os, boolean isBig) throws IOException {
        byte[] bb = new byte[2];
        os.read(bb);
        if (isBig) {
            return (bb[0] & 0xFF) << 8 | bb[1] & 0xFF;
        }
        return (bb[1] & 0xFF) << 8 | bb[0] & 0xFF;
    }

    private static void putU16(OutputStream os, boolean isBig, int v) throws IOException {
        if (isBig) {
            os.write(v >> 8);
            os.write(v & 0xFF);
        } else {
            os.write(v & 0xFF);
            os.write(v >> 8);
        }
    }

    private static void putU32(OutputStream os, boolean isBig, int v) throws IOException {
        if (isBig) {
            os.write(v >>> 24);
            os.write(v >> 16);
            os.write(v >> 8);
            os.write(v & 0xFF);
        } else {
            os.write(v & 0xFF);
            os.write(v >> 8);
            os.write(v >> 16);
            os.write(v >> 24);
        }
    }

    private static void put32(RandomAccessFile os, boolean isBig, int v) throws IOException {
        if (isBig) {
            os.write(v >> 24);
            os.write(v >> 16);
            os.write(v >> 8);
            os.write(v & 0xFF);
        } else {
            os.write(v & 0xFF);
            os.write(v >> 8);
            os.write(v >> 16);
            os.write(v >> 24);
        }
    }

    @Deprecated(since="8.18.25 (2019)")
    public void setXMPMetaData(String xmpMetaData) {
        this.tiffEncoderOptions.setXmpMetaData(xmpMetaData);
    }

    private static byte[] intToBytes() {
        return new byte[]{0, 0, 0, 8};
    }
}

