/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.sgi;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.utility.DataByteBig;
import com.idrsolutions.image.utility.DataFileBig;
import com.idrsolutions.image.utility.DataReader;
import com.idrsolutions.image.utility.ToolARGB;
import com.idrsolutions.image.utility.ToolGray;
import com.idrsolutions.image.utility.ToolRGB;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.jpedal.utils.LogWriter;

public class SgiDecoder
extends JDeliImage
implements Decoder {
    private DataReader reader;
    private static final int CMAP_NORMAL = 0;

    @Override
    public BufferedImage read(byte[] data) throws IOException {
        this.reader = new DataByteBig(data);
        BufferedImage img = SgiDecoder.decodeData(this.reader);
        this.reader.close();
        return img;
    }

    @Override
    public BufferedImage read(File file) throws IOException {
        this.reader = new DataFileBig(file);
        BufferedImage image = SgiDecoder.decodeData(this.reader);
        this.reader.close();
        return SgiDecoder.optimiseImage(image);
    }

    @Override
    public Rectangle readDimension(File file) throws Exception {
        DataFileBig reader = new DataFileBig(file);
        if (reader.getU16() != 474) {
            throw new IOException("Invalid SGI Image");
        }
        reader.getU8();
        reader.getU8();
        reader.getU16();
        int width = reader.getU16();
        int height = reader.getU16();
        reader.close();
        return new Rectangle(width, height);
    }

    @Override
    public Rectangle readDimension(byte[] sgiRawData) throws Exception {
        DataByteBig reader = new DataByteBig(sgiRawData);
        if (reader.getU16() != 474) {
            throw new IOException("Invalid SGI Image");
        }
        reader.getU8();
        reader.getU8();
        reader.getU16();
        int width = reader.getU16();
        int height = reader.getU16();
        return new Rectangle(width, height);
    }

    private static BufferedImage decodeData(DataReader reader) throws IOException {
        if (reader.getU16() != 474) {
            throw new IOException("Invalid SGI Image");
        }
        int format = reader.getU8();
        int bpc = reader.getU8();
        reader.getU16();
        int width = reader.getU16();
        int height = reader.getU16();
        int nComp = reader.getU16();
        reader.getU32();
        reader.getU32();
        reader.skip(84);
        int colorMapID = reader.getU32();
        reader.skip(404);
        byte[] data = new byte[bpc * nComp * width * height];
        int scanLen = bpc * width;
        if (format == 1) {
            SgiDecoder.readFormatOneData(reader, height, nComp, data, scanLen);
        } else {
            reader.read(data);
        }
        if (colorMapID == 0) {
            return switch (nComp) {
                case 1 -> SgiDecoder.getImageForCase1(width, height, scanLen, data);
                case 3 -> SgiDecoder.getImageForCase3(width, height, scanLen, data);
                case 4 -> SgiDecoder.getImageForCase4(width, height, scanLen, data);
                default -> null;
            };
        }
        throw new IOException("SGI colormap " + colorMapID + " support is not added yet");
    }

    private static BufferedImage getImageForCase4(int width, int height, int scanLen, byte[] data) {
        ToolARGB tool = new ToolARGB(width, height);
        int cLen = scanLen * height;
        int cLen2 = scanLen * height * 2;
        int cLen3 = scanLen * height * 2;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int t = (height - i - 1) * scanLen + j;
                int r = data[t] & 0xFF;
                int g = data[cLen + t] & 0xFF;
                int b = data[cLen2 + t] & 0xFF;
                int a = data[cLen3 + t] & 0xFF;
                tool.set(j, i, a << 24 | r << 16 | g << 8 | b);
            }
        }
        return tool.getBufferedImage();
    }

    private static BufferedImage getImageForCase3(int width, int height, int scanLen, byte[] data) {
        int cLen = scanLen * height;
        int cLen2 = scanLen * height * 2;
        ToolRGB tool = new ToolRGB(width, height);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int t = (height - i - 1) * scanLen + j;
                int r = data[t] & 0xFF;
                int g = data[cLen + t] & 0xFF;
                int b = data[cLen2 + t] & 0xFF;
                tool.set(j, i, r << 16 | g << 8 | b);
            }
        }
        return tool.getBufferedImage();
    }

    private static BufferedImage getImageForCase1(int width, int height, int scanLen, byte[] data) {
        ToolGray tool = new ToolGray(width, height);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int t = (height - i - 1) * scanLen + j;
                int r = data[t] & 0xFF;
                tool.set(j, i, r);
            }
        }
        return tool.getBufferedImage();
    }

    private static void readFormatOneData(DataReader reader, int height, int nComp, byte[] data, int scanLen) throws IOException {
        int j;
        int i;
        int[][] offsets = new int[nComp][height];
        int[][] lengths = new int[nComp][height];
        for (i = 0; i < nComp; ++i) {
            for (j = 0; j < height; ++j) {
                offsets[i][j] = reader.getU32();
            }
        }
        for (i = 0; i < nComp; ++i) {
            for (j = 0; j < height; ++j) {
                lengths[i][j] = reader.getU32();
            }
        }
        int p = 0;
        for (int n = 0; n < nComp; ++n) {
            for (int h = 0; h < height; ++h) {
                int off = offsets[n][h];
                int len = lengths[n][h];
                byte[] temp = new byte[len];
                reader.moveTo(off);
                reader.read(temp);
                byte[] t2 = new byte[scanLen];
                SgiDecoder.decodeRLE(temp, t2);
                System.arraycopy(t2, 0, data, p, scanLen);
                p += scanLen;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void decodeRLE(byte[] input, byte[] output) {
        p = 0;
        q = 0;
        try {
            block2: while (true) {
                if ((c = (pix = input[p++] & 255) & 127) == 0) {
                    return;
                }
                if ((pix & 128) != 0) {
                    while (true) {
                        if (c-- == 0) continue block2;
                        output[q++] = input[p++];
                    }
                }
                pix = input[p++] & 255;
                while (true) {
                    if (c-- > 0) ** break;
                    continue block2;
                    output[q++] = (byte)pix;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LogWriter.writeLog("invalid run length encoding in SGI stream" + e.getMessage());
            return;
        }
    }
}

