/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.scale;

import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.scale.QualityScaler;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class QualityThumbnail
extends JDeliImage {
    public static BufferedImage getScaledImage(BufferedImage sourceImage, int expectedWidth, int expectedHeight) {
        BufferedImage source;
        if (sourceImage.getType() == 0) {
            ColorConvertOp convertOp = new ColorConvertOp(null);
            source = convertOp.filter(sourceImage, new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2));
        } else {
            source = sourceImage;
        }
        QualityThumbnail.optimiseImage(source);
        int sw = source.getWidth();
        int sh = source.getHeight();
        ColorModel cm = source.getColorModel();
        int nComp = cm.getNumComponents();
        if (expectedWidth == sw && expectedHeight == sh) {
            return source;
        }
        if (expectedWidth > sw || expectedHeight > sw || cm instanceof IndexColorModel) {
            return QualityThumbnail.getCubicScaled(source, expectedWidth, expectedHeight);
        }
        return QualityScaler.getScaledImage(sourceImage, expectedWidth, expectedHeight);
    }

    private static BufferedImage getCubicScaled(BufferedImage image, int width, int height) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        double scaleX = (double)width / (double)imageWidth;
        double scaleY = (double)height / (double)imageHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp scaleOP = new AffineTransformOp(scaleTransform, 3);
        return scaleOP.filter(image, new BufferedImage(width, height, image.getType()));
    }
}

