/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.process;

import com.idrsolutions.image.process.ImageOperation;
import com.idrsolutions.image.scale.QualityScaler;
import java.awt.image.BufferedImage;

final class ResizeToWidth
implements ImageOperation {
    private final int newWidth;

    ResizeToWidth(int newWidth) {
        this.newWidth = newWidth;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        int currentWidth = image.getWidth();
        double scaling = (double)this.newWidth / (double)currentWidth;
        int h = (int)((double)image.getHeight() * scaling);
        return QualityScaler.getScaledImage(image, this.newWidth, h);
    }
}

