/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.process;

import com.idrsolutions.image.process.ImageOperation;
import com.idrsolutions.image.scale.QualityScaler;
import java.awt.image.BufferedImage;

final class ResizeToHeight
implements ImageOperation {
    private final int newHeight;

    ResizeToHeight(int newHeight) {
        this.newHeight = newHeight;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        int currentHeight = image.getHeight();
        double scaling = (double)this.newHeight / (double)currentHeight;
        int w = (int)((double)image.getWidth() * scaling);
        return QualityScaler.getScaledImage(image, w, this.newHeight);
    }
}

