/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.process;

import com.idrsolutions.image.process.ImageOperation;
import com.idrsolutions.image.process.MirrorOperations;
import java.awt.image.BufferedImage;

final class Mirror
implements ImageOperation {
    private final MirrorOperations mirrorOp;

    Mirror(MirrorOperations mirrorOp) {
        this.mirrorOp = mirrorOp;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        if (this.mirrorOp == MirrorOperations.VERTICAL) {
            for (int y = h; y != h / 2; --y) {
                for (int x = 0; x < w; ++x) {
                    Mirror.mirroring(image, x, x, y - 1, h - y);
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x != w / 2; ++x) {
                    Mirror.mirroring(image, x, w - x - 1, y, y);
                }
            }
        }
        return image;
    }

    private static void mirroring(BufferedImage image, int x1, int x2, int y1, int y2) {
        int pixel1 = image.getRGB(x1, y1);
        int pixel2 = image.getRGB(x2, y2);
        image.setRGB(x2, y2, pixel1);
        image.setRGB(x1, y1, pixel2);
    }
}

