/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.process;

import com.idrsolutions.image.process.ImageOperation;
import com.idrsolutions.image.util.ColorSpaceConversion;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;

final class Brighten
implements ImageOperation {
    private final float p;

    Brighten(float percent) {
        this.p = 1.0f + percent / 100.0f;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        if (image.getType() == 12 || image.getType() == 13) {
            image = ColorSpaceConversion.getBufferedImageAsARGB(image);
        }
        RescaleOp brighten = new RescaleOp(this.p, 0.0f, null);
        return brighten.filter(image, null);
    }
}

