/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import java.io.IOException;
import java.io.InputStream;

final class UtilXL {
    private UtilXL() {
    }

    static int readFully(InputStream in, byte[] buffer) throws IOException {
        return UtilXL.readFully(in, buffer, 0, buffer.length);
    }

    static int readFully(InputStream in, byte[] buffer, int offset, int len) throws IOException {
        int remaining;
        int count;
        for (remaining = len; remaining > 0 && (count = in.read(buffer, offset + len - remaining, remaining)) > 0; remaining -= count) {
        }
        return remaining;
    }

    static long skipFully(InputStream in, long n) throws IOException {
        long remaining;
        long skipped;
        for (remaining = n; remaining > 0L; remaining -= skipped) {
            skipped = in.skip(remaining);
            if (skipped != 0L) continue;
            break;
        }
        if (remaining == 0L) {
            return 0L;
        }
        byte[] buffer = new byte[4096];
        while (remaining > (long)buffer.length) {
            int k = UtilXL.readFully(in, buffer);
            remaining = remaining - (long)buffer.length + (long)k;
            if (k == 0) continue;
            return remaining;
        }
        return UtilXL.readFully(in, buffer, 0, (int)remaining);
    }
}

