/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.FloatXL;
import com.idrsolutions.image.jpegxl.data.Frame;
import com.idrsolutions.image.jpegxl.data.IntXL;
import com.idrsolutions.image.jpegxl.data.LFGlobal;
import com.idrsolutions.image.jpegxl.data.MathXL;
import java.util.ArrayList;

class Spline {
    final IntXL[] controlPoints;
    private FloatXL[] upsampled;
    private float[] coeffX;
    private float[] coeffY;
    private float[] coeffB;
    private float[] coeffSigma;
    private int splineID;

    Spline(IntXL[] controlPoints) {
        this.controlPoints = controlPoints;
    }

    private FloatXL[] upsampleControlPoints() {
        if (this.controlPoints.length == 1) {
            return new FloatXL[]{new FloatXL(this.controlPoints[0])};
        }
        IntXL[] extended = new IntXL[this.controlPoints.length + 2];
        extended[0] = this.controlPoints[0].plus(this.controlPoints[0]).minus(this.controlPoints[1]);
        System.arraycopy(this.controlPoints, 0, extended, 1, this.controlPoints.length);
        extended[extended.length - 1] = this.controlPoints[this.controlPoints.length - 1].plus(this.controlPoints[this.controlPoints.length - 1]).minus(this.controlPoints[this.controlPoints.length - 2]);
        FloatXL[] upsampled = new FloatXL[16 * (extended.length - 3) + 1];
        for (int i = 0; i < extended.length - 3; ++i) {
            int k;
            float[] t = new float[4];
            FloatXL[] p = new FloatXL[4];
            FloatXL[] a = new FloatXL[3];
            FloatXL[] b = new FloatXL[3];
            for (k = 0; k < 4; ++k) {
                p[k] = new FloatXL(extended[i + k]);
            }
            upsampled[i * 16] = p[1];
            t[0] = 0.0f;
            for (k = 1; k < 4; ++k) {
                t[k] = t[k - 1] + (float)Math.pow(p[k].minus(p[k - 1]).squared(), 0.25);
            }
            for (int step = 1; step < 16; ++step) {
                float f;
                int k2;
                float knot = t[1] + 0.0625f * (float)step * (t[2] - t[1]);
                for (k2 = 0; k2 < 3; ++k2) {
                    f = (knot - t[k2]) / (t[k2 + 1] - t[k2]);
                    a[k2] = p[k2 + 1].minus(p[k2]).multiply(f).plus(p[k2]);
                }
                for (k2 = 0; k2 < 2; ++k2) {
                    f = (knot - t[k2]) / (t[k2 + 2] - t[k2]);
                    b[k2] = a[k2 + 1].minus(a[k2]).multiply(f).plus(a[k2]);
                }
                float f2 = (knot - t[1]) / (t[2] - t[1]);
                upsampled[i * 16 + step] = b[1].minus(b[0]).multiply(f2).plus(b[0]);
            }
        }
        upsampled[upsampled.length - 1] = new FloatXL(this.controlPoints[this.controlPoints.length - 1]);
        return upsampled;
    }

    private Arc[] computeIntermediarySamples() {
        FloatXL current = this.upsampled[0];
        int nextID = 0;
        ArrayList<Arc> allSamples = new ArrayList<Arc>();
        allSamples.add(new Arc(current, 1.0f));
        block0: while (nextID < this.upsampled.length) {
            FloatXL prev = new FloatXL(current);
            float arcLengthFromPrevious = 0.0f;
            while (true) {
                if (nextID >= this.upsampled.length) {
                    allSamples.add(new Arc(prev, arcLengthFromPrevious));
                    continue block0;
                }
                FloatXL next = this.upsampled[nextID];
                float arcLengthToNext = next.minus(prev).norm();
                if (arcLengthFromPrevious + arcLengthToNext >= 1.0f) {
                    float f = (1.0f - arcLengthFromPrevious) / arcLengthToNext;
                    current = next.minus(prev).multiply(f).plus(prev);
                    allSamples.add(new Arc(current, 1.0f));
                    continue block0;
                }
                arcLengthFromPrevious += arcLengthToNext;
                prev = next;
                ++nextID;
            }
        }
        return allSamples.toArray(new Arc[0]);
    }

    private static float doFICT(float[] coeffs, float t) {
        float total = MathXL.SQRT_H * coeffs[0];
        for (int i = 1; i < 32; ++i) {
            total = (float)((double)total + (double)coeffs[i] * Math.cos((double)i * 0.09817477042468103 * ((double)t + 0.5)));
        }
        return total;
    }

    private void computeCoeffs(int splineID, LFGlobal lfGlobal) {
        this.coeffX = new float[32];
        this.coeffY = new float[32];
        this.coeffB = new float[32];
        this.coeffSigma = new float[32];
        float quantAdjust = (float)lfGlobal.splines.quantAdjust / 8.0f;
        float invQa = quantAdjust >= 0.0f ? 1.0f / (1.0f + quantAdjust) : 1.0f - quantAdjust;
        float yAdjust = 0.10606602f * invQa;
        float xAdjust = 0.005939697f * invQa;
        float bAdjust = 0.09899495f * invQa;
        float sigmaAdjust = 0.47135738f * invQa;
        for (int i = 0; i < 32; ++i) {
            this.coeffY[i] = (float)lfGlobal.splines.coeffY[splineID][i] * yAdjust;
            this.coeffX[i] = (float)lfGlobal.splines.coeffX[splineID][i] * xAdjust + lfGlobal.lfChanCorr.baseX * this.coeffY[i];
            this.coeffB[i] = (float)lfGlobal.splines.coeffB[splineID][i] * bAdjust + lfGlobal.lfChanCorr.baseB * this.coeffY[i];
            this.coeffSigma[i] = (float)lfGlobal.splines.coeffSigma[splineID][i] * sigmaAdjust;
        }
    }

    void renderSpline(Frame frame) {
        this.computeCoeffs(this.splineID, frame.getLFGlobal());
        this.upsampled = this.upsampleControlPoints();
        float renderDistance = 1.0f;
        Arc[] arcs = this.computeIntermediarySamples();
        float arcLength = ((float)arcs.length - 2.0f) * 1.0f + arcs[arcs.length - 1].len;
        if ((double)arcLength <= 0.0) {
            return;
        }
        for (int i = 0; i < arcs.length; ++i) {
            Arc arc = arcs[i];
            float progressAlongArc = Math.min(1.0f, (float)i * 1.0f / arcLength);
            float t = 31.0f * progressAlongArc;
            float[] values = new float[]{Spline.doFICT(this.coeffX, t) * arc.len, Spline.doFICT(this.coeffY, t) * arc.len, Spline.doFICT(this.coeffB, t) * arc.len};
            float sigma = Spline.doFICT(this.coeffSigma, t);
            float inverseSigma = 1.0f / sigma;
            float maxColor = MathXL.max(0.01f, values[0], values[1], values[2]);
            float maxDist = (float)Math.sqrt(-2.0f * sigma * sigma * ((float)Math.log(0.1) * 3.0f - maxColor));
            int xBegin = Math.max(0, MathXL.round(arc.pos.x - maxDist));
            int xEnd = Math.min(frame.getFrameHeader().width - 1, MathXL.round(arc.pos.x + maxDist));
            int yBegin = Math.max(0, MathXL.round(arc.pos.y - maxDist));
            int yEnd = Math.min(frame.getFrameHeader().height - 1, MathXL.round(arc.pos.y + maxDist));
            for (int c = 0; c < 3; ++c) {
                for (int y = yBegin; y <= yEnd; ++y) {
                    float[] buffer = frame.buffer[c][y];
                    int x = xBegin;
                    while (x <= xEnd) {
                        float diffX = (float)x - arc.pos.x;
                        float diffY = (float)y - arc.pos.y;
                        float distance = (float)Math.sqrt(diffX * diffX + diffY * diffY);
                        float factor = MathXL.erf((0.5f * distance + MathXL.SQRT_F) * inverseSigma);
                        float extra = 0.25f * values[c] * sigma * (factor -= MathXL.erf((0.5f * distance - MathXL.SQRT_F) * inverseSigma)) * factor;
                        int n = x++;
                        buffer[n] = buffer[n] + extra;
                    }
                }
            }
        }
    }

    static class Arc {
        final FloatXL pos;
        final float len;

        Arc(FloatXL pos, float len) {
            this.pos = pos;
            this.len = len;
        }
    }
}

