/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Frame;
import com.idrsolutions.image.jpegxl.data.GlobalModular;
import com.idrsolutions.image.jpegxl.data.HFPass;
import com.idrsolutions.image.jpegxl.data.MathXL;
import com.idrsolutions.image.jpegxl.data.ModularChannel;
import com.idrsolutions.image.jpegxl.data.ModularInfo;
import com.idrsolutions.image.jpegxl.data.PassInfo;
import java.io.IOException;

class Pass {
    final int minShift;
    final int maxShift;
    final ModularInfo[] replacedChannels;
    final HFPass hfPass;

    Pass(BitXL reader, Frame frame, int passIndex, int prevMinshift) throws IOException {
        this.maxShift = passIndex > 0 ? prevMinshift : 3;
        int n = -1;
        PassInfo passes = frame.getFrameHeader().passes;
        for (int i = 0; i < passes.lastPass.length; ++i) {
            if (passes.lastPass[i] != passIndex) continue;
            n = i;
            break;
        }
        this.minShift = n >= 0 ? MathXL.ceilLog1p(passes.downSample[n] - 1) : this.maxShift;
        GlobalModular globalModular = frame.getLFGlobal().gModular;
        this.replacedChannels = new ModularInfo[globalModular.stream.getEncodedChannelCount()];
        for (int i = 0; i < globalModular.stream.getEncodedChannelCount(); ++i) {
            int m;
            ModularChannel chan = globalModular.stream.getChannel(i);
            if (chan.isDecoded() || this.minShift > (m = Math.min(chan.hshift, chan.vshift)) || m >= this.maxShift) continue;
            this.replacedChannels[i] = new ModularInfo(chan);
        }
        this.hfPass = frame.getFrameHeader().encoding == 0 ? new HFPass(reader, frame) : null;
    }
}

