/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Entropy;
import com.idrsolutions.image.jpegxl.data.MathXL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.IntUnaryOperator;

class MTree {
    Entropy entropy;
    private MTree parent;
    private MTree leftChild;
    private MTree rightChild;
    private int property;
    private int value;
    private int leftChildIndex;
    private int rightChildIndex;
    int context;
    int predictor;
    int offset;
    int multiplier;

    private MTree() {
    }

    MTree(BitXL reader) throws IOException {
        this.parent = null;
        ArrayList<MTree> nodes = new ArrayList<MTree>();
        Entropy ent = new Entropy(reader, 6);
        int contextId = 0;
        int nodesRemaining = 1;
        while (nodesRemaining-- > 0) {
            MTree node;
            int propertyTemp = ent.readSymbol(reader, 1) - 1;
            MTree mTree = node = nodes.isEmpty() ? this : new MTree();
            if (propertyTemp >= 0) {
                node.value = MathXL.unpackSigned(ent.readSymbol(reader, 0));
                int leftChild = nodes.size() + nodesRemaining + 1;
                node.property = propertyTemp;
                node.predictor = -1;
                node.leftChildIndex = leftChild;
                node.rightChildIndex = leftChild + 1;
                nodes.add(node);
                nodesRemaining += 2;
                continue;
            }
            int contextTemp = contextId++;
            node.predictor = ent.readSymbol(reader, 2);
            node.offset = MathXL.unpackSigned(ent.readSymbol(reader, 3));
            int mulLog = ent.readSymbol(reader, 4);
            int mulBits = ent.readSymbol(reader, 5);
            node.multiplier = mulBits + 1 << mulLog;
            node.context = contextTemp;
            node.property = -1;
            nodes.add(node);
        }
        this.entropy = new Entropy(reader, (nodes.size() + 1) / 2);
        for (MTree node : nodes) {
            node.entropy = this.entropy;
            if (node.isLeafNode()) continue;
            node.leftChild = (MTree)nodes.get(node.leftChildIndex);
            node.rightChild = (MTree)nodes.get(node.rightChildIndex);
            node.leftChild.parent = node;
            node.rightChild.parent = node;
        }
    }

    boolean isLeafNode() {
        return this.property < 0;
    }

    boolean usesWeightedPredictor() {
        if (this.isLeafNode()) {
            return this.predictor == 6;
        }
        return this.property == 15 || this.leftChild.usesWeightedPredictor() || this.rightChild.usesWeightedPredictor();
    }

    MTree compact(int cIdx, int sIdx) {
        int prop;
        switch (this.property) {
            case 0: {
                prop = cIdx;
                break;
            }
            case 1: {
                prop = sIdx;
                break;
            }
            default: {
                return this;
            }
        }
        MTree branch = prop > this.value ? this.leftChild : this.rightChild;
        return branch.compact(cIdx, sIdx);
    }

    MTree compact(int cIdx, int sIdx, int y) {
        int prop;
        switch (this.property) {
            case 0: {
                prop = cIdx;
                break;
            }
            case 1: {
                prop = sIdx;
                break;
            }
            case 2: {
                prop = y;
                break;
            }
            default: {
                return this;
            }
        }
        MTree branch = prop > this.value ? this.leftChild : this.rightChild;
        return branch.compact(cIdx, sIdx, y);
    }

    MTree walk(IntUnaryOperator property) {
        if (this.isLeafNode()) {
            return this;
        }
        MTree branch = property.applyAsInt(this.property) > this.value ? this.leftChild : this.rightChild;
        return branch.walk(property);
    }
}

