/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Frame;
import com.idrsolutions.image.jpegxl.data.HFBlock;
import com.idrsolutions.image.jpegxl.data.HeaderFrame;
import com.idrsolutions.image.jpegxl.data.IntXL;
import com.idrsolutions.image.jpegxl.data.LFChannel;
import com.idrsolutions.image.jpegxl.data.LFGroup;
import com.idrsolutions.image.jpegxl.data.ModularInfo;
import com.idrsolutions.image.jpegxl.data.ModularStream;
import java.io.IOException;
import java.util.Arrays;

class LFCoeff {
    final float[][][] dequantLFCoeff;
    final int[][] lfIndex;
    final Frame frame;

    LFCoeff(BitXL reader, LFGroup parent, Frame frame, float[][][] lfBuffer) throws IOException {
        this.frame = frame;
        this.lfIndex = new int[parent.size.y][parent.size.x];
        IntXL sizeInPixels = frame.getLFGroupSize(parent.lfGroupID);
        IntXL pixelPos = frame.getLFGroupXY(parent.lfGroupID).toLeft(11);
        IntXL blockPos = pixelPos.toRight(3);
        IntXL sizeInBlocks = sizeInPixels.toRight(3);
        HeaderFrame header = frame.getFrameHeader();
        boolean adaptiveSmoothing = (header.flags & 0xA0L) == 0L;
        IntXL[] shift = header.jpegUpsampling;
        ModularInfo[] info = new ModularInfo[3];
        float[][][] dequantLFCoeff = new float[3][][];
        for (int i = 0; i < 3; ++i) {
            IntXL channelSize = sizeInBlocks.toRight(shift[i]);
            info[Frame.cMap[i]] = new ModularInfo(channelSize.x, channelSize.y, shift[i].x, shift[i].y);
            dequantLFCoeff[i] = new float[channelSize.y][channelSize.x];
        }
        if ((frame.getFrameHeader().flags & 0x20L) != 0L) {
            this.dequantLFCoeff = dequantLFCoeff;
            for (int c = 0; c < 3; ++c) {
                for (int y = 0; y < sizeInBlocks.y; ++y) {
                    System.arraycopy(lfBuffer[c][y + blockPos.y], blockPos.x, dequantLFCoeff[c][y], 0, sizeInBlocks.x);
                }
            }
            this.populateLFIndex(parent, null);
            return;
        }
        int extraPrecision = reader.u(2);
        ModularStream lfQuantStream = new ModularStream(reader, frame, 1 + parent.lfGroupID, info);
        lfQuantStream.decodeChannels(reader);
        int[][][] lfQuant = lfQuantStream.getDecodedBuffer();
        float[] scaledDequant = frame.getLFGlobal().quantizer.scaledDequant;
        for (int i = 0; i < 3; ++i) {
            int c = Frame.cMap[i];
            float sd = scaledDequant[i] / (float)(1 << extraPrecision);
            for (int y = 0; y < lfQuant[c].length; ++y) {
                float[] dq = dequantLFCoeff[i][y];
                int[] q = lfQuant[c][y];
                for (int x = 0; x < lfQuant[c][y].length; ++x) {
                    dq[x] = (float)q[x] * sd;
                }
            }
        }
        if (shift[0].x + shift[1].x + shift[2].x + shift[0].y + shift[1].y + shift[2].y == 0) {
            LFChannel lfc = frame.getLFGlobal().lfChanCorr;
            float kX = lfc.baseX + ((float)lfc.x - 128.0f) / (float)lfc.factor;
            float kB = lfc.baseB + ((float)lfc.b - 128.0f) / (float)lfc.factor;
            float[][] dqLFY = dequantLFCoeff[1];
            float[][] dqLFX = dequantLFCoeff[0];
            float[][] dqLFB = dequantLFCoeff[2];
            for (int y = 0; y < dqLFY.length; ++y) {
                float[] dqLFYy = dqLFY[y];
                float[] dqLFXy = dqLFX[y];
                float[] dqLFBy = dqLFB[y];
                for (int x = 0; x < dqLFYy.length; ++x) {
                    int n = x;
                    dqLFXy[n] = dqLFXy[n] + kX * dqLFYy[x];
                    int n2 = x;
                    dqLFBy[n2] = dqLFBy[n2] + kB * dqLFYy[x];
                }
            }
        }
        this.dequantLFCoeff = adaptiveSmoothing ? LFCoeff.adaptiveSmooth(dequantLFCoeff, scaledDequant) : (float[][][])dequantLFCoeff;
        this.populateLFIndex(parent, lfQuant);
    }

    private void populateLFIndex(LFGroup parent, int[][][] lfQuant) {
        HFBlock hfctx = this.frame.getLFGlobal().hfBlockCtx;
        for (int y = 0; y < parent.size.y; ++y) {
            int[] lfi = this.lfIndex[y];
            for (int x = 0; x < parent.size.x; ++x) {
                lfi[x] = LFCoeff.getLFIndex(lfQuant, hfctx, new IntXL(x, y), this.frame.getFrameHeader().jpegUpsampling);
            }
        }
    }

    private static float[][][] adaptiveSmooth(float[][][] coeff, float[] scaledDequant) {
        int x;
        float[] gy;
        float[][][] weighted = new float[3][][];
        float[][] gap = new float[coeff[0].length][];
        float[][][] dequantLFCoeff = new float[3][][];
        for (int i = 0; i < 3; ++i) {
            float[][] co = coeff[i];
            weighted[i] = new float[co.length][];
            float sd = scaledDequant[i];
            for (int y = 1; y < co.length - 1; ++y) {
                float[] coy = co[y];
                float[] coym = co[y - 1];
                float[] coyp = co[y + 1];
                if (gap[y] == null) {
                    gap[y] = new float[coy.length];
                    Arrays.fill(gap[y], 0.5f);
                }
                gy = gap[y];
                weighted[i][y] = new float[coy.length];
                float[] wy = weighted[i][y];
                for (x = 1; x < coy.length - 1; ++x) {
                    float sample = coy[x];
                    float adjacent = coy[x - 1] + coy[x + 1] + coym[x] + coyp[x];
                    float diag = coym[x - 1] + coym[x + 1] + coyp[x - 1] + coyp[x + 1];
                    wy[x] = 0.052262735f * sample + 0.2034514f * adjacent + 0.03348292f * diag;
                    float g = Math.abs(sample - wy[x]) * sd;
                    if (!(g > gy[x])) continue;
                    gy[x] = g;
                }
            }
        }
        for (float[] gap1 : gap) {
            if (gap1 == null) continue;
            float[] gy2 = gap1;
            for (int x2 = 0; x2 < gy2.length; ++x2) {
                gy2[x2] = Math.max(0.0f, 3.0f - 4.0f * gy2[x2]);
            }
        }
        for (int i = 0; i < 3; ++i) {
            float[][] co = coeff[i];
            dequantLFCoeff[i] = new float[co.length][];
            float[][] dqi = dequantLFCoeff[i];
            float[][] wi = weighted[i];
            for (int y = 0; y < co.length; ++y) {
                float[] coy = co[y];
                dqi[y] = new float[coy.length];
                float[] dqy = dqi[y];
                gy = gap[y];
                float[] wiy = wi[y];
                if (y == 0 || y + 1 == co.length) {
                    System.arraycopy(coy, 0, dqy, 0, coy.length);
                    continue;
                }
                for (x = 0; x < coy.length; ++x) {
                    dqy[x] = x == 0 || x + 1 == coy.length ? coy[x] : (coy[x] - wiy[x]) * gy[x] + wiy[x];
                }
            }
        }
        return dequantLFCoeff;
    }

    private static int getLFIndex(int[][][] lfQuant, HFBlock hfctx, IntXL blockPos, IntXL[] upsampling) {
        int[] index = new int[3];
        for (int i = 0; i < 3; ++i) {
            int[] hft;
            IntXL shifted = blockPos.toRight(upsampling[i]);
            for (int k : hft = hfctx.lfThresholds[i]) {
                if (lfQuant[Frame.cMap[i]][shifted.y][shifted.x] <= k) continue;
                int n = i;
                index[n] = index[n] + 1;
            }
        }
        int idx = index[0];
        idx *= hfctx.lfThresholds[2].length + 1;
        idx += index[2];
        idx *= hfctx.lfThresholds[1].length + 1;
        return idx += index[1];
    }
}

