/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.CIERGB;
import com.idrsolutions.image.jpegxl.data.CIEXY;
import com.idrsolutions.image.jpegxl.data.ColorUtil;
import com.idrsolutions.image.jpegxl.data.ColorXL;
import com.idrsolutions.image.jpegxl.data.HeaderImage;
import com.idrsolutions.image.jpegxl.data.MathXL;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.io.IOException;
import java.util.function.DoubleUnaryOperator;

public class ImageXL {
    private final DataBufferFloat buffer;
    private final HeaderImage imageHeader;
    int primaries;
    int whitePoint;
    int transfer;
    int taggedTransfer;
    private final CIEXY white1931;
    private final CIERGB primaries1931;
    private final byte[] iccProfile;
    int width;
    int height;

    ImageXL(float[][][] buffer, HeaderImage header) throws IOException {
        this.width = buffer[0][0].length;
        this.height = buffer[0].length;
        int channels = header.getColorChannelCount() + (header.hasAlpha() ? 1 : 0);
        float[][] dataArray = new float[channels][this.width * this.height];
        for (int c = 0; c < channels; ++c) {
            for (int y = 0; y < this.height; ++y) {
                System.arraycopy(buffer[c][y], 0, dataArray[c], y * this.width, this.width);
            }
        }
        this.buffer = new DataBufferFloat(dataArray, this.width * this.height);
        ColorXL bundle = header.getColorEncoding();
        this.imageHeader = header;
        this.primaries = bundle.primaries;
        this.whitePoint = bundle.whitePoint;
        this.primaries1931 = bundle.prim;
        this.white1931 = bundle.white;
        if (this.imageHeader.isXYBEncoded()) {
            this.transfer = 0x1000008;
            this.iccProfile = null;
        } else {
            this.transfer = bundle.tf;
            this.iccProfile = header.getDecodedICC();
        }
        this.taggedTransfer = bundle.tf;
    }

    public BufferedImage asBufferedImage() {
        BufferedImage image;
        if (this.iccProfile != null) {
            return this.getImageFromICC();
        }
        float[][] primariesToSRGB = ColorUtil.getConversionMatrix(ColorUtil.PRI_SRGB, ColorUtil.WP_D65, this.primaries1931, this.white1931);
        DoubleUnaryOperator inverseTransferFunction = ColorUtil.getInverseTransfer(this.transfer);
        int nComp = this.imageHeader.getColorChannelCount();
        DoubleUnaryOperator sRGBTransfer = ColorUtil.getTransferFunction(0x100000D);
        float[] fRGB = new float[3];
        float[] sRGB = new float[3];
        int p = 0;
        if (nComp == 1) {
            image = new BufferedImage(this.width, this.height, 10);
            byte[] pixelsByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            float[][] dataBuffer = this.buffer.getBankData();
            for (int y = 0; y < this.height; ++y) {
                int yw = y * this.width;
                for (int x = 0; x < this.width; ++x) {
                    fRGB[0] = dataBuffer[0][yw + x];
                    ImageXL.linearize(fRGB, 1, inverseTransferFunction);
                    MathXL.mmMutliplyFixed(primariesToSRGB, fRGB, sRGB);
                    fRGB[0] = MathXL.clamp((float)sRGBTransfer.applyAsDouble(sRGB[0]), 0.0f, 1.0f);
                    pixelsByte[p++] = (byte)(fRGB[0] * 255.0f);
                }
            }
        } else {
            image = new BufferedImage(this.width, this.height, 5);
            byte[] pixelsByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            float[][] dataBuffer = this.buffer.getBankData();
            float[] c0 = dataBuffer[0];
            float[] c1 = dataBuffer[1];
            float[] c2 = dataBuffer[2];
            for (int y = 0; y < this.height; ++y) {
                int yw = y * this.width;
                for (int x = 0; x < this.width; ++x) {
                    fRGB[0] = c0[yw + x];
                    fRGB[1] = c1[yw + x];
                    fRGB[2] = c2[yw + x];
                    ImageXL.linearize(fRGB, nComp, inverseTransferFunction);
                    MathXL.mmMutliplyFixed(primariesToSRGB, fRGB, sRGB);
                    fRGB[0] = MathXL.clamp((float)sRGBTransfer.applyAsDouble(sRGB[0]), 0.0f, 1.0f);
                    fRGB[1] = MathXL.clamp((float)sRGBTransfer.applyAsDouble(sRGB[1]), 0.0f, 1.0f);
                    fRGB[2] = MathXL.clamp((float)sRGBTransfer.applyAsDouble(sRGB[2]), 0.0f, 1.0f);
                    pixelsByte[p++] = (byte)(fRGB[2] * 255.0f);
                    pixelsByte[p++] = (byte)(fRGB[1] * 255.0f);
                    pixelsByte[p++] = (byte)(fRGB[0] * 255.0f);
                }
            }
        }
        return image;
    }

    private BufferedImage getImageFromICC() {
        BufferedImage image;
        ICC_ColorSpace cs = new ICC_ColorSpace(ICC_Profile.getInstance(this.iccProfile));
        if (cs.getNumComponents() == 1) {
            image = new BufferedImage(this.width, this.height, 10);
            byte[] pixelsByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            float[] frgb = new float[3];
            int p = 0;
            float[][] dataBuffer = this.buffer.getBankData();
            for (int y = 0; y < this.height; ++y) {
                int yw = y * this.width;
                for (int x = 0; x < this.width; ++x) {
                    frgb[0] = dataBuffer[0][yw + x];
                    float[] srgb = ((ColorSpace)cs).toRGB(frgb);
                    pixelsByte[p++] = (byte)(srgb[0] * 255.0f);
                }
            }
        } else {
            image = new BufferedImage(this.width, this.height, 5);
            byte[] pixelsByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            float[] fRGB = new float[3];
            int p = 0;
            float[][] dataBuffer = this.buffer.getBankData();
            for (int y = 0; y < this.height; ++y) {
                int yw = y * this.width;
                for (int x = 0; x < this.width; ++x) {
                    fRGB[0] = dataBuffer[0][yw + x];
                    fRGB[1] = dataBuffer[1][yw + x];
                    fRGB[2] = dataBuffer[2][yw + x];
                    float[] srgb = ((ColorSpace)cs).toRGB(fRGB);
                    pixelsByte[p++] = (byte)(srgb[2] * 255.0f);
                    pixelsByte[p++] = (byte)(srgb[1] * 255.0f);
                    pixelsByte[p++] = (byte)(srgb[0] * 255.0f);
                }
            }
        }
        return image;
    }

    private static void linearize(float[] colorValue, int nComp, DoubleUnaryOperator inverseTransferFunction) {
        for (int i = 0; i < nComp; ++i) {
            colorValue[i] = (float)inverseTransferFunction.applyAsDouble(colorValue[i]);
        }
        if (nComp < 3) {
            colorValue[1] = colorValue[2] = colorValue[0];
        }
    }
}

