/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import java.io.IOException;

class HeaderSize {
    final int width;
    final int height;

    HeaderSize(BitXL reader) throws IOException {
        boolean div8 = reader.bool();
        this.height = div8 ? 1 + reader.u(5) << 3 : reader.u32(1, 9, 1, 13, 1, 18, 1, 30);
        int ratio = reader.u(3);
        this.width = ratio != 0 ? HeaderSize.formRatio(ratio, this.height) : (div8 ? 1 + reader.u(5) << 3 : reader.u32(1, 9, 1, 13, 1, 18, 1, 30));
    }

    private static int formRatio(int ratio, int height) {
        return switch (ratio) {
            case 2 -> (int)((long)height * 6L / 5L);
            case 3 -> (int)((long)height * 4L / 3L);
            case 4 -> (int)((long)height * 3L / 2L);
            case 5 -> (int)((long)height * 16L / 9L);
            case 6 -> (int)((long)height * 5L / 4L);
            case 7 -> height * 2;
            default -> height;
        };
    }
}

