/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.ColorXL;
import com.idrsolutions.image.jpegxl.data.Entropy;
import com.idrsolutions.image.jpegxl.data.HeaderBitDepth;
import com.idrsolutions.image.jpegxl.data.HeaderSize;
import com.idrsolutions.image.jpegxl.data.IntXL;
import com.idrsolutions.image.jpegxl.data.Inverse;
import com.idrsolutions.image.jpegxl.data.MathXL;
import com.idrsolutions.image.jpegxl.data.Tone;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class HeaderImage {
    static final int CODESTREAM_HEADER = 2815;
    static final float[] DEFAULT_UP2 = new float[]{-0.017162f, -0.03452303f, -0.04022174f, -0.02921014f, -0.00624645f, 0.14111091f, 0.28896755f, 0.00278718f, -0.01610267f, 0.5666155f, 0.03777607f, -0.01986694f, -0.03144731f, -0.01185068f, -0.00213539f};
    static final float[] DEFAULT_UP4 = new float[]{-0.02419067f, -0.03491987f, -0.03693351f, -0.03094285f, -0.00529785f, -0.01663432f, -0.03556863f, -0.03888905f, -0.0351685f, -0.00989469f, 0.23651958f, 0.33392945f, -0.01073543f, -0.01313181f, -0.03556694f, 0.13048175f, 0.40103024f, 0.0395115f, -0.02077584f, 0.469142f, -0.0020927f, -0.01484589f, -0.04064806f, 0.1894253f, 0.5627989f, 0.066744f, -0.02335494f, -0.03551682f, -0.0075483f, -0.02267919f, -0.02363578f, 0.00315804f, -0.03399098f, -0.01359519f, -9.1653E-4f, -0.00335467f, -0.01163294f, -0.01610294f, -0.00974088f, -0.00191622f, -0.01095446f, -0.03198464f, -0.04455121f, -0.0279979f, -0.00645912f, 0.06390599f, 0.22963887f, 0.00630981f, -0.01897349f, 0.67537266f, 0.08483369f, -0.02534994f, -0.02205197f, -0.01667999f, -0.00384443f};
    static final float[] DEFAULT_UP8 = new float[]{-0.02928613f, -0.03706353f, -0.03783812f, -0.03324558f, -0.00447632f, -0.02519406f, -0.03752601f, -0.03901508f, -0.03663285f, -0.00646649f, -0.02066407f, -0.03838633f, -0.04002101f, -0.03900035f, -0.00901973f, -0.01626393f, -0.03954148f, -0.0404662f, -0.03979621f, -0.01224485f, 0.2989533f, 0.3575771f, -0.02447552f, -0.01081748f, -0.04314594f, 0.2390322f, 0.411193f, -0.00573046f, -0.01450239f, -0.04246845f, 0.17567618f, 0.45220643f, 0.02287757f, -0.01936783f, -0.03583255f, 0.11572472f, 0.47416732f, 0.0628444f, -0.02685066f, 0.4272005f, -0.02248939f, -0.01155273f, -0.04562755f, 0.28689495f, 0.4909387f, -7.891E-5f, -0.01545926f, -0.04562659f, 0.2123892f, 0.53980935f, 0.03369474f, -0.02070211f, -0.03866988f, 0.1422955f, 0.565934f, 0.08045181f, -0.02888298f, -0.03680918f, -0.00542229f, -0.02920477f, -0.02788574f, -0.0211818f, -0.03942402f, -0.00775547f, -0.02433614f, -0.03193943f, -0.02030828f, -0.04044014f, -0.01074016f, -0.01930822f, -0.03620399f, -0.01974125f, -0.03919545f, -0.01456093f, -4.5072E-4f, -0.0036011f, -0.01020207f, -0.01231907f, -0.00638988f, -7.1592E-4f, -0.00279122f, -0.00957115f, -0.01288327f, -0.00730937f, -0.00107783f, -0.00210156f, -0.00890705f, -0.01317668f, -0.00813895f, -0.00153491f, -0.02128481f, -0.04173044f, -0.04831487f, -0.0329319f, -0.0052526f, -0.01720322f, -0.04052736f, -0.05045706f, -0.03607317f, -0.0073803f, -0.01341764f, -0.03965629f, -0.05151616f, -0.03814886f, -0.01005819f, 0.18968274f, 0.33063683f, -0.01300105f, -0.0137295f, -0.04017465f, 0.13727832f, 0.36402234f, 0.0102789f, -0.01832107f, -0.03365072f, 0.08734506f, 0.38194296f, 0.04338228f, -0.02525993f, 0.56408125f, 0.00458352f, -0.01648227f, -0.04887868f, 0.2458552f, 0.6202614f, 0.04314807f, -0.02213737f, -0.04158014f, 0.1663729f, 0.6502702f, 0.09621636f, -0.03101388f, -0.04082742f, -0.00904519f, -0.02790922f, -0.02117818f, 0.00798662f, -0.03995711f, -0.01243427f, -0.02231705f, -0.02946266f, 0.00992055f, -0.03600283f, -0.0168492f, -0.00111684f, -0.00411204f, -0.0129713f, -0.01723725f, -0.01022545f, -0.00165306f, -0.0031311f, -0.01218016f, -0.01763266f, -0.0112562f, -0.00231663f, -0.01374149f, -0.0379762f, -0.05142937f, -0.03117307f, -0.00581914f, -0.01064003f, -0.03608089f, -0.05272168f, -0.0337567f, -0.00795586f, 0.09628104f, 0.2712999f, -0.00353779f, -0.01734151f, -0.03153981f, 0.0568623f, 0.28500998f, 0.02230594f, -0.02374955f, 0.6821433f, 0.05018048f, -0.02320852f, -0.04383616f, 0.18459474f, 0.71517974f, 0.10805613f, -0.03263677f, -0.03637639f, -0.01394373f, -0.02511203f, -0.01728636f, 0.05407331f, -0.02867568f, -0.01893131f, -0.00240854f, -0.00446511f, -0.01636187f, -0.02377053f, -0.01522848f, -0.00333334f, -0.00819975f, -0.02964169f, -0.04499287f, -0.0274535f, -0.00612408f, 0.02727416f, 0.194466f, 0.00159832f, -0.02232473f, 0.74982506f, 0.1145262f, -0.03348048f, -0.01605681f, -0.02070339f, -0.00458223f};
    private static final char[] MNTRGB = "mntrRGB XYZ ".toCharArray();
    private static final char[] ACSP = "acsp".toCharArray();
    private static final String[] iccTags = new String[]{"cprt", "wtpt", "bkpt", "rXYZ", "gXYZ", "bXYZ", "kXYZ", "rTRC", "gTRC", "bTRC", "kTRC", "chad", "desc", "chrm", "dmnd", "dmdd", "lumi"};
    private HeaderSize size;
    private int orientedW;
    private int orientedH;
    private int level = 5;
    private int orientation;
    private HeaderSize intrinsicSize;
    private boolean previewHeader;
    private HeaderBitDepth bitDepth;
    private boolean modular16bitBuffers = true;
    private ExtraChannel[] extraChannels;
    private boolean xybEncoded = true;
    private ColorXL colorEncoding;
    private Tone tone;
    private Inverse opsinInverseMatrix;
    private float[] up2weights;
    private float[] up4weights;
    private float[] up8weights;
    private float[][][][][] upWeights;
    private int[] alphaIndices;
    private byte[] encodedICC;
    private byte[] decodedICC;
    boolean hasAnimation;

    private static int getICCContext(byte[] buffer, int index) {
        if (index <= 128) {
            return 0;
        }
        int b1 = buffer[index - 1] & 0xFF;
        int b2 = buffer[index - 2] & 0xFF;
        int p1 = b1 >= 97 && b1 <= 122 || b1 >= 65 && b1 <= 90 ? 0 : (b1 >= 48 && b1 <= 57 || b1 == 46 || b1 == 44 ? 1 : (b1 <= 1 ? 2 + b1 : (b1 < 16 ? 4 : (b1 > 240 && b1 < 255 ? 5 : (b1 == 255 ? 6 : 7)))));
        int p2 = b2 >= 97 && b2 <= 122 || b2 >= 65 && b2 <= 90 ? 0 : (b2 >= 48 && b2 <= 57 || b2 == 46 || b2 == 44 ? 1 : (b2 < 16 ? 2 : (b2 > 240 ? 3 : 4)));
        return 1 + p1 + 8 * p2;
    }

    private HeaderImage() {
    }

    private static void skipAnimationHeader(BitXL reader) throws IOException {
        reader.u32(100, 0, 1000, 0, 1, 10, 1, 30);
        reader.u32(1, 0, 1001, 0, 1, 8, 1, 10);
        reader.u32(0, 0, 0, 3, 0, 16, 0, 32);
        reader.bool();
    }

    static HeaderImage parse(BitXL reader, int level) throws IOException {
        int i;
        int cwMask;
        boolean defaultMatrix;
        boolean extraFields;
        HeaderImage header = new HeaderImage();
        if (reader.u(16) != 2815) {
            throw new IOException("Not a JpegXL Codestream");
        }
        header.setLevel(level);
        header.size = new HeaderSize(reader);
        boolean allDefault = reader.bool();
        boolean bl = extraFields = !allDefault && reader.bool();
        if (extraFields) {
            header.orientation = 1 + reader.u(3);
            if (reader.bool()) {
                header.intrinsicSize = new HeaderSize(reader);
            }
            if (reader.bool()) {
                header.previewHeader = true;
                HeaderImage.skipPreviewHeader(reader);
            }
            if (reader.bool()) {
                HeaderImage.skipAnimationHeader(reader);
                header.hasAnimation = true;
            }
        } else {
            header.orientation = 1;
        }
        if (header.orientation > 4) {
            header.orientedW = header.size.height;
            header.orientedH = header.size.width;
        } else {
            header.orientedW = header.size.width;
            header.orientedH = header.size.height;
        }
        if (allDefault) {
            header.bitDepth = new HeaderBitDepth();
            header.modular16bitBuffers = true;
            header.extraChannels = new ExtraChannel[0];
            header.xybEncoded = true;
            header.colorEncoding = new ColorXL();
        } else {
            header.bitDepth = new HeaderBitDepth(reader);
            header.modular16bitBuffers = reader.bool();
            int extraChannelCount = reader.u32(0, 0, 1, 0, 2, 4, 1, 12);
            header.extraChannels = new ExtraChannel[extraChannelCount];
            int[] alphaIndices = new int[extraChannelCount];
            int numAlphaChannels = 0;
            for (int i2 = 0; i2 < extraChannelCount; ++i2) {
                header.extraChannels[i2] = new ExtraChannel(reader);
                if (header.extraChannels[i2].type != 0) continue;
                alphaIndices[numAlphaChannels++] = i2;
            }
            header.alphaIndices = new int[numAlphaChannels];
            System.arraycopy(alphaIndices, 0, header.alphaIndices, 0, numAlphaChannels);
            header.xybEncoded = reader.bool();
            header.colorEncoding = new ColorXL(reader);
        }
        Tone tone = header.tone = extraFields ? new Tone(reader) : new Tone();
        if (!allDefault) {
            MathXL.skipExtensions(reader);
        }
        header.opsinInverseMatrix = !(defaultMatrix = reader.bool()) && header.xybEncoded ? new Inverse(reader) : new Inverse();
        int n = cwMask = defaultMatrix ? 0 : reader.u(3);
        if ((cwMask & 1) != 0) {
            header.up2weights = new float[15];
            for (i = 0; i < header.up2weights.length; ++i) {
                header.up2weights[i] = reader.f16();
            }
        } else {
            header.up2weights = DEFAULT_UP2;
        }
        if ((cwMask & 2) != 0) {
            header.up4weights = new float[55];
            for (i = 0; i < header.up4weights.length; ++i) {
                header.up4weights[i] = reader.f16();
            }
        } else {
            header.up4weights = DEFAULT_UP4;
        }
        if ((cwMask & 4) != 0) {
            header.up8weights = new float[210];
            for (i = 0; i < header.up8weights.length; ++i) {
                header.up8weights[i] = reader.f16();
            }
        } else {
            header.up8weights = DEFAULT_UP8;
        }
        if (header.colorEncoding.useIccProfile) {
            int encodedSize;
            try {
                encodedSize = Math.toIntExact(reader.u64());
            }
            catch (ArithmeticException ex) {
                throw new IOException(ex);
            }
            header.encodedICC = new byte[encodedSize];
            Entropy iccDistribution = new Entropy(reader, 41);
            for (int i3 = 0; i3 < encodedSize; ++i3) {
                header.encodedICC[i3] = (byte)iccDistribution.readSymbol(reader, HeaderImage.getICCContext(header.encodedICC, i3));
            }
        }
        reader.zeroPadToByte();
        return header;
    }

    private static void skipPreviewHeader(BitXL reader) throws IOException {
        boolean div8 = reader.bool();
        if (div8) {
            reader.u32(16, 0, 32, 0, 1, 5, 33, 9);
        } else {
            reader.u32(1, 6, 65, 8, 321, 10, 1345, 12);
        }
        int ratio = reader.u(3);
        if (ratio == 0) {
            if (div8) {
                reader.u32(16, 0, 32, 0, 1, 5, 33, 9);
            } else {
                reader.u32(1, 6, 65, 8, 321, 10, 1345, 12);
            }
        }
    }

    HeaderSize getSize() {
        return this.size;
    }

    boolean getPreviewHeader() {
        return this.previewHeader;
    }

    int getOrientation() {
        return this.orientation;
    }

    HeaderBitDepth getBitDepthHeader() {
        return this.bitDepth;
    }

    int getExtraChannelCount() {
        return this.extraChannels.length;
    }

    int getNumAlphaChannels() {
        return this.alphaIndices != null ? this.alphaIndices.length : 0;
    }

    boolean hasAlpha() {
        return this.getNumAlphaChannels() > 0;
    }

    int getAlphaIndex(int alphaChannel) {
        return this.alphaIndices[alphaChannel];
    }

    int getColorChannelCount() {
        return this.getColorEncoding().colorEncoding == 1 ? 1 : 3;
    }

    ExtraChannel getExtraChannel(int index) {
        return this.extraChannels[index];
    }

    boolean isXYBEncoded() {
        return this.xybEncoded;
    }

    ColorXL getColorEncoding() {
        return this.colorEncoding;
    }

    Tone getToneMapping() {
        return this.tone;
    }

    Inverse getOpsinInverseMatrix() {
        return this.opsinInverseMatrix;
    }

    float[][][][][] getUpWeights() {
        if (this.upWeights != null) {
            return this.upWeights;
        }
        this.upWeights = new float[3][][][][];
        for (int l = 0; l < 3; ++l) {
            int k = 1 << l + 1;
            float[] upKWeights = k == 8 ? this.up8weights : (k == 4 ? this.up4weights : (float[])(k == 2 ? this.up2weights : null));
            this.upWeights[l] = new float[k][k][5][5];
            for (int ky = 0; ky < k; ++ky) {
                for (int kx = 0; kx < k; ++kx) {
                    for (int ix = 0; ix < 5; ++ix) {
                        for (int iy = 0; iy < 5; ++iy) {
                            int j = ky < k / 2 ? iy + 5 * ky : 4 - iy + 5 * (k - 1 - ky);
                            int i = kx < k / 2 ? ix + 5 * kx : 4 - ix + 5 * (k - 1 - kx);
                            int x = Math.max(i, j);
                            int y = Math.min(i, j);
                            int index = 5 * k * y / 2 - y * (y - 1) / 2 + x - y;
                            if (upKWeights == null) continue;
                            this.upWeights[l][ky][kx][iy][ix] = upKWeights[index];
                        }
                    }
                }
            }
        }
        return this.upWeights;
    }

    void setLevel(int level) {
        this.level = level;
    }

    private static int getICCPred(byte[] buffer, int i) {
        if (i <= 3) {
            return buffer.length >>> 8 * (3 - i);
        }
        if (i == 8) {
            return 4;
        }
        if (i >= 12 && i <= 23) {
            return MNTRGB[i - 12];
        }
        if (i >= 36 && i <= 39) {
            return ACSP[i - 36];
        }
        switch (buffer[40]) {
            case 65: {
                if (i == 41 || i == 42) {
                    return 80;
                }
                if (i != 43) break;
                return 76;
            }
            case 77: {
                if (i == 41) {
                    return 83;
                }
                if (i == 42) {
                    return 70;
                }
                if (i != 43) break;
                return 84;
            }
            case 83: {
                if (buffer[41] == 71) {
                    if (i == 42) {
                        return 73;
                    }
                    if (i != 43) break;
                    return 32;
                }
                if (buffer[41] != 85) break;
                if (i == 42) {
                    return 78;
                }
                if (i != 43) break;
                return 87;
            }
        }
        if (i == 70) {
            return 246;
        }
        if (i == 71) {
            return 214;
        }
        if (i == 73) {
            return 1;
        }
        if (i == 78) {
            return 211;
        }
        if (i == 79) {
            return 45;
        }
        if (i >= 80 && i < 84) {
            return buffer[i - 76];
        }
        return 0;
    }

    private static byte[] shuffle(byte[] buffer, int width) {
        int height = MathXL.ceilDiv(buffer.length, width);
        byte[] result = new byte[buffer.length];
        for (int i = 0; i < buffer.length; ++i) {
            int j = IntXL.coordinates(i, height).transpose().unwrapCoord(width);
            result[j] = buffer[i];
        }
        return result;
    }

    synchronized byte[] getDecodedICC() throws IOException {
        if (this.decodedICC != null) {
            return this.decodedICC;
        }
        if (this.encodedICC == null) {
            return null;
        }
        BitXL commandReader = new BitXL(new ByteArrayInputStream(this.encodedICC));
        int outputSize = commandReader.variant();
        int commandSize = commandReader.variant();
        int commandStart = (int)(commandReader.getBitsCount() >> 3);
        int dataStart = commandStart + commandSize;
        BitXL dataReader = new BitXL(new ByteArrayInputStream(this.encodedICC, dataStart, this.encodedICC.length - dataStart));
        int headerSize = Math.min(128, outputSize);
        this.decodedICC = new byte[outputSize];
        int resultPos = 0;
        for (int i = 0; i < headerSize; ++i) {
            int e = dataReader.u(8);
            int p = HeaderImage.getICCPred(this.decodedICC, i);
            this.decodedICC[resultPos++] = (byte)(p + e & 0xFF);
        }
        if (resultPos == outputSize) {
            return this.decodedICC;
        }
        int tagCount = commandReader.variant() - 1;
        if (tagCount >= 0) {
            int command;
            int tagCode;
            for (int i = 24; i >= 0; i -= 8) {
                this.decodedICC[resultPos++] = (byte)(tagCount >>> i & 0xFF);
            }
            int prevTagStart = 128 + tagCount * 12;
            int prevTagSize = 0;
            while (!commandReader.atEnd() && commandReader.getBitsCount() >> 3 < (long)dataStart && (tagCode = (command = commandReader.u(8)) & 0x3F) != 0) {
                String[] tags;
                String[] stringArray;
                int tagSize;
                int tagStart;
                String tag;
                byte[] tcr;
                if (tagCode == 1) {
                    tcr = new byte[4];
                    for (int i = 0; i < 4; ++i) {
                        tcr[i] = (byte)dataReader.u(8);
                    }
                    tag = new String(tcr, StandardCharsets.US_ASCII);
                } else {
                    tag = tagCode == 2 ? "rTRC" : (tagCode == 3 ? "rXYZ" : (tagCode >= 4 && tagCode <= 21 ? iccTags[tagCode - 4] : "0000"));
                }
                int n = tagStart = (command & 0x40) > 0 ? commandReader.variant() : prevTagStart + prevTagSize;
                prevTagSize = tagSize = (command & 0x80) > 0 ? commandReader.variant() : (Arrays.asList("rXYZ", "gXYZ", "bXYZ", "kXYZ", "wtpt", "bkpt", "lumi").contains(tag) ? 20 : prevTagSize);
                prevTagStart = tagStart;
                if (tagCode == 2) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "rTRC";
                    stringArray2[1] = "gTRC";
                    stringArray = stringArray2;
                    stringArray2[2] = "bTRC";
                } else if (tagCode == 3) {
                    String[] stringArray3 = new String[3];
                    stringArray3[0] = "rXYZ";
                    stringArray3[1] = "gXYZ";
                    stringArray = stringArray3;
                    stringArray3[2] = "bXYZ";
                } else {
                    String[] stringArray4 = new String[1];
                    stringArray = stringArray4;
                    stringArray4[0] = tag;
                }
                for (String wTag : tags = stringArray) {
                    int i;
                    tcr = wTag.getBytes(StandardCharsets.US_ASCII);
                    for (i = 0; i < 4; ++i) {
                        this.decodedICC[resultPos++] = (byte)(tcr[i] & 0xFF);
                    }
                    for (i = 24; i >= 0; i -= 8) {
                        this.decodedICC[resultPos++] = (byte)(tagStart >>> i & 0xFF);
                    }
                    for (i = 24; i >= 0; i -= 8) {
                        this.decodedICC[resultPos++] = (byte)(tagSize >>> i & 0xFF);
                    }
                    if (tagCode != 3) continue;
                    tagStart += tagSize;
                }
            }
        }
        while (!commandReader.atEnd() && commandReader.getBitsCount() >> 3 < (long)dataStart) {
            int command = commandReader.u(8);
            if (command == 1) {
                int num = commandReader.variant();
                for (int i = 0; i < num; ++i) {
                    this.decodedICC[resultPos++] = (byte)dataReader.u(8);
                }
                continue;
            }
            if (command == 2 || command == 3) {
                int num = commandReader.variant();
                byte[] b = new byte[num];
                for (int p = 0; p < num; ++p) {
                    b[p] = (byte)dataReader.u(8);
                }
                int width = command == 2 ? 2 : 4;
                b = HeaderImage.shuffle(b, width);
                System.arraycopy(b, 0, this.decodedICC, resultPos, b.length);
                resultPos += b.length;
                continue;
            }
            if (command == 4) {
                int flags = commandReader.u(8);
                int width = (flags & 3) + 1;
                int order = (flags & 0xC) >>> 2;
                int stride = (flags & 0x10) > 0 ? commandReader.variant() : width;
                int num = commandReader.variant();
                byte[] b = new byte[num];
                for (int p = 0; p < num; ++p) {
                    b[p] = (byte)dataReader.u(8);
                }
                if (width == 2 || width == 4) {
                    b = HeaderImage.shuffle(b, width);
                }
                for (int i = 0; i < num; i += width) {
                    int n = order + 1;
                    int[] prev = new int[n];
                    for (int j = 0; j < n; ++j) {
                        for (int k = 0; k < width; ++k) {
                            int n2 = j;
                            prev[n2] = prev[n2] << 8;
                            int n3 = j;
                            prev[n3] = prev[n3] | this.decodedICC[resultPos - stride * (j + 1) + k] & 0xFF;
                        }
                    }
                    int p = order == 0 ? prev[0] : (order == 1 ? 2 * prev[0] - prev[1] : 3 * prev[0] - 3 * prev[1] + prev[2]);
                    for (int j = 0; j < width && i + j < num; ++j) {
                        this.decodedICC[resultPos++] = (byte)(b[i + j] + (p >>> 8 * (width - 1 - j)) & 0xFF);
                    }
                }
                continue;
            }
            if (command == 10) {
                this.decodedICC[resultPos++] = 88;
                this.decodedICC[resultPos++] = 89;
                this.decodedICC[resultPos++] = 90;
                this.decodedICC[resultPos++] = 32;
                resultPos += 4;
                for (int i = 0; i < 12; ++i) {
                    this.decodedICC[resultPos++] = (byte)dataReader.u(8);
                }
                continue;
            }
            if (command < 16 || command >= 24) continue;
            String[] s = new String[]{"XYZ ", "desc", "text", "mluc", "para", "curv", "sf32", "gbd "};
            char[] trc = s[command - 16].toCharArray();
            for (int i = 0; i < 4; ++i) {
                this.decodedICC[resultPos++] = (byte)trc[i];
            }
            resultPos += 4;
        }
        return this.decodedICC;
    }

    public int getLevel() {
        return this.level;
    }

    static class ExtraChannel {
        final int type;
        final HeaderBitDepth bitDepth;
        final int dimShift;
        final boolean alphaAssociated;

        ExtraChannel(BitXL reader) throws IOException {
            boolean d_alpha = reader.bool();
            if (!d_alpha) {
                this.type = reader.readEnum();
                this.bitDepth = new HeaderBitDepth(reader);
                this.dimShift = reader.u32(0, 0, 3, 0, 4, 0, 1, 3);
                int nameLen = reader.u32(0, 0, 0, 4, 16, 5, 48, 10);
                for (int i = 0; i < nameLen; ++i) {
                    reader.u(8);
                }
                this.alphaAssociated = this.type == 0 && reader.bool();
            } else {
                this.type = 0;
                this.bitDepth = new HeaderBitDepth();
                this.dimShift = 0;
                this.alphaAssociated = false;
            }
            if (this.type == 2) {
                reader.f16();
                reader.f16();
                reader.f16();
                reader.f16();
            }
            if (this.type == 5) {
                reader.u32(1, 0, 0, 2, 3, 4, 19, 8);
            }
        }
    }
}

