/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.DCTInfo;
import com.idrsolutions.image.jpegxl.data.Frame;
import com.idrsolutions.image.jpegxl.data.FunctionalHelper;
import com.idrsolutions.image.jpegxl.data.HelperXL;
import com.idrsolutions.image.jpegxl.data.ITX;
import com.idrsolutions.image.jpegxl.data.IntXL;
import com.idrsolutions.image.jpegxl.data.MathXL;
import com.idrsolutions.image.jpegxl.data.ModularChannel;
import com.idrsolutions.image.jpegxl.data.ModularInfo;
import com.idrsolutions.image.jpegxl.data.ModularStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.stream.Stream;

class HFGlobal {
    private static final DCTInfo[] defaultParams = new DCTInfo[17];
    private static final float[][][][] defaultWeights = new float[17][3][][];
    private static final float[] afvFreqs = new float[]{0.0f, 0.0f, 0.8517779f, 5.3777843f, 0.0f, 0.0f, 4.734748f, 5.4492455f, 1.659827f, 4.0f, 7.275749f, 10.423227f, 2.6629324f, 7.6306577f, 8.962389f, 12.971662f};
    final DCTInfo[] params;
    final float[][][][] weights;
    final int numHfPresets;

    private static float[] prepend(float a, float ... values) {
        float[] arr = new float[values.length + 1];
        arr[0] = a;
        System.arraycopy(values, 0, arr, 1, values.length);
        return arr;
    }

    private static float[][] readDCTParams(BitXL reader) throws IOException {
        int numParams = 1 + reader.u(4);
        float[][] vals = new float[3][numParams];
        for (int c = 0; c < 3; ++c) {
            for (int i = 0; i < numParams; ++i) {
                vals[c][i] = reader.f16();
            }
            float[] fArray = vals[c];
            fArray[0] = (float)((double)fArray[0] * 64.0);
        }
        return vals;
    }

    private static float interpolate(float pos, float max, float[] bands) {
        if (bands.length == 1) {
            return bands[0];
        }
        float scaledPos = pos * (float)(bands.length - 1) / max;
        int scaledIndex = (int)scaledPos;
        float fracIndex = scaledPos - (float)scaledIndex;
        float a = bands[scaledIndex];
        float b = bands[scaledIndex + 1];
        return a * (float)Math.pow(b / a, fracIndex);
    }

    private static float quantMult(float v) {
        return v >= 0.0f ? 1.0f + v : 1.0f / (1.0f - v);
    }

    private static float[][] getDCTQuantWeights(int width, int height, float[] params) {
        float[] bands = new float[params.length];
        bands[0] = params[0];
        for (int i = 1; i < bands.length; ++i) {
            bands[i] = bands[i - 1] * HFGlobal.quantMult(params[i]);
        }
        float[][] weights = new float[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float dx = (float)x / (float)(width - 1);
                float dy = (float)y / (float)(height - 1);
                float dist = (float)Math.sqrt(dx * dx + dy * dy);
                weights[y][x] = HFGlobal.interpolate(dist, MathXL.SQRT_2 + 1.0E-6f, bands);
            }
        }
        return weights;
    }

    private static void setupDefaultParams() {
        HFGlobal.defaultParams[0] = new DCTInfo(new float[][]{{3150.0f, 0.0f, -0.4f, -0.4f, -0.4f, -2.0f}, {560.0f, 0.0f, -0.3f, -0.3f, -0.3f, -0.3f}, {512.0f, -2.0f, -1.0f, 0.0f, -1.0f, -2.0f}}, null, 6);
        HFGlobal.defaultParams[1] = new DCTInfo(null, new float[][]{{280.0f, 3160.0f, 3160.0f}, {60.0f, 864.0f, 864.0f}, {18.0f, 200.0f, 200.0f}}, 1);
        HFGlobal.defaultParams[2] = new DCTInfo(null, new float[][]{{3840.0f, 2560.0f, 1280.0f, 640.0f, 480.0f, 300.0f}, {960.0f, 640.0f, 320.0f, 180.0f, 140.0f, 120.0f}, {640.0f, 320.0f, 128.0f, 64.0f, 32.0f, 16.0f}}, 2);
        float[][] dct4x4params = new float[][]{{2200.0f, 0.0f, 0.0f, 0.0f}, {392.0f, 0.0f, 0.0f, 0.0f}, {112.0f, -0.25f, -0.25f, -0.5f}};
        HFGlobal.defaultParams[3] = new DCTInfo((float[][])dct4x4params, (float[][])new float[][]{{1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}}, dct4x4params, 3);
        HFGlobal.defaultParams[4] = new DCTInfo(new float[][]{{8996.873f, -1.3000778f, -0.4942453f, -0.43909377f, -0.6350102f, -0.9017726f, -1.6162099f}, {3191.4836f, -0.67424583f, -0.80745816f, -0.4492584f, -0.3586544f, -0.3132239f, -0.37615025f}, {1157.504f, -2.0531423f, -1.4f, -0.5068713f, -0.4270873f, -1.4856834f, -4.920914f}}, null, 6);
        HFGlobal.defaultParams[5] = new DCTInfo(new float[][]{{15718.408f, -1.025f, -0.98f, -0.9012f, -0.4f, -0.48819396f, -0.421064f, -0.27f}, {7305.7637f, -0.8041958f, -0.76330364f, -0.5566038f, -0.49785304f, -0.43699592f, -0.40180868f, -0.27321684f}, {3803.5317f, -3.0607336f, -2.041327f, -2.023565f, -0.54953897f, -0.4f, -0.4f, -0.3f}}, null, 6);
        HFGlobal.defaultParams[6] = new DCTInfo(new float[][]{{7240.7734f, -0.7f, -0.7f, -0.2f, -0.2f, -0.2f, -0.5f}, {1448.1547f, -0.5f, -0.5f, -0.5f, -0.2f, -0.2f, -0.2f}, {506.85413f, -1.4f, -0.2f, -0.5f, -0.5f, -1.5f, -3.6f}}, null, 6);
        HFGlobal.defaultParams[7] = new DCTInfo(new float[][]{{16283.249f, -1.7812846f, -1.6309059f, -1.0382179f, -0.85f, -0.7f, -0.9f, -1.2360638f}, {5089.1577f, -0.3200494f, -0.3536285f, -0.3034f, -0.61f, -0.5f, -0.5f, -0.6f}, {3397.7761f, -0.32132736f, -0.3450762f, -0.7034f, -0.9f, -1.0f, -1.0f, -1.1754606f}}, null, 6);
        HFGlobal.defaultParams[8] = new DCTInfo(new float[][]{{13844.971f, -0.971138f, -0.658f, -0.42026f, -0.22712f, -0.2206f, -0.226f, -0.6f}, {4798.964f, -0.6112531f, -0.8377079f, -0.7901486f, -0.26927274f, -0.38272768f, -0.22924222f, -0.20719099f}, {1807.2369f, -1.2f, -1.2f, -0.7f, -0.7f, -0.7f, -0.4f, -0.5f}}, null, 6);
        float[][] dct4x8Params = new float[][]{{2198.0505f, -0.96269625f, -0.7619425f, -0.65511405f}, {764.36554f, -0.926302f, -0.967523f, -0.2784529f}, {527.10754f, -1.4594386f, -1.4500821f, -1.5843723f}};
        HFGlobal.defaultParams[9] = new DCTInfo(dct4x8Params, new float[][]{{1.0f}, {1.0f}, {1.0f}}, 4);
        HFGlobal.defaultParams[10] = new DCTInfo((float[][])dct4x8Params, (float[][])new float[][]{{3072.0f, 3072.0f, 256.0f, 256.0f, 256.0f, 414.0f, 0.0f, 0.0f, 0.0f}, {1024.0f, 1024.0f, 50.0f, 50.0f, 50.0f, 58.0f, 0.0f, 0.0f, 0.0f}, {384.0f, 384.0f, 12.0f, 12.0f, 12.0f, 22.0f, -0.25f, -0.25f, -0.25f}}, dct4x4params, 5);
        float[] seqA = new float[]{-1.025f, -0.78f, -0.65012f, -0.19041574f, -0.20819396f, -0.421064f, -0.32733846f};
        float[] seqB = new float[]{-0.30419582f, -0.36330363f, -0.3566038f, -0.34430745f, -0.33699593f, -0.30180866f, -0.27321684f};
        float[] seqC = new float[]{-1.2f, -1.2f, -0.8f, -0.7f, -0.7f, -0.4f, -0.5f};
        HFGlobal.defaultParams[11] = new DCTInfo(new float[][]{HFGlobal.prepend(23966.166f, seqA), HFGlobal.prepend(8380.191f, seqB), HFGlobal.prepend(4493.024f, seqC)}, null, 6);
        HFGlobal.defaultParams[12] = new DCTInfo(new float[][]{HFGlobal.prepend(15358.898f, seqA), HFGlobal.prepend(5597.3604f, seqB), HFGlobal.prepend(2919.9617f, seqC)}, null, 6);
        HFGlobal.defaultParams[13] = new DCTInfo(new float[][]{HFGlobal.prepend(47932.332f, seqA), HFGlobal.prepend(16760.383f, seqB), HFGlobal.prepend(8986.048f, seqC)}, null, 6);
        HFGlobal.defaultParams[14] = new DCTInfo(new float[][]{HFGlobal.prepend(30717.797f, seqA), HFGlobal.prepend(11194.721f, seqB), HFGlobal.prepend(5839.9233f, seqC)}, null, 6);
        HFGlobal.defaultParams[15] = new DCTInfo(new float[][]{HFGlobal.prepend(95864.664f, seqA), HFGlobal.prepend(33520.766f, seqB), HFGlobal.prepend(17972.096f, seqC)}, null, 6);
        HFGlobal.defaultParams[16] = new DCTInfo(new float[][]{HFGlobal.prepend(61435.594f, seqA), HFGlobal.prepend(24209.441f, seqB), HFGlobal.prepend(12979.847f, seqC)}, null, 6);
    }

    private static void readDefaultWeights() throws IOException {
        int nRead;
        InputStream fis = HFGlobal.class.getResourceAsStream("/com/idrsolutions/image/res/XLW.B64");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = fis.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        data = buffer.toByteArray();
        data = Base64.getDecoder().decode(data);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        for (int i : HelperXL.range(17)) {
            ITX tt = Stream.of(ITX.values()).filter(t -> t.idx == i && !t.isVertical()).findFirst().get();
            for (int c = 0; c < 3; ++c) {
                HFGlobal.defaultWeights[i][c] = new float[tt.mmH][tt.mmW];
                for (int y = 0; y < tt.mmH; ++y) {
                    for (int x = 0; x < tt.mmW; ++x) {
                        HFGlobal.defaultWeights[i][c][y][x] = in.readFloat();
                    }
                }
            }
        }
        in.close();
    }

    HFGlobal(BitXL reader, Frame frame) throws IOException {
        int i;
        boolean quantAllDefault = reader.bool();
        if (quantAllDefault) {
            this.params = defaultParams;
        } else {
            this.params = new DCTInfo[17];
            for (i = 0; i < 17; ++i) {
                this.setupDCTParam(reader, frame, i);
            }
        }
        this.weights = new float[17][3][][];
        for (i = 0; i < 17; ++i) {
            this.generateWeights(i);
        }
        this.numHfPresets = 1 + reader.u(MathXL.ceilLog1p(frame.getNumGroups() - 1));
    }

    private void setupDCTParam(BitXL reader, Frame frame, int index) throws IOException {
        int encodingMode = reader.u(3);
        switch (encodingMode) {
            case 0: {
                this.params[index] = defaultParams[index];
                break;
            }
            case 1: {
                float[][] m = new float[3][3];
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 3; ++x) {
                        m[y][x] = 64.0f * reader.f16();
                    }
                }
                this.params[index] = new DCTInfo(null, m, encodingMode);
                break;
            }
            case 2: {
                float[][] m = new float[3][6];
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 6; ++x) {
                        m[y][x] = 64.0f * reader.f16();
                    }
                }
                this.params[index] = new DCTInfo(null, m, encodingMode);
                break;
            }
            case 3: {
                float[][] m = new float[3][2];
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 2; ++x) {
                        m[y][x] = 64.0f * reader.f16();
                    }
                }
                this.params[index] = new DCTInfo(HFGlobal.readDCTParams(reader), m, encodingMode);
                break;
            }
            case 6: {
                this.params[index] = new DCTInfo(HFGlobal.readDCTParams(reader), null, encodingMode);
                break;
            }
            case 7: {
                float den = reader.f16();
                ITX tt = Stream.of(ITX.values()).filter(t -> t.idx == index && !t.isVertical()).findFirst().get();
                ModularInfo[] info = new ModularInfo[]{new ModularChannel(tt.mmW, tt.mmH, 0, 0), new ModularChannel(tt.mmW, tt.mmH, 0, 0), new ModularChannel(tt.mmW, tt.mmH, 0, 0)};
                ModularStream stream = new ModularStream(reader, frame, 1 + 3 * frame.getNumLFGroups() + index, info);
                stream.decodeChannels(reader);
                float[][] m = new float[3][tt.mmW * tt.mmH];
                int[][][] b = stream.getDecodedBuffer();
                for (int c = 0; c < 3; ++c) {
                    for (int y = 0; y < b[c].length; ++y) {
                        for (int x = 0; x < b[c][y].length; ++x) {
                            m[c][y * tt.mmW + x] = b[c][y][x];
                        }
                    }
                }
                this.params[index] = new DCTInfo(null, m, encodingMode, den);
                break;
            }
            case 5: {
                float[][] m = new float[3][9];
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 9; ++x) {
                        m[y][x] = reader.f16();
                        if (x >= 6) continue;
                        float[] fArray = m[y];
                        int n = x;
                        fArray[n] = fArray[n] * 64.0f;
                    }
                }
                float[][] d = HFGlobal.readDCTParams(reader);
                float[][] f = HFGlobal.readDCTParams(reader);
                this.params[index] = new DCTInfo(d, m, f, encodingMode);
            }
        }
    }

    private float[][] getAFVTransformWeights(int index, int c) {
        int px;
        int py;
        float[][] weights4x8 = HFGlobal.getDCTQuantWeights(8, 4, this.params[index].dctParam[c]);
        float[][] weights4x4 = HFGlobal.getDCTQuantWeights(4, 4, this.params[index].params4x4[c]);
        float low = 0.8517779f;
        float high = 12.971662f;
        float[] bands = new float[4];
        bands[0] = this.params[index].param[c][5];
        for (int i = 1; i < 4; ++i) {
            bands[i] = bands[i - 1] * HFGlobal.quantMult(this.params[index].param[c][i + 5]);
        }
        float[][] weight = new float[8][8];
        weight[0][0] = 1.0f;
        weight[1][0] = this.params[index].param[c][0];
        weight[0][1] = this.params[index].param[c][1];
        weight[2][0] = this.params[index].param[c][2];
        weight[0][2] = this.params[index].param[c][3];
        weight[2][2] = this.params[index].param[c][4];
        for (py = 0; py < 4; ++py) {
            for (px = 0; px < 4; ++px) {
                if (px < 2 && py < 2) continue;
                weight[2 * py][2 * px] = HFGlobal.interpolate(afvFreqs[py * 4 + px] - 0.8517779f, 12.1198845f, bands);
            }
        }
        for (py = 0; py < 4; ++py) {
            for (px = 0; px < 8; ++px) {
                if (px == 0 && py == 0) continue;
                weight[2 * py + 1][px] = weights4x8[py][px];
            }
        }
        for (py = 0; py < 4; ++py) {
            for (px = 0; px < 4; ++px) {
                if (px == 0 && py == 0) continue;
                weight[2 * py][2 * px + 1] = weights4x4[py][px];
            }
        }
        return weight;
    }

    private void generateWeights(int index) {
        int c;
        ITX tt = Stream.of(ITX.values()).filter(t -> t.idx == index && !t.isVertical()).findFirst().get();
        if (this.params[index] == defaultParams[index]) {
            System.arraycopy(defaultWeights[index], 0, this.weights[index], 0, 3);
            return;
        }
        block9: for (c = 0; c < 3; ++c) {
            switch (this.params[index].mode) {
                case 6: {
                    this.weights[index][c] = HFGlobal.getDCTQuantWeights(tt.mmW, tt.mmH, this.params[index].dctParam[c]);
                    continue block9;
                }
                case 3: {
                    int px;
                    int py;
                    this.weights[index][c] = new float[8][8];
                    float[][] w = HFGlobal.getDCTQuantWeights(4, 4, this.params[index].dctParam[c]);
                    for (py = 0; py < 8; ++py) {
                        for (px = 0; px < 8; ++px) {
                            this.weights[index][c][py][px] = w[py / 2][px / 2];
                        }
                    }
                    float[] fArray = this.weights[index][c][1];
                    fArray[0] = fArray[0] / this.params[index].param[c][0];
                    float[] fArray2 = this.weights[index][c][0];
                    fArray2[1] = fArray2[1] / this.params[index].param[c][0];
                    float[] fArray3 = this.weights[index][c][1];
                    fArray3[1] = fArray3[1] / this.params[index].param[c][1];
                    continue block9;
                }
                case 2: {
                    int px;
                    int py;
                    float[][] w = new float[8][8];
                    w[0][0] = 1.0f;
                    float f = this.params[index].param[c][0];
                    w[1][0] = f;
                    w[0][1] = f;
                    w[1][1] = this.params[index].param[c][1];
                    for (py = 0; py < 2; ++py) {
                        for (px = 0; px < 2; ++px) {
                            float f2 = this.params[index].param[c][2];
                            w[px + 2][py] = f2;
                            w[py][px + 2] = f2;
                            w[py + 2][px + 2] = this.params[index].param[c][3];
                        }
                    }
                    for (py = 0; py < 4; ++py) {
                        for (px = 0; px < 4; ++px) {
                            float f3 = this.params[index].param[c][4];
                            w[px + 4][py] = f3;
                            w[py][px + 4] = f3;
                            w[py + 4][px + 4] = this.params[index].param[c][5];
                        }
                    }
                    this.weights[index][c] = w;
                    continue block9;
                }
                case 1: {
                    int y;
                    float[][] w = new float[8][8];
                    for (y = 0; y < 8; ++y) {
                        Arrays.fill(w[y], this.params[index].param[c][0]);
                    }
                    w[1][1] = this.params[index].param[c][2];
                    float f = this.params[index].param[c][1];
                    w[1][0] = f;
                    w[0][1] = f;
                    w[0][0] = 1.0f;
                    this.weights[index][c] = w;
                    continue block9;
                }
                case 4: {
                    int py;
                    this.weights[index][c] = new float[8][8];
                    float[][] w = HFGlobal.getDCTQuantWeights(8, 4, this.params[index].dctParam[c]);
                    for (py = 0; py < 8; ++py) {
                        System.arraycopy(w[py / 2], 0, this.weights[index][c][py], 0, 8);
                    }
                    float[] fArray = this.weights[index][c][1];
                    fArray[0] = fArray[0] / this.params[index].param[c][0];
                    continue block9;
                }
                case 5: {
                    this.weights[index][c] = this.getAFVTransformWeights(index, c);
                    continue block9;
                }
                case 7: {
                    int y;
                    this.weights[index][c] = new float[tt.mmH][tt.mmW];
                    for (y = 0; y < tt.mmH; ++y) {
                        for (int x = 0; x < tt.mmW; ++x) {
                            this.weights[index][c][y][x] = this.params[index].param[c][y * tt.mmW + x] * this.params[index].denominator;
                        }
                    }
                    continue block9;
                }
            }
        }
        if (this.params[index].mode != 7) {
            for (c = 0; c < 3; ++c) {
                for (IntXL p : HelperXL.range2D(IntXL.sizeOf(this.weights[index][c]))) {
                    this.weights[index][c][p.y][p.x] = 1.0f / this.weights[index][c][p.y][p.x];
                }
            }
        }
    }

    static {
        HFGlobal.setupDefaultParams();
        try {
            HFGlobal.readDefaultWeights();
        }
        catch (Exception e) {
            FunctionalHelper.sneakyThrow(e);
        }
    }
}

