/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Entropy;
import com.idrsolutions.image.jpegxl.data.Frame;
import com.idrsolutions.image.jpegxl.data.HFBlock;
import com.idrsolutions.image.jpegxl.data.HFPass;
import com.idrsolutions.image.jpegxl.data.ITX;
import com.idrsolutions.image.jpegxl.data.IntXL;
import com.idrsolutions.image.jpegxl.data.Inverse;
import com.idrsolutions.image.jpegxl.data.LFChannel;
import com.idrsolutions.image.jpegxl.data.LFGroup;
import com.idrsolutions.image.jpegxl.data.MathXL;
import com.idrsolutions.image.jpegxl.data.VBlock;
import java.io.IOException;
import java.util.Arrays;

class HFCoefficients {
    private static final int[] FREQUENCIES = new int[]{-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27, 28, 28, 28, 28, 29, 29, 29, 29, 30, 30, 30, 30};
    private static final int[] NONZEROS = new int[]{-1, 0, 31, 62, 62, 93, 93, 93, 93, 123, 123, 123, 123, 152, 152, 152, 152, 152, 152, 152, 152, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206};
    final int hfPreset;
    private final HFBlock hfctx;
    final LFGroup lfg;
    final int groupID;
    private final int[][][] nonZeroes;
    final float[][][] dequantHFCoeff;
    final int[][][] quantizedCoeffs;
    final Entropy entropy;
    final Frame frame;
    final VBlock[] varblocks;

    HFCoefficients(BitXL reader, Frame frame, int pass, int group) throws IOException {
        this.hfPreset = reader.u(MathXL.ceilLog1p(frame.getHFGlobal().numHfPresets - 1));
        this.groupID = group;
        this.frame = frame;
        this.hfctx = frame.getLFGlobal().hfBlockCtx;
        this.lfg = frame.getLFGroupForGroup(group);
        int offset = 495 * this.hfctx.numClusters * this.hfPreset;
        HFPass hfPass = frame.getHFPass(pass);
        IntXL groupSize = frame.groupSize(group);
        IntXL groupBlockSize = groupSize.toRight(3);
        this.nonZeroes = new int[3][groupBlockSize.y][groupBlockSize.x];
        IntXL[] shift = frame.getFrameHeader().jpegUpsampling;
        this.entropy = new Entropy(hfPass.contextStream);
        this.quantizedCoeffs = new int[3][][];
        this.dequantHFCoeff = new float[3][][];
        for (int c = 0; c < 3; ++c) {
            IntXL s = groupSize.toRight(shift[c]);
            this.quantizedCoeffs[c] = new int[s.y][s.x];
            this.dequantHFCoeff[c] = new float[s.y][s.x];
        }
        this.varblocks = new VBlock[this.lfg.hfMetadata.blockList.length];
        for (int i = 0; i < this.lfg.hfMetadata.blockList.length; ++i) {
            VBlock varblock = this.lfg.hfMetadata.getVBlock(i);
            if (varblock.groupID != this.groupID) continue;
            this.varblocks[i] = varblock;
            ITX tt = varblock.transformType();
            boolean flip = tt.flip();
            int hfMult = varblock.hfMult();
            int lfIndex = this.lfg.lfCoeff.lfIndex[varblock.blockPosInLFGroup.y][varblock.blockPosInLFGroup.x];
            IntXL sizeInBlocks = varblock.sizeInBlocks();
            int numBlocks = sizeInBlocks.x * sizeInBlocks.y;
            block2: for (int c : Frame.cMap) {
                IntXL shiftC = shift[c];
                if (!varblock.isCorner(shiftC)) continue;
                IntXL shiftedBlockPos = varblock.blockPosInGroup.toRight(shiftC);
                IntXL ppg = shiftedBlockPos.toLeft(3);
                int predicted = this.getPredictedNonZeroes(c, shiftedBlockPos);
                int blockCtx = this.getBlockContext(c, tt.orderID, hfMult, lfIndex);
                int nonZeroCtx = offset + this.getNonZeroContext(predicted, blockCtx);
                int nonZero = this.entropy.readSymbol(reader, nonZeroCtx);
                int[][] nz = this.nonZeroes[c];
                for (int iy = 0; iy < sizeInBlocks.y; ++iy) {
                    for (int ix = 0; ix < sizeInBlocks.x; ++ix) {
                        nz[shiftedBlockPos.y + iy][shiftedBlockPos.x + ix] = (nonZero + numBlocks - 1) / numBlocks;
                    }
                }
                if (nonZero <= 0) continue;
                int size = hfPass.order[tt.orderID][c].length;
                int[] ucoeff = new int[size - numBlocks];
                int histCtx = offset + 458 * blockCtx + 37 * this.hfctx.numClusters;
                for (int k = 0; k < ucoeff.length; ++k) {
                    int prev = k == 0 ? (nonZero > size / 16 ? 0 : 1) : (ucoeff[k - 1] != 0 ? 1 : 0);
                    int ctx = histCtx + HFCoefficients.getCoeffContext(k + numBlocks, nonZero, numBlocks, prev);
                    ucoeff[k] = this.entropy.readSymbol(reader, ctx);
                    IntXL pos = hfPass.order[tt.orderID][c][k + numBlocks];
                    int posX = (flip ? pos.y : pos.x) + ppg.x;
                    int posY = (flip ? pos.x : pos.y) + ppg.y;
                    this.quantizedCoeffs[c][posY][posX] = MathXL.unpackSigned(ucoeff[k]);
                    if (ucoeff[k] != 0 && --nonZero == 0) continue block2;
                }
            }
        }
    }

    void bakeDequantizedCoeffs() {
        this.dequantizeHFCoefficients();
        IntXL[] shift = this.frame.getFrameHeader().jpegUpsampling;
        if (!Arrays.stream(shift).allMatch(x -> IntXL.ZERO.equals(x))) {
            return;
        }
        LFChannel lfc = this.frame.getLFGlobal().lfChanCorr;
        int[][] xFactorHF = this.lfg.hfMetadata.hfStreamBuffer[0];
        int[][] bFactorHF = this.lfg.hfMetadata.hfStreamBuffer[1];
        float[][] xFactors = new float[xFactorHF.length][xFactorHF[0].length];
        float[][] bFactors = new float[bFactorHF.length][bFactorHF[0].length];
        for (VBlock varblock : this.varblocks) {
            if (varblock == null) continue;
            IntXL sizeInPixels = varblock.sizeInPixels();
            for (int iy = 0; iy < sizeInPixels.y; ++iy) {
                int y = varblock.pixelPosInLFGroup.y + iy;
                int fy = y >> 6;
                boolean by = fy << 6 == y;
                float[] xF = xFactors[fy];
                float[] bF = bFactors[fy];
                int[] hfX = xFactorHF[fy];
                int[] hfB = bFactorHF[fy];
                for (int ix = 0; ix < sizeInPixels.x; ++ix) {
                    float kB;
                    float kX;
                    int x2 = varblock.pixelPosInLFGroup.x + ix;
                    int fx = x2 >> 6;
                    if (by && fx << 6 == x2) {
                        kX = lfc.baseX + (float)hfX[fx] / (float)lfc.factor;
                        kB = lfc.baseB + (float)hfB[fx] / (float)lfc.factor;
                        xF[fx] = kX;
                        bF[fx] = kB;
                    } else {
                        kX = xF[fx];
                        kB = bF[fx];
                    }
                    float dequantY = this.dequantHFCoeff[1][varblock.pixelPosInGroup.y + iy][varblock.pixelPosInGroup.x + ix];
                    float[] fArray = this.dequantHFCoeff[0][varblock.pixelPosInGroup.y + iy];
                    int n = varblock.pixelPosInGroup.x + ix;
                    fArray[n] = fArray[n] + kX * dequantY;
                    float[] fArray2 = this.dequantHFCoeff[2][varblock.pixelPosInGroup.y + iy];
                    int n2 = varblock.pixelPosInGroup.x + ix;
                    fArray2[n2] = fArray2[n2] + kB * dequantY;
                }
            }
        }
    }

    void finalizeLLF() {
        float[][][] scratchBlock = new float[2][256][256];
        IntXL[] shift = this.frame.getFrameHeader().jpegUpsampling;
        for (VBlock varblock : this.varblocks) {
            if (varblock == null) continue;
            IntXL size = varblock.sizeInBlocks();
            ITX tt = varblock.transformType();
            for (int c = 0; c < 3; ++c) {
                if (!varblock.isCorner(shift[c])) continue;
                float[][] dqlf = this.lfg.lfCoeff.dequantLFCoeff[c];
                float[][] dq = this.dequantHFCoeff[c];
                IntXL ppg = varblock.pixelPosInGroup.toRight(shift[c]);
                MathXL.forwardDCT2D(dqlf, dq, varblock.blockPosInLFGroup.toRight(shift[c]), ppg, size, scratchBlock[0], scratchBlock[1]);
                for (int y = 0; y < size.y; ++y) {
                    float[] dqy = dq[y + ppg.y];
                    float[] llfy = tt.llfScale[y];
                    for (int x = 0; x < size.x; ++x) {
                        int n = x + ppg.x;
                        dqy[n] = dqy[n] * llfy[x];
                    }
                }
            }
        }
    }

    private int getBlockContext(int c, int orderID, int hfMult, int lfIndex) {
        int idx = (c < 2 ? 1 - c : c) * 13 + orderID;
        idx *= this.hfctx.qfThresholds.length + 1;
        for (int t : this.hfctx.qfThresholds) {
            if (hfMult <= t) continue;
            ++idx;
        }
        return this.hfctx.clusterMap[(idx *= this.hfctx.numLFContexts) + lfIndex];
    }

    private int getNonZeroContext(int predicted, int ctx) {
        if (predicted > 64) {
            predicted = 64;
        }
        if (predicted < 8) {
            return ctx + this.hfctx.numClusters * predicted;
        }
        return ctx + this.hfctx.numClusters * (4 + predicted / 2);
    }

    private static int getCoeffContext(int k, int nonZeroes, int numBlocks, int prev) {
        nonZeroes = (nonZeroes + numBlocks - 1) / numBlocks;
        return (NONZEROS[nonZeroes] + FREQUENCIES[k /= numBlocks]) * 2 + prev;
    }

    private int getPredictedNonZeroes(int c, IntXL pos) {
        if (pos.x == 0 && pos.y == 0) {
            return 32;
        }
        if (pos.x == 0) {
            return this.nonZeroes[c][pos.y - 1][0];
        }
        if (pos.y == 0) {
            return this.nonZeroes[c][0][pos.x - 1];
        }
        return this.nonZeroes[c][pos.y - 1][pos.x] + this.nonZeroes[c][pos.y][pos.x - 1] + 1 >> 1;
    }

    private void dequantizeHFCoefficients() {
        Inverse matrix = this.frame.globalMetadata.getOpsinInverseMatrix();
        float globalScale = 65536.0f / (float)this.frame.getLFGlobal().quantizer.globalScale;
        float[] scaleFactor = new float[]{globalScale * (float)Math.pow(0.8, this.frame.getFrameHeader().xqmScale - 2), globalScale, globalScale * (float)Math.pow(0.8, this.frame.getFrameHeader().bqmScale - 2)};
        float[][][][] weights = this.frame.getHFGlobal().weights;
        IntXL[] shift = this.frame.getFrameHeader().jpegUpsampling;
        for (VBlock varblock : this.varblocks) {
            if (varblock == null) continue;
            ITX tt = varblock.transformType();
            boolean flip = tt.flip();
            float[][][] w2 = weights[tt.idx];
            for (int c = 0; c < 3; ++c) {
                if (!varblock.isCorner(shift[c])) continue;
                float[][] w3 = w2[c];
                float qbc = matrix.quantBias[c];
                float sfc = scaleFactor[c] / (float)varblock.hfMult();
                IntXL ppg = varblock.pixelPosInGroup.toRight(shift[c]);
                for (int y = 0; y < tt.blockH; ++y) {
                    for (int x = 0; x < tt.blockW; ++x) {
                        int coeff = this.quantizedCoeffs[c][ppg.y + y][ppg.x + x];
                        float quant = switch (coeff) {
                            case 0 -> 0.0f;
                            case 1 -> qbc;
                            case -1 -> -qbc;
                            default -> (float)coeff - matrix.quantBiasNumerator / (float)coeff;
                        };
                        int wx = flip ? y : x;
                        int wy = y ^ x ^ wx;
                        this.dequantHFCoeff[c][ppg.y + y][ppg.x + x] = quant * sfc * w3[wy][wx];
                    }
                }
            }
        }
    }
}

