/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Entropy;
import com.idrsolutions.image.jpegxl.data.MathXL;
import java.io.IOException;

class HFBlock {
    final int[] clusterMap;
    final int numClusters;
    final int[][] lfThresholds = new int[3][];
    final int[] qfThresholds;
    final int numLFContexts;

    HFBlock(BitXL reader) throws IOException {
        boolean useDefault = reader.bool();
        if (useDefault) {
            this.clusterMap = new int[]{0, 1, 2, 2, 3, 3, 4, 5, 6, 6, 6, 6, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 14, 14, 14, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 14, 14, 14};
            this.numClusters = 15;
            this.qfThresholds = new int[0];
            this.lfThresholds[2] = new int[0];
            this.lfThresholds[1] = this.lfThresholds[2];
            this.lfThresholds[0] = this.lfThresholds[2];
            this.numLFContexts = 1;
            return;
        }
        int[] nbLFThresh = new int[3];
        int lfCtx = 1;
        for (int i = 0; i < 3; ++i) {
            nbLFThresh[i] = reader.u(4);
            lfCtx *= nbLFThresh[i] + 1;
            this.lfThresholds[i] = new int[nbLFThresh[i]];
            for (int j = 0; j < nbLFThresh[i]; ++j) {
                int t = reader.u32(0, 4, 16, 8, 272, 16, 65808, 32);
                this.lfThresholds[i][j] = MathXL.unpackSigned(t);
            }
        }
        this.numLFContexts = lfCtx;
        int nbQfThresh = reader.u(4);
        this.qfThresholds = new int[nbQfThresh];
        for (int i = 0; i < nbQfThresh; ++i) {
            this.qfThresholds[i] = 1 + reader.u32(0, 2, 4, 3, 12, 5, 44, 8);
        }
        int bSize = 39 * (nbQfThresh + 1);
        for (int i = 0; i < 3; ++i) {
            bSize *= nbLFThresh[i] + 1;
        }
        this.clusterMap = new int[bSize];
        this.numClusters = Entropy.readClusters(reader, this.clusterMap);
    }
}

