/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.BlockData;
import com.idrsolutions.image.jpeg2000.data.CodeBlock;
import com.idrsolutions.image.jpeg2000.data.IncQuadTree;
import com.idrsolutions.image.jpeg2000.data.Packet;
import com.idrsolutions.image.jpeg2000.data.PacketItem;
import com.idrsolutions.image.jpeg2000.data.Precinct;
import com.idrsolutions.image.jpeg2000.data.Progression;
import com.idrsolutions.image.jpeg2000.data.QuadTree;
import com.idrsolutions.image.jpeg2000.data.Tile;
import java.util.LinkedList;

public class TileParser {
    private final int offset;
    private final int dataLength;
    private final byte[] data;
    private final Tile tile;
    private int pos;
    private boolean skipNextBit;
    private int bufferSize;
    private int buffer;

    public TileParser(byte[] data, int offset, int length, Tile tile) {
        this.data = data;
        this.offset = offset;
        this.dataLength = length;
        this.tile = tile;
    }

    private int readBits(int count) {
        while (this.bufferSize < count) {
            int b = this.data[this.offset + this.pos] & 0xFF;
            ++this.pos;
            if (this.skipNextBit) {
                this.buffer = this.buffer << 7 | b;
                this.bufferSize += 7;
                this.skipNextBit = false;
            } else {
                this.buffer = this.buffer << 8 | b;
                this.bufferSize += 8;
            }
            if (b != 255) continue;
            this.skipNextBit = true;
        }
        this.bufferSize -= count;
        return this.buffer >>> this.bufferSize & (1 << count) - 1;
    }

    private boolean skipPacketMarker(int value) {
        if ((this.data[this.offset + this.pos - 1] & 0xFF) == 255 && (this.data[this.offset + this.pos] & 0xFF) == value) {
            ++this.pos;
            return true;
        }
        if ((this.data[this.offset + this.pos] & 0xFF) == 255 && (this.data[this.offset + this.pos + 1] & 0xFF) == value) {
            this.pos += 2;
            return true;
        }
        return false;
    }

    private void doPadding() {
        this.bufferSize = 0;
        if (this.skipNextBit) {
            ++this.pos;
            this.skipNextBit = false;
        }
    }

    private int readCodingpasses() {
        if (this.readBits(1) == 0) {
            return 1;
        }
        if (this.readBits(1) == 0) {
            return 2;
        }
        int value = this.readBits(2);
        if (value < 3) {
            return value + 3;
        }
        value = this.readBits(5);
        if (value < 31) {
            return value + 6;
        }
        value = this.readBits(7);
        return value + 37;
    }

    public void parseTile() {
        boolean sopMarkerUsed = this.tile.cod.hasSOP;
        boolean ephMarkerUsed = this.tile.cod.hasEPH;
        Progression packetsIterator = this.tile.progress;
        while (this.pos < this.dataLength) {
            this.doPadding();
            if (sopMarkerUsed && this.skipPacketMarker(145)) {
                this.pos += 4;
            }
            Packet packet = packetsIterator.getNextPacket();
            if (this.readBits(1) == 0) continue;
            int layerNumber = packet.layerNumber;
            LinkedList<PacketItem> queue = new LinkedList<PacketItem>();
            for (CodeBlock codeBlock : packet.codeBlocks) {
                boolean firstTimeInclusion;
                boolean codeblockIncluded;
                int codeblockRow;
                int codeblockColumn;
                Precinct precinct;
                block13: {
                    precinct = codeBlock.precinct;
                    codeblockColumn = codeBlock.x - precinct.cbx0;
                    codeblockRow = codeBlock.y - precinct.cby0;
                    codeblockIncluded = false;
                    firstTimeInclusion = false;
                    if (codeBlock.included != null) {
                        codeblockIncluded = this.readBits(1) != 0;
                    } else {
                        IncQuadTree incQuadTree;
                        if (precinct.incQuadTree != null) {
                            incQuadTree = precinct.incQuadTree;
                        } else {
                            int width = precinct.cbx1 - precinct.cbx0 + 1;
                            int height = precinct.cby1 - precinct.cby0 + 1;
                            incQuadTree = new IncQuadTree(width, height, layerNumber);
                            QuadTree zeroBitTree = new QuadTree(width, height);
                            precinct.incQuadTree = incQuadTree;
                            precinct.zeroBitTree = zeroBitTree;
                        }
                        if (incQuadTree.reset(codeblockColumn, codeblockRow, layerNumber)) {
                            while (this.readBits(1) != 0) {
                                if (incQuadTree.nextNode()) continue;
                                codeBlock.included = true;
                                codeblockIncluded = true;
                                firstTimeInclusion = true;
                                break block13;
                            }
                            incQuadTree.incrementValue(layerNumber);
                        }
                    }
                }
                if (!codeblockIncluded) continue;
                if (firstTimeInclusion) {
                    this.handleFirstTImeInclusion(codeBlock, precinct, codeblockColumn, codeblockRow);
                }
                int codingpasses = this.readCodingpasses();
                while (this.readBits(1) != 0) {
                    ++codeBlock.Lblock;
                }
                int codingpassesLog2 = TileParser.log2(codingpasses);
                int bits = (codingpasses < 1 << codingpassesLog2 ? codingpassesLog2 - 1 : codingpassesLog2) + codeBlock.Lblock;
                int codedDataLength = this.readBits(bits);
                PacketItem pi = new PacketItem();
                pi.codeBlock = codeBlock;
                pi.nCodingPass = (byte)codingpasses;
                pi.dataLength = codedDataLength;
                queue.add(pi);
            }
            this.doPadding();
            if (ephMarkerUsed) {
                this.skipPacketMarker(146);
            }
            while (!queue.isEmpty()) {
                PacketItem packetItem = (PacketItem)queue.poll();
                if (packetItem == null) continue;
                this.handlePacketItem(packetItem);
            }
        }
    }

    private void handlePacketItem(PacketItem packetItem) {
        CodeBlock codeBlock = packetItem.codeBlock;
        BlockData bd = new BlockData();
        bd.data = this.data;
        bd.start = this.offset + this.pos;
        bd.end = this.offset + this.pos + packetItem.dataLength;
        bd.nCodingPass = packetItem.nCodingPass;
        codeBlock.dataList.add(bd);
        this.pos += packetItem.dataLength;
    }

    private void handleFirstTImeInclusion(CodeBlock codeBlock, Precinct precinct, int codeblockColumn, int codeblockRow) {
        QuadTree zeroBitTree = precinct.zeroBitTree;
        zeroBitTree.reset(codeblockColumn, codeblockRow);
        while (true) {
            if (this.readBits(1) != 0) {
                if (zeroBitTree.nextNode()) continue;
                break;
            }
            zeroBitTree.incrementValue();
        }
        codeBlock.zeroBitPlanes = zeroBitTree.getValue();
    }

    private static int log2(int x) {
        int n = 1;
        int i = 0;
        while (x > n) {
            n <<= 1;
            ++i;
        }
        return i;
    }
}

