/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.CodeBlock;
import com.idrsolutions.image.jpeg2000.data.Info;
import com.idrsolutions.image.jpeg2000.data.Packet;
import com.idrsolutions.image.jpeg2000.data.Progression;
import com.idrsolutions.image.jpeg2000.data.SIZ;
import com.idrsolutions.image.jpeg2000.data.Tile;
import com.idrsolutions.image.jpeg2000.data.TileBand;
import com.idrsolutions.image.jpeg2000.data.TileComponent;
import com.idrsolutions.image.jpeg2000.data.TileResolution;
import java.awt.Rectangle;

public class CPRL
implements Progression {
    private final int layersCount;
    private final int componentsCount;
    private final Tile tile;
    private final ImagePrecinctInfo precinctsSizes;
    private int c;
    private int r;
    private int l;
    private int px;
    private int py;

    public CPRL(Info info, int tileIndex) {
        SIZ siz = info.siz;
        this.tile = info.tilesMap.get(tileIndex);
        this.layersCount = this.tile.cod.nLayers;
        this.componentsCount = siz.Csiz;
        this.precinctsSizes = CPRL.findImagePrecinctInfo(this.tile);
    }

    @Override
    public Packet getNextPacket() {
        while (this.c < this.componentsCount) {
            TileComponent component = this.tile.components.get(this.c);
            SizeComponentInfo precinctsIterationSizes = this.precinctsSizes.components[this.c];
            int decompositionLevelsCount = this.tile.cod.nDecompLevel;
            while (this.py < precinctsIterationSizes.maxNumHigh) {
                while (this.px < precinctsIterationSizes.maxNumWide) {
                    while (this.r <= decompositionLevelsCount) {
                        TileResolution resolution = component.resolutions.get(this.r);
                        Rectangle sizeInImageScale = precinctsIterationSizes.resolutions[this.r];
                        boolean isP = CPRL.hasPrecinctIndex(this.px, this.py, sizeInImageScale, precinctsIterationSizes);
                        if (!isP) {
                            ++this.r;
                            continue;
                        }
                        int k = CPRL.getPrecinctIndex(this.px, this.py, sizeInImageScale, precinctsIterationSizes, resolution);
                        if (this.l < this.layersCount) {
                            Packet packet = this.createPacket(resolution, k, this.l);
                            ++this.l;
                            return packet;
                        }
                        this.l = 0;
                        ++this.r;
                    }
                    this.r = 0;
                    ++this.px;
                }
                this.px = 0;
                ++this.py;
            }
            this.py = 0;
            ++this.c;
        }
        return null;
    }

    @Override
    public Packet createPacket(TileResolution resolution, int precintNumber, int layerNumber) {
        Packet packet = new Packet();
        packet.layerNumber = layerNumber;
        for (TileBand subband : resolution.tileBands) {
            for (CodeBlock codeBlock : subband.codeBlocks) {
                if (codeBlock.precinctNumber != precintNumber) continue;
                packet.codeBlocks.add(codeBlock);
            }
        }
        return packet;
    }

    private static boolean hasPrecinctIndex(int px, int py, Rectangle sizeInImageScale, SizeComponentInfo precinctIterationSizes) {
        int posX = px * precinctIterationSizes.minWidth;
        int posY = py * precinctIterationSizes.minHeight;
        return posX % sizeInImageScale.width == 0 && posY % sizeInImageScale.height == 0;
    }

    private static int getPrecinctIndex(int px, int py, Rectangle sizeInImageScale, SizeComponentInfo precinctIterationSizes, TileResolution resolution) {
        int posX = px * precinctIterationSizes.minWidth;
        int posY = py * precinctIterationSizes.minHeight;
        int startPrecinctRowIndex = posY / sizeInImageScale.width * resolution.precinctInfo.numPrecinctsWide;
        return posX / sizeInImageScale.height + startPrecinctRowIndex;
    }

    private static ImagePrecinctInfo findImagePrecinctInfo(Tile tile) {
        int componentsCount = tile.components.size();
        int mw = Integer.MAX_VALUE;
        int mh = Integer.MAX_VALUE;
        int mnw = 0;
        int mnh = 0;
        SizeComponentInfo[] sizePerComponent = new SizeComponentInfo[componentsCount];
        for (int c = 0; c < componentsCount; ++c) {
            TileComponent component = tile.components.get(c);
            int decompositionLevelsCount = tile.cod.nDecompLevel;
            Rectangle[] sizePerResolution = new Rectangle[decompositionLevelsCount + 1];
            int minWidthCurrentComponent = Integer.MAX_VALUE;
            int minHeightCurrentComponent = Integer.MAX_VALUE;
            int maxNumWideCurrentComponent = 0;
            int maxNumHighCurrentComponent = 0;
            int scale = 1;
            for (int r = decompositionLevelsCount; r >= 0; --r) {
                TileResolution tr = component.resolutions.get(r);
                int widthCurrentResolution = scale * tr.precinctInfo.precinctWidth;
                int heightCurrentResolution = scale * tr.precinctInfo.precinctHeight;
                minWidthCurrentComponent = Math.min(minWidthCurrentComponent, widthCurrentResolution);
                minHeightCurrentComponent = Math.min(minHeightCurrentComponent, heightCurrentResolution);
                maxNumWideCurrentComponent = Math.max(maxNumWideCurrentComponent, tr.precinctInfo.numPrecinctsWide);
                maxNumHighCurrentComponent = Math.max(maxNumHighCurrentComponent, tr.precinctInfo.numPrecinctsHigh);
                sizePerResolution[r] = new Rectangle(widthCurrentResolution, heightCurrentResolution);
                scale <<= 1;
            }
            mw = Math.min(mw, minWidthCurrentComponent);
            mh = Math.min(mh, minHeightCurrentComponent);
            mnw = Math.max(mnw, maxNumWideCurrentComponent);
            mnh = Math.max(mnh, maxNumHighCurrentComponent);
            SizeComponentInfo temp = new SizeComponentInfo();
            temp.resolutions = sizePerResolution;
            temp.minWidth = minWidthCurrentComponent;
            temp.minHeight = minHeightCurrentComponent;
            temp.maxNumHigh = maxNumHighCurrentComponent;
            temp.maxNumWide = maxNumWideCurrentComponent;
            sizePerComponent[c] = temp;
        }
        ImagePrecinctInfo ip = new ImagePrecinctInfo();
        ip.components = sizePerComponent;
        return ip;
    }

    private static final class ImagePrecinctInfo {
        SizeComponentInfo[] components;

        private ImagePrecinctInfo() {
        }
    }

    private static final class SizeComponentInfo {
        Rectangle[] resolutions;
        int minWidth;
        int minHeight;
        int maxNumWide;
        int maxNumHigh;

        private SizeComponentInfo() {
        }
    }
}

