/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.heic.common.HStruct;
import com.idrsolutions.image.heic.options.HeicMetadata;
import com.idrsolutions.image.metadata.Exif;
import com.idrsolutions.image.metadata.Metadata;
import com.idrsolutions.image.utility.DataByteBig;
import com.idrsolutions.image.utility.DataFileBig;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;

public class HeicDecoder
extends JDeliImage
implements Decoder {
    @Override
    public BufferedImage read(byte[] data) throws Exception {
        DataByteBig reader = new DataByteBig(data);
        BufferedImage image = HStruct.read(reader);
        reader.close();
        return HeicDecoder.optimiseImage(image);
    }

    @Override
    public BufferedImage read(File file) throws Exception {
        DataFileBig reader = new DataFileBig(file);
        BufferedImage image = HStruct.read(reader);
        reader.close();
        return HeicDecoder.optimiseImage(image);
    }

    @Override
    public BufferedImage readEmbeddedThumbnail(File file) throws Exception {
        DataFileBig reader = new DataFileBig(file);
        BufferedImage image = HStruct.readThumbnail(reader);
        reader.close();
        return image;
    }

    @Override
    public BufferedImage readEmbeddedThumbnail(byte[] data) throws Exception {
        DataByteBig reader = new DataByteBig(data);
        BufferedImage image = HStruct.readThumbnail(reader);
        return image;
    }

    public Exif readExif(File file) throws Exception {
        DataFileBig reader = new DataFileBig(file);
        Exif exif = HStruct.readExif(reader);
        reader.close();
        return exif;
    }

    public Exif readExif(byte[] data) throws Exception {
        DataByteBig reader = new DataByteBig(data);
        Exif exif = HStruct.readExif(reader);
        return exif;
    }

    @Override
    public Rectangle readDimension(File file) throws Exception {
        DataFileBig reader = new DataFileBig(file);
        Rectangle rect = HStruct.readDimension(reader);
        reader.close();
        return rect;
    }

    @Override
    public Rectangle readDimension(byte[] data) throws Exception {
        DataByteBig reader = new DataByteBig(data);
        Rectangle rect = HStruct.readDimension(reader);
        reader.close();
        return rect;
    }

    @Override
    public void readImageSpecificMetaData(File file, Metadata metadata) throws Exception {
        Exif ifd = this.readExif(file);
        ((HeicMetadata)metadata).setExif(ifd);
    }

    @Override
    public void readImageSpecificMetaData(byte[] bytes, Metadata metadata) throws Exception {
        Exif ifd = this.readExif(bytes);
        ((HeicMetadata)metadata).setExif(ifd);
    }
}

