/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.filter;

import com.idrsolutions.image.filter.Filter;
import com.idrsolutions.image.filter.FilterOptions;
import org.jpedal.io.filter.CCITT;

public class CCITTFilterOptions
implements FilterOptions {
    private int columns = 1;
    private int k;
    private final int width;
    private final int height;
    private final int fillOrder;
    private boolean blackIs1;
    private boolean encodedByteAlign;
    private boolean EOL;
    private FilterOptions.FilterMode mode;

    public CCITTFilterOptions(int width, int height, int columns, int k, boolean blackIs1, boolean encodedByteAlign, boolean endOfLine, int fillOrder) {
        this.width = columns == -1 ? width : columns;
        this.height = height;
        this.columns = columns;
        this.k = k;
        this.blackIs1 = blackIs1;
        this.encodedByteAlign = encodedByteAlign;
        this.EOL = endOfLine;
        this.mode = FilterOptions.FilterMode.DECOMPRESS;
        this.fillOrder = fillOrder;
    }

    public CCITTFilterOptions(int width, int height) {
        this.width = width;
        this.height = height;
        this.mode = FilterOptions.FilterMode.DECOMPRESS;
        this.fillOrder = 1;
    }

    @Override
    public FilterOptions.FilterMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(FilterOptions.FilterMode mode) {
        this.mode = mode;
    }

    @Override
    public Filter getFilter() {
        return new CCITT(this);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isByteAligned() {
        return this.encodedByteAlign;
    }

    public boolean isEOL() {
        return this.EOL;
    }

    public boolean isBlack1() {
        return this.blackIs1;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getEncoding() {
        return this.k;
    }

    public int getFillOrder() {
        return this.fillOrder;
    }
}

