/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.emf;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.emf.data.DC;
import com.idrsolutions.image.emf.data.Design;
import com.idrsolutions.image.emf.data.EmfObject;
import com.idrsolutions.image.emf.data.FM;
import com.idrsolutions.image.emf.data.ImageSpace;
import com.idrsolutions.image.emf.data.Space;
import com.idrsolutions.image.emf.data.SvgSpace;
import com.idrsolutions.image.utility.DataByteLittle;
import com.idrsolutions.image.utility.DataFileLittle;
import com.idrsolutions.image.utility.DataReader;
import com.idrsolutions.image.utility.WriterByteLittle;
import com.idrsolutions.image.utility.WriterFileBig;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;

public class EmfDecoder
extends JDeliImage
implements Decoder {
    private static final int HEADER = 1;
    private static final int POLYBEZIER = 2;
    private static final int POLYGON = 3;
    private static final int POLYLINE = 4;
    private static final int POLYBEZIERTO = 5;
    private static final int POLYLINETO = 6;
    private static final int POLYPOLYLINE = 7;
    private static final int POLYPOLYGON = 8;
    private static final int SETWINDOWEXTEX = 9;
    private static final int SETWINDOWORGEX = 10;
    private static final int SETVIEWPORTEXTEX = 11;
    private static final int SETVIEWPORTORGEX = 12;
    private static final int SETBRUSHORGEX = 13;
    private static final int EOF = 14;
    private static final int SETPIXELV = 15;
    private static final int SETMAPPERFLAGS = 16;
    private static final int SETMAPMODE = 17;
    private static final int SETBKMODE = 18;
    private static final int SETPOLYFILLMODE = 19;
    private static final int SETROP2 = 20;
    private static final int SETSTRETCHBLTMODE = 21;
    private static final int SETTEXTALIGN = 22;
    private static final int SETCOLORADJUSTMENT = 23;
    private static final int SETTEXTCOLOR = 24;
    private static final int SETBKCOLOR = 25;
    private static final int OFFSETCLIPRGN = 26;
    private static final int MOVETOEX = 27;
    private static final int SETMETARGN = 28;
    private static final int EXCLUDECLIPRECT = 29;
    private static final int INTERSECTCLIPRECT = 30;
    private static final int SCALEVIEWPORTEXTEX = 31;
    private static final int SCALEWINDOWEXTEX = 32;
    private static final int SAVEDC = 33;
    private static final int RESTOREDC = 34;
    private static final int SETWORLDTRANSFORM = 35;
    private static final int MODIFYWORLDTRANSFORM = 36;
    private static final int SELECTOBJECT = 37;
    private static final int CREATEPEN = 38;
    private static final int CREATEBRUSHINDIRECT = 39;
    private static final int DELETEOBJECT = 40;
    private static final int ANGLEARC = 41;
    private static final int ELLIPSE = 42;
    private static final int RECTANGLE = 43;
    private static final int ROUNDRECT = 44;
    private static final int ARC = 45;
    private static final int CHORD = 46;
    private static final int PIE = 47;
    private static final int SELECTPALETTE = 48;
    private static final int CREATEPALETTE = 49;
    private static final int SETPALETTEENTRIES = 50;
    private static final int RESIZEPALETTE = 51;
    private static final int REALIZEPALETTE = 52;
    private static final int EXTFLOODFILL = 53;
    private static final int LINETO = 54;
    private static final int ARCTO = 55;
    private static final int POLYDRAW = 56;
    private static final int SETARCDIRECTION = 57;
    private static final int SETMITERLIMIT = 58;
    private static final int BEGINPATH = 59;
    private static final int ENDPATH = 60;
    private static final int CLOSEFIGURE = 61;
    private static final int FILLPATH = 62;
    private static final int STROKEANDFILLPATH = 63;
    private static final int STROKEPATH = 64;
    private static final int FLATTENPATH = 65;
    private static final int WIDENPATH = 66;
    private static final int SELECTCLIPPATH = 67;
    private static final int ABORTPATH = 68;
    private static final int COMMENT = 70;
    private static final int FILLRGN = 71;
    private static final int FRAMERGN = 72;
    private static final int INVERTRGN = 73;
    private static final int PAINTRGN = 74;
    private static final int EXTSELECTCLIPRGN = 75;
    private static final int BITBLT = 76;
    private static final int STRETCHBLT = 77;
    private static final int MASKBLT = 78;
    private static final int PLGBLT = 79;
    private static final int SETDIBITSTODEVICE = 80;
    private static final int STRETCHDIBITS = 81;
    private static final int EXTCREATEFONTINDIRECTW = 82;
    private static final int EXTTEXTOUTA = 83;
    private static final int EXTTEXTOUTW = 84;
    private static final int POLYBEZIER16 = 85;
    private static final int POLYGON16 = 86;
    private static final int POLYLINE16 = 87;
    private static final int POLYBEZIERTO16 = 88;
    private static final int POLYLINETO16 = 89;
    private static final int POLYPOLYLINE16 = 90;
    private static final int POLYPOLYGON16 = 91;
    private static final int POLYDRAW16 = 92;
    private static final int CREATEMONOBRUSH = 93;
    private static final int CREATEDIBPATTERNBRUSHPT = 94;
    private static final int EXTCREATEPEN = 95;
    private static final int POLYTEXTOUTA = 96;
    private static final int POLYTEXTOUTW = 97;
    private static final int SETICMMODE = 98;
    private static final int CREATECOLORSPACE = 99;
    private static final int SETCOLORSPACE = 100;
    private static final int DELETECOLORSPACE = 101;
    private static final int GLSRECORD = 102;
    private static final int GLSBOUNDEDRECORD = 103;
    private static final int PIXELFORMAT = 104;
    private static final int DRAWESCAPE = 105;
    private static final int EXTESCAPE = 106;
    private static final int SMALLTEXTOUT = 108;
    private static final int FORCEUFIMAPPING = 109;
    private static final int NAMEDESCAPE = 110;
    private static final int COLORCORRECTPALETTE = 111;
    private static final int SETICMPROFILEA = 112;
    private static final int SETICMPROFILEW = 113;
    private static final int ALPHABLEND = 114;
    private static final int SETLAYOUT = 115;
    private static final int TRANSPARENTBLT = 116;
    private static final int GRADIENTFILL = 118;
    private static final int SETLINKEDUFIS = 119;
    private static final int SETTEXTJUSTIFICATION = 120;
    private static final int COLORMATCHTOTARGETW = 121;
    private static final int CREATECOLORSPACEW = 122;
    private static final int WHITE_BRUSH = Integer.MIN_VALUE;
    private static final int LTGRAY_BRUSH = -2147483647;
    private static final int GRAY_BRUSH = -2147483646;
    private static final int DKGRAY_BRUSH = -2147483645;
    private static final int BLACK_BRUSH = -2147483644;
    private static final int NULL_BRUSH = -2147483643;
    private static final int WHITE_PEN = -2147483642;
    private static final int BLACK_PEN = -2147483641;
    private static final int NULL_PEN = -2147483640;
    private static final int DC_BRUSH = -2147483630;
    private static final int DC_PEN = -2147483629;
    private EmfObject[] objects = new EmfObject[1000];
    private int[] pCmds = new int[32768];
    private int[] path;
    private int pc;
    private final ArrayDeque<DC> dcStack = new ArrayDeque();
    private int curX;
    private int curY;
    private int boundX2;
    private int boundY2;

    public static String getCommand(int command) {
        return switch (command) {
            case 1 -> "header";
            case 2 -> "polybezier";
            case 3 -> "polygon";
            case 4 -> "polyline";
            case 5 -> "polybezierto";
            case 6 -> "polylineto";
            case 7 -> "polypolyline";
            case 8 -> "polypolygon";
            case 9 -> "setwindowextex";
            case 10 -> "setwindoworgex";
            case 11 -> "setviewportextex";
            case 12 -> "setviewportorgex";
            case 15 -> "setpixelv";
            case 16 -> "setmapperflags";
            case 17 -> "setmapmode";
            case 18 -> "setbkmode";
            case 19 -> "setpolyfillmode";
            case 20 -> "setrop2";
            case 21 -> "setstretchbltmode";
            case 22 -> "settextalign";
            case 23 -> "setcoloradjustment";
            case 24 -> "settextcolor";
            case 25 -> "setbkcolor";
            case 26 -> "offsetcliprgn";
            case 27 -> "movetoex";
            case 28 -> "setmetargn";
            case 29 -> "excludecliprect";
            case 30 -> "intersectcliprect";
            case 31 -> "scaleviewportextex";
            case 32 -> "scalewindowextex";
            case 33 -> "savedc";
            case 34 -> "restoredc";
            case 35 -> "setworldtransform";
            case 36 -> "modifyworldtransform";
            case 37 -> "selectobject";
            case 38 -> "createpen";
            case 39 -> "createbrushindirect";
            case 40 -> "deleteobject";
            case 41 -> "anglearc";
            case 42 -> "ellipse";
            case 43 -> "rectangle";
            case 44 -> "roundrect";
            case 45 -> "arc";
            case 46 -> "chord";
            case 47 -> "pie";
            case 48 -> "selectpalette";
            case 49 -> "createpalette";
            case 50 -> "selectpaletteentries";
            case 51 -> "resizepalette";
            case 52 -> "realizepalette";
            case 53 -> "extfloodfill";
            case 54 -> "lineto";
            case 55 -> "arcto";
            case 56 -> "polydraw";
            case 57 -> "searchdirection";
            case 58 -> "setmiterlimit";
            case 59 -> "beginpath";
            case 60 -> "endpath";
            case 61 -> "closefigure";
            case 62 -> "fillpath";
            case 63 -> "strokeandfillpath";
            case 64 -> "strokepath";
            case 65 -> "flattenpath";
            case 66 -> "widenpath";
            case 67 -> "selectclippath";
            case 68 -> "abortpath";
            case 70 -> "comment";
            case 71 -> "fillrgn";
            case 72 -> "framergn";
            case 73 -> "invertrgn";
            case 74 -> "paintrgn";
            case 75 -> "extselectcliprgn";
            case 76 -> "bitblt";
            case 77 -> "stretchblt";
            case 78 -> "maskblt";
            case 79 -> "plgblt";
            case 80 -> "setdibitstodevice";
            case 81 -> "stretchdibits";
            case 82 -> "extcreatefontindirectw";
            case 83 -> "exttextouta";
            case 84 -> "exttextoutw";
            case 85 -> "polybezier16";
            case 86 -> "polygon16";
            case 87 -> "polyline61";
            case 88 -> "polybezierto16";
            case 89 -> "polylineto16";
            case 90 -> "polypolyline16";
            case 91 -> "polypolygon16";
            case 92 -> "polydraw16";
            case 93 -> "createmonobrush";
            case 94 -> "createdibpatternbrushpt";
            case 95 -> "extcreatepen";
            case 96 -> "polytextouta";
            case 97 -> "polytextoutw";
            case 98 -> "seticmmode";
            case 99 -> "createcolorspace";
            case 100 -> "setcolorspace";
            case 101 -> "deletecolorspace";
            case 102 -> "glsrecord";
            case 103 -> "glsboundrecord";
            case 104 -> "pixelformat";
            case 105 -> "drawescape";
            case 106 -> "extescape";
            case 108 -> "smalltextout";
            case 109 -> "forceufimapping";
            case 110 -> "namedescape";
            case 111 -> "colorcorrectpalette";
            case 112 -> "seticmprofilea";
            case 113 -> "seticmprofilew";
            case 114 -> "alphablend";
            case 115 -> "setlayout";
            case 116 -> "transparentblt";
            case 118 -> "gradientfill";
            case 119 -> "setlinkedufis";
            case 120 -> "settextjustification";
            case 121 -> "colormatchtotargetw";
            case 122 -> "createcolorspacew";
            case 14 -> "eof";
            default -> "unknown type " + Integer.toHexString(command);
        };
    }

    @Override
    public BufferedImage read(File file) throws IOException {
        DataFileLittle reader = new DataFileLittle(file);
        this.parseHeader(reader);
        reader.moveTo(0);
        BufferedImage image = new BufferedImage(this.boundX2, this.boundY2, 2);
        ImageSpace space = new ImageSpace(image);
        this.parseRecords(reader, space);
        space.close();
        reader.close();
        return image;
    }

    @Override
    public BufferedImage read(byte[] data) throws IOException {
        DataByteLittle reader = new DataByteLittle(data);
        this.parseHeader(reader);
        reader.moveTo(0);
        BufferedImage image = new BufferedImage(this.boundX2, this.boundY2, 2);
        ImageSpace space = new ImageSpace(image);
        this.parseRecords(reader, space);
        space.close();
        return image;
    }

    @Override
    public Rectangle readDimension(File file) throws Exception {
        DataFileLittle reader = new DataFileLittle(file);
        this.parseHeader(reader);
        reader.close();
        return new Rectangle(this.boundX2, this.boundY2);
    }

    @Override
    public Rectangle readDimension(byte[] emfRawData) throws Exception {
        DataByteLittle reader = new DataByteLittle(emfRawData);
        this.parseHeader(reader);
        return new Rectangle(this.boundX2, this.boundY2);
    }

    public static void toSVG(File emfFile, File svgOutputFile) throws IOException {
        DataFileLittle reader = new DataFileLittle(emfFile);
        StringBuilder sb = new StringBuilder();
        SvgSpace space = new SvgSpace(sb);
        EmfDecoder emfDecoder = new EmfDecoder();
        emfDecoder.parseHeader(reader);
        reader.moveTo(0);
        emfDecoder.parseRecords(reader, space);
        space.close();
        WriterFileBig fw = new WriterFileBig(svgOutputFile);
        fw.write(sb.toString().getBytes());
        fw.close();
    }

    public static void toSVG(InputStream emfInputStream, OutputStream svgOutputFile) throws IOException {
        File emfFile = File.createTempFile("idr", "emf");
        try (BufferedInputStream from = new BufferedInputStream(emfInputStream);
             BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(emfFile));){
            byte[] data = new byte[emfInputStream.available()];
            from.read(data);
            fos.write(data);
        }
        DataFileLittle reader = new DataFileLittle(emfFile);
        StringBuilder sb = new StringBuilder();
        SvgSpace space = new SvgSpace(sb);
        EmfDecoder emfDecoder = new EmfDecoder();
        emfDecoder.parseHeader(reader);
        reader.moveTo(0);
        emfDecoder.parseRecords(reader, space);
        space.close();
        WriterFileBig fw = new WriterFileBig(svgOutputFile);
        fw.write(sb.toString().getBytes());
        fw.close();
        emfFile.delete();
    }

    private void parseHeader(DataReader reader) throws IOException {
        boolean canRead = true;
        while (canRead && reader.getPosition() < reader.getLength()) {
            int offset = reader.getPosition();
            int type = reader.getU32();
            int size = reader.getU32();
            if (type == 1) {
                this.readHeader(reader);
                canRead = false;
            }
            reader.moveTo(offset + size);
        }
    }

    private void parseRecords(DataReader reader, Space space) throws IOException {
        boolean canRead = true;
        while (canRead && reader.getPosition() < reader.getLength()) {
            if (this.pc > this.pCmds.length / 2) {
                int[] temp = new int[this.pCmds.length << 1];
                System.arraycopy(this.pCmds, 0, temp, 0, this.pc);
                this.pCmds = temp;
            }
            int offset = reader.getPosition();
            int type = reader.getU32();
            int size = reader.getU32();
            switch (type) {
                case 14: {
                    canRead = false;
                    break;
                }
                case 13: {
                    this.brushOrigin(reader);
                    break;
                }
                case 35: {
                    EmfDecoder.setWorldTransform(reader, space);
                    break;
                }
                case 36: {
                    EmfDecoder.modifyWorldTransform(reader, space);
                    break;
                }
                case 38: 
                case 39: 
                case 82: 
                case 93: 
                case 94: 
                case 95: {
                    int id = reader.getU32();
                    this.createObject(type, offset, id);
                    break;
                }
                case 49: 
                case 99: 
                case 122: {
                    this.createObject(type, offset);
                    break;
                }
                case 40: 
                case 101: {
                    this.deleteObject(reader);
                    break;
                }
                case 37: 
                case 48: 
                case 100: {
                    this.selectObject(reader, space);
                    break;
                }
                case 24: {
                    EmfDecoder.setTextColor(reader, space);
                    break;
                }
                case 20: 
                case 64: {
                    this.strokePath(space);
                    break;
                }
                case 18: 
                case 25: 
                case 41: 
                case 45: 
                case 46: 
                case 47: 
                case 53: 
                case 55: 
                case 56: 
                case 60: 
                case 70: 
                case 71: 
                case 72: 
                case 74: 
                case 92: 
                case 96: 
                case 97: 
                case 118: {
                    break;
                }
                case 61: {
                    this.closeFigure();
                    break;
                }
                case 54: {
                    this.lineTo(reader);
                    break;
                }
                case 27: {
                    this.moveTO(reader);
                    break;
                }
                case 59: {
                    this.beginPath();
                    break;
                }
                case 62: {
                    this.fillPath(space);
                    break;
                }
                case 63: {
                    this.strokeFillPath(space);
                    break;
                }
                case 5: 
                case 88: {
                    this.polyBezierTo(reader, type == 88);
                    break;
                }
                case 3: 
                case 86: {
                    this.polygon(reader, space, type == 86);
                    break;
                }
                case 6: 
                case 89: {
                    this.polyLineTo(reader, type == 89);
                    break;
                }
                case 4: 
                case 87: {
                    this.polyline(reader, space, type == 87);
                    break;
                }
                case 83: 
                case 84: {
                    EmfDecoder.textOut(reader, space, type == 84);
                    break;
                }
                case 108: {
                    EmfDecoder.smalltextout(reader, space);
                    break;
                }
                case 43: {
                    this.rectangle(reader, space);
                    break;
                }
                case 44: {
                    this.roundRectangle(reader, space);
                    break;
                }
                case 7: 
                case 90: {
                    this.polyPolyline(reader, space, type == 90);
                    break;
                }
                case 8: 
                case 91: {
                    this.polyPolygon(reader, space, type == 91);
                    break;
                }
                case 2: 
                case 85: {
                    this.polybezier(reader, space, type == 85);
                    break;
                }
                case 42: {
                    EmfDecoder.ellipse(reader, space);
                    break;
                }
                case 15: {
                    this.setpixelv(reader, space);
                    break;
                }
                case 33: {
                    this.saveDC(space);
                    break;
                }
                case 34: {
                    this.restoreDC(reader, space);
                    break;
                }
                case 77: {
                    EmfDecoder.stretchblt(reader, space);
                    break;
                }
                case 81: {
                    EmfDecoder.stretchdibits(reader, space);
                    break;
                }
                case 12: {
                    EmfDecoder.setViewportOrg(reader, space);
                }
            }
            reader.moveTo(offset + size);
        }
    }

    private static void setViewportOrg(DataReader reader, Space space) throws IOException {
        short y = (short)reader.getU32();
        short x = (short)reader.getU32();
        float[][] mm = FM.getIdentity();
        mm[2][0] = y;
        mm[2][1] = x;
        mm = FM.multiply(space.getMatrix(), mm);
        space.setMatrix(mm);
    }

    private void createObject(int type, int offset) {
        int op = 1;
        while (this.objects[op] != null) {
            ++op;
        }
        this.objects[op] = new EmfObject(type, offset);
    }

    private void createObject(int type, int offset, int id) {
        this.objects[id] = new EmfObject(type, offset);
    }

    private void deleteObject(DataReader reader) throws IOException {
        int pos = reader.getU32();
        this.objects[pos] = null;
    }

    private void lineTo(DataReader reader) throws IOException {
        this.curX = reader.getU32();
        this.curY = reader.getU32();
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = this.curX;
        this.pCmds[this.pc++] = this.curY;
    }

    private void moveTO(DataReader reader) throws IOException {
        this.curX = reader.getU32();
        this.curY = reader.getU32();
        this.pCmds[this.pc++] = 0;
        this.pCmds[this.pc++] = this.curX;
        this.pCmds[this.pc++] = this.curY;
    }

    private void rectangle(DataReader reader, Space space) throws IOException {
        int b0 = reader.getU32();
        int b1 = reader.getU32();
        int b2 = reader.getU32();
        int b3 = reader.getU32();
        this.pCmds[this.pc++] = 0;
        this.pCmds[this.pc++] = b0;
        this.pCmds[this.pc++] = b1;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b2;
        this.pCmds[this.pc++] = b1;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b2;
        this.pCmds[this.pc++] = b3;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b0;
        this.pCmds[this.pc++] = b3;
        this.pCmds[this.pc++] = 4;
        this.path = new int[this.pc];
        System.arraycopy(this.pCmds, 0, this.path, 0, this.pc);
        this.pc = 0;
        space.fPath(this.path);
        space.sPath(this.path);
    }

    private void setpixelv(DataReader reader, Space space) throws IOException {
        int b0 = reader.getU32();
        int b1 = reader.getU32();
        int b2 = b0 + 1;
        int b3 = b1 + 1;
        int oldColor = space.getFC();
        int color = 0xFF000000 | reader.getU8() << 16 | reader.getU8() << 8 | reader.getU8();
        space.setFC(color);
        this.pCmds[this.pc++] = 0;
        this.pCmds[this.pc++] = b0;
        this.pCmds[this.pc++] = b1;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b2;
        this.pCmds[this.pc++] = b1;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b2;
        this.pCmds[this.pc++] = b3;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b0;
        this.pCmds[this.pc++] = b3;
        this.pCmds[this.pc++] = 4;
        this.path = new int[this.pc];
        System.arraycopy(this.pCmds, 0, this.path, 0, this.pc);
        this.pc = 0;
        space.fPath(this.path);
        space.setFC(oldColor);
    }

    private static void ellipse(DataReader reader, Space space) throws IOException {
        int b0 = reader.getU32();
        int b1 = reader.getU32();
        int b2 = reader.getU32();
        int b3 = reader.getU32();
        space.ellipse(b0, b1, b2 - b0, b3 - b1);
    }

    private void roundRectangle(DataReader reader, Space space) throws IOException {
        int b0 = reader.getU32();
        int b1 = reader.getU32();
        int b2 = reader.getU32();
        int b3 = reader.getU32();
        this.pCmds[this.pc++] = 0;
        this.pCmds[this.pc++] = b0;
        this.pCmds[this.pc++] = b1;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b2;
        this.pCmds[this.pc++] = b1;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b2;
        this.pCmds[this.pc++] = b3;
        this.pCmds[this.pc++] = 1;
        this.pCmds[this.pc++] = b0;
        this.pCmds[this.pc++] = b3;
        this.pCmds[this.pc++] = 4;
        this.path = new int[this.pc];
        System.arraycopy(this.pCmds, 0, this.path, 0, this.pc);
        this.pc = 0;
        space.fPath(this.path);
        space.sPath(this.path);
    }

    private void polyLineTo(DataReader reader, boolean is16) throws IOException {
        reader.skip(16);
        int count = reader.getU32();
        for (int i = 0; i < count; ++i) {
            this.pCmds[this.pc++] = 1;
            if (is16) {
                this.pCmds[this.pc++] = reader.getU16();
                this.pCmds[this.pc++] = reader.getU16();
                continue;
            }
            this.pCmds[this.pc++] = reader.getU32();
            this.pCmds[this.pc++] = reader.getU32();
        }
    }

    private void polyBezierTo(DataReader reader, boolean is16) throws IOException {
        reader.skip(16);
        int count = reader.getU32();
        int i = 0;
        while (i + 3 <= count) {
            this.pCmds[this.pc++] = 2;
            if (is16) {
                this.pCmds[this.pc++] = reader.getU16();
                this.pCmds[this.pc++] = reader.getU16();
                this.pCmds[this.pc++] = reader.getU16();
                this.pCmds[this.pc++] = reader.getU16();
                this.pCmds[this.pc++] = reader.getU16();
                this.pCmds[this.pc++] = reader.getU16();
            } else {
                this.pCmds[this.pc++] = reader.getU32();
                this.pCmds[this.pc++] = reader.getU32();
                this.pCmds[this.pc++] = reader.getU32();
                this.pCmds[this.pc++] = reader.getU32();
                this.pCmds[this.pc++] = reader.getU32();
                this.pCmds[this.pc++] = reader.getU32();
            }
            i += 3;
        }
    }

    private void polyline(DataReader reader, Space space, boolean is16) throws IOException {
        reader.skip(16);
        int count = reader.getU32();
        for (int i = 0; i < count; ++i) {
            int y;
            int x;
            if (is16) {
                x = reader.getU16();
                y = reader.getU16();
            } else {
                x = reader.getU32();
                y = reader.getU32();
            }
            this.pCmds[this.pc++] = i == 0 ? 0 : 1;
            this.pCmds[this.pc++] = x;
            this.pCmds[this.pc++] = y;
        }
        this.strokePath(space);
    }

    private void polybezier(DataReader reader, Space space, boolean is16) throws IOException {
        reader.skip(16);
        int count = reader.getU32();
        int i = 0;
        while (i + 3 <= count) {
            this.pCmds[this.pc++] = 2;
            if (is16) {
                this.pCmds[this.pc++] = reader.getU16();
                this.pCmds[this.pc++] = reader.getU16();
                this.pCmds[this.pc++] = reader.getU16();
                this.pCmds[this.pc++] = reader.getU16();
                this.pCmds[this.pc++] = reader.getU16();
                this.pCmds[this.pc++] = reader.getU16();
            } else {
                this.pCmds[this.pc++] = reader.getU32();
                this.pCmds[this.pc++] = reader.getU32();
                this.pCmds[this.pc++] = reader.getU32();
                this.pCmds[this.pc++] = reader.getU32();
                this.pCmds[this.pc++] = reader.getU32();
                this.pCmds[this.pc++] = reader.getU32();
            }
            i += 3;
        }
        this.strokePath(space);
    }

    private void polygon(DataReader reader, Space space, boolean is16) throws IOException {
        reader.skip(16);
        int count = reader.getU32();
        for (int i = 0; i < count; ++i) {
            int y;
            int x;
            if (is16) {
                x = reader.getU16();
                y = reader.getU16();
            } else {
                x = reader.getU32();
                y = reader.getU32();
            }
            this.pCmds[this.pc++] = i == 0 ? 0 : 1;
            this.pCmds[this.pc++] = x;
            this.pCmds[this.pc++] = y;
        }
        this.closeFigure();
        this.strokeFillPath(space);
    }

    private void polyPolygon(DataReader reader, Space space, boolean is16) throws IOException {
        reader.skip(16);
        int nPolygons = reader.getU32();
        reader.getU32();
        int[] ppCount = new int[nPolygons];
        for (int i = 0; i < nPolygons; ++i) {
            ppCount[i] = reader.getU32();
        }
        for (int i = 0; i < nPolygons; ++i) {
            int c = 0;
            for (int j = 0; j < ppCount[i]; ++j) {
                int y;
                int x;
                if (is16) {
                    x = reader.getU16();
                    y = reader.getU16();
                } else {
                    x = reader.getU32();
                    y = reader.getU32();
                }
                this.pCmds[this.pc++] = c == 0 ? 0 : 1;
                this.pCmds[this.pc++] = x;
                this.pCmds[this.pc++] = y;
                ++c;
            }
            this.closeFigure();
            this.strokeFillPath(space);
        }
    }

    private void polyPolyline(DataReader reader, Space space, boolean is16) throws IOException {
        reader.skip(16);
        int nPolygons = reader.getU32();
        reader.getU32();
        int[] ppCount = new int[nPolygons];
        for (int i = 0; i < nPolygons; ++i) {
            ppCount[i] = reader.getU32();
        }
        for (int i = 0; i < nPolygons; ++i) {
            int c = 0;
            for (int j = 0; j < ppCount[i]; ++j) {
                int y;
                int x;
                if (is16) {
                    x = reader.getU16();
                    y = reader.getU16();
                } else {
                    x = reader.getU32();
                    y = reader.getU32();
                }
                this.pCmds[this.pc++] = c == 0 ? 0 : 1;
                this.pCmds[this.pc++] = x;
                this.pCmds[this.pc++] = y;
                ++c;
            }
            this.strokePath(space);
        }
    }

    private void closeFigure() {
        if (this.pc > 2) {
            this.pCmds[this.pc++] = 4;
        }
    }

    private void beginPath() {
        this.path = null;
        this.pc = 0;
    }

    private void fillPath(Space space) {
        this.path = new int[this.pc];
        System.arraycopy(this.pCmds, 0, this.path, 0, this.pc);
        this.pc = 0;
        space.fPath(this.path);
    }

    private void strokePath(Space space) {
        this.path = new int[this.pc];
        System.arraycopy(this.pCmds, 0, this.path, 0, this.pc);
        this.pc = 0;
        space.sPath(this.path);
    }

    private void strokeFillPath(Space space) {
        this.path = new int[this.pc];
        System.arraycopy(this.pCmds, 0, this.path, 0, this.pc);
        this.pc = 0;
        space.sfPath(this.path);
    }

    private static void setTextColor(DataReader reader, Space space) throws IOException {
        int fontColor = 0xFF000000 | reader.getU8() << 16 | reader.getU8() << 8 | reader.getU8();
        space.setFontC(fontColor);
    }

    private void brushOrigin(DataReader reader) throws IOException {
        this.curX = reader.getU32();
        this.curY = reader.getU32();
    }

    private void saveDC(Space space) {
        DC dc = new DC();
        dc.fc = space.getFC();
        dc.sc = space.getSC();
        dc.fontC = space.getFontC();
        dc.mm = space.getMatrix();
        dc.fontName = space.getFontName();
        dc.fontSize = space.getFontSize();
        dc.design = space.getDesign();
        this.dcStack.push(dc);
    }

    private void restoreDC(DataReader reader, Space space) throws IOException {
        if (!this.dcStack.isEmpty()) {
            DC dc = this.dcStack.pop();
            for (int loc = reader.getU32(); loc < -1; ++loc) {
                dc = this.dcStack.pop();
            }
            space.setFC(dc.fc);
            space.setSC(dc.sc);
            space.setFontC(dc.fontC);
            space.setMatrix(dc.mm);
            space.setFontName(dc.fontName);
            space.setFontSize(dc.fontSize);
            space.setDesign(dc.design);
        }
    }

    private void selectObject(DataReader reader, Space space) throws IOException {
        int cp = reader.getU32();
        if (cp >>> 31 == 1) {
            EmfDecoder.selectStockObject(cp, space);
        } else {
            EmfObject sel = this.objects[cp];
            if (sel != null) {
                reader.moveTo(sel.offset + 8);
                reader.getU32();
                switch (sel.type) {
                    case 93: 
                    case 94: {
                        EmfDecoder.createdippatternbrushpt(reader, space);
                        break;
                    }
                    case 39: {
                        int brushStyle = reader.getU32();
                        int r = reader.getU8();
                        int g = reader.getU8();
                        int b = reader.getU8();
                        reader.getU8();
                        int brushColor = r << 16 | g << 8 | b;
                        space.setFC(0xFF000000 | brushColor);
                        if (brushStyle == 1) {
                            space.setFC(0);
                        }
                        reader.getU32();
                        break;
                    }
                    case 38: 
                    case 95: {
                        if (sel.type == 95) {
                            reader.skip(16);
                        }
                        int penStyle = reader.getU32();
                        int penWidth = reader.getU32();
                        space.setSW(penWidth);
                        space.sStyle(penStyle);
                        reader.skip(4);
                        int penColor = 0xFF000000 | reader.getU8() << 16 | reader.getU8() << 8 | reader.getU8();
                        reader.getU8();
                        space.setSC(penColor);
                        break;
                    }
                    case 82: {
                        int c;
                        int fontSize = reader.getU32();
                        reader.skip(8);
                        int orn = reader.getU32();
                        int weight = reader.getU32();
                        int fontWeight = weight == 700 ? 1 : 0;
                        reader.skip(8);
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < 66 && (c = reader.getU16()) != 0; ++i) {
                            sb.append((char)c);
                        }
                        String name = sb.toString();
                        if (name.isEmpty()) break;
                        space.font(name, Math.abs(fontSize), fontWeight);
                    }
                }
            }
        }
    }

    private static void selectStockObject(int type, Space space) {
        switch (type) {
            case -2147483648: {
                space.setFC(-1);
                break;
            }
            case -2147483647: {
                space.setFC(-4144960);
                break;
            }
            case -2147483646: {
                space.setFC(-8355712);
                break;
            }
            case -2147483645: {
                space.setFC(-12566464);
                break;
            }
            case -2147483644: {
                space.setFC(-16777216);
                break;
            }
            case -2147483643: {
                space.setFC(0);
                break;
            }
            case -2147483642: {
                space.setSC(-1);
                space.sStyle(0);
                space.setSW(1);
                break;
            }
            case -2147483641: {
                space.setSC(-16777216);
                space.sStyle(0);
                space.setSW(1);
                break;
            }
            case -2147483640: {
                space.setSC(0);
                space.sStyle(0);
                space.setSW(1);
                break;
            }
        }
    }

    private void readHeader(DataReader reader) throws IOException {
        int boundX = reader.getU32();
        int boundY = reader.getU32();
        this.boundX2 = reader.getU32();
        this.boundY2 = reader.getU32();
        int frameX = reader.getU32();
        int frameY = reader.getU32();
        int frameX2 = reader.getU32();
        int frameY2 = reader.getU32();
        int sign = reader.getU32();
        if (sign != 1179469088) {
            throw new IOException("not a valid EMF file");
        }
        reader.skip(4);
        reader.getU32();
        int nRecords = reader.getU32();
        this.objects = new EmfObject[nRecords + 1];
    }

    private static void setWorldTransform(DataReader reader, Space space) throws IOException {
        int m11 = reader.getU32();
        int m12 = reader.getU32();
        int m21 = reader.getU32();
        int m22 = reader.getU32();
        int DX = reader.getU32();
        int DY = reader.getU32();
        float[][] mm = new float[3][3];
        mm[0][0] = EmfDecoder.toFloat(m11);
        mm[0][1] = EmfDecoder.toFloat(m12);
        mm[1][0] = EmfDecoder.toFloat(m21);
        mm[1][1] = EmfDecoder.toFloat(m22);
        mm[2][0] = EmfDecoder.toFloat(DX);
        mm[2][1] = EmfDecoder.toFloat(DY);
        mm[2][2] = 1.0f;
        space.setMatrix(mm);
    }

    private static void modifyWorldTransform(DataReader reader, Space space) throws IOException {
        int m11 = reader.getU32();
        int m12 = reader.getU32();
        int m21 = reader.getU32();
        int m22 = reader.getU32();
        int DX = reader.getU32();
        int DY = reader.getU32();
        float[][] mm = new float[3][3];
        mm[0][0] = EmfDecoder.toFloat(m11);
        mm[0][1] = EmfDecoder.toFloat(m12);
        mm[1][0] = EmfDecoder.toFloat(m21);
        mm[1][1] = EmfDecoder.toFloat(m22);
        mm[2][0] = EmfDecoder.toFloat(DX);
        mm[2][1] = EmfDecoder.toFloat(DY);
        mm[2][2] = 1.0f;
        int mode = reader.getU32();
        switch (mode) {
            case 1: {
                space.setMatrix(FM.getIdentity());
            }
            case 2: {
                mm = FM.multiply(space.getMatrix(), mm);
                space.setMatrix(mm);
                break;
            }
            case 3: {
                mm = FM.multiply(mm, space.getMatrix());
                space.setMatrix(mm);
                break;
            }
            case 4: {
                space.setMatrix(mm);
            }
        }
    }

    private static float toFloat(int v) {
        return Float.intBitsToFloat(v);
    }

    private static void createdippatternbrushpt(DataReader reader, Space space) throws IOException {
        int start = reader.getPosition() - 12;
        reader.getU32();
        int offBmiSrc = reader.getU32();
        int cbBmiSrc = reader.getU32();
        int offBitsSrc = reader.getU32();
        int cbBitsSrc = reader.getU32();
        reader.moveTo(start + offBmiSrc);
        byte[] bHeader = new byte[cbBmiSrc];
        reader.read(bHeader);
        reader.moveTo(start + offBitsSrc);
        byte[] bData = new byte[cbBitsSrc];
        reader.read(bData);
        byte[] output = new byte[14 + cbBmiSrc + cbBitsSrc];
        WriterByteLittle writer = new WriterByteLittle(output);
        writer.putU16(19778);
        writer.putU32(output.length);
        writer.putU32(0);
        writer.putU32(14 + cbBmiSrc);
        writer.write(bHeader);
        writer.write(bData);
        space.setDesign(new Design(output));
    }

    private static void stretchblt(DataReader reader, Space space) throws IOException {
        int start = reader.getPosition() - 8;
        reader.skip(16);
        int xDest = reader.getU32();
        int yDest = reader.getU32();
        int cxDest = reader.getU32();
        int cyDest = reader.getU32();
        int bbrs = reader.getU32();
        int xSrc = reader.getU32();
        int ySrc = reader.getU32();
        int m11 = reader.getU32();
        int m12 = reader.getU32();
        int m21 = reader.getU32();
        int m22 = reader.getU32();
        int DX = reader.getU32();
        int DY = reader.getU32();
        float[][] xform = new float[3][3];
        xform[0][0] = EmfDecoder.toFloat(m11);
        xform[0][1] = EmfDecoder.toFloat(m12);
        xform[1][0] = EmfDecoder.toFloat(m21);
        xform[1][1] = EmfDecoder.toFloat(m22);
        xform[2][0] = EmfDecoder.toFloat(DX);
        xform[2][1] = EmfDecoder.toFloat(DY);
        xform[2][2] = 1.0f;
        int bgColorSrc = 0xFF000000 | reader.getU8() << 16 | reader.getU8() << 8 | reader.getU8();
        reader.getU8();
        int usageSrc = reader.getU32();
        int offBmiSrc = reader.getU32();
        int cbBmiSrc = reader.getU32();
        int offBitsSrc = reader.getU32();
        int cbBitsSrc = reader.getU32();
        int cxSrc = reader.getU32();
        int cySrc = reader.getU32();
        reader.moveTo(start + offBmiSrc);
        byte[] bHeader = new byte[cbBmiSrc];
        reader.read(bHeader);
        reader.moveTo(start + offBitsSrc);
        byte[] bData = new byte[cbBitsSrc];
        reader.read(bData);
        byte[] output = new byte[14 + cbBmiSrc + cbBitsSrc];
        WriterByteLittle writer = new WriterByteLittle(output);
        writer.putU16(19778);
        writer.putU32(output.length);
        writer.putU32(0);
        writer.putU32(14 + cbBmiSrc);
        writer.write(bHeader);
        writer.write(bData);
        float[][] sm = space.getMatrix();
        space.setMatrix(FM.concatenate(sm, xform));
        space.bmpImage(xDest, yDest, output);
        space.setMatrix(sm);
    }

    private static void stretchdibits(DataReader reader, Space space) throws IOException {
        int start = reader.getPosition() - 8;
        reader.skip(16);
        int xDest = reader.getU32();
        int yDest = reader.getU32();
        int xSrc = reader.getU32();
        int ySrc = reader.getU32();
        int cxSrc = reader.getU32();
        int cySrc = reader.getU32();
        int offBmiSrc = reader.getU32();
        int cbBmiSrc = reader.getU32();
        int offBitsSrc = reader.getU32();
        int cbBitsSrc = reader.getU32();
        int usageSrc = reader.getU32();
        int bop = reader.getU32();
        int cxDest = reader.getU32();
        int cyDest = reader.getU32();
        float[][] cm = space.getMatrix();
        float[][] im = FM.getIdentity();
        if (xDest != 0) {
            im[0][0] = (float)cxDest * 1.0f / (float)cxSrc;
        }
        if (yDest != 0) {
            im[1][1] = (float)cyDest * 1.0f / (float)cySrc;
        }
        space.setMatrix(FM.concatenate(cm, im));
        reader.moveTo(start + offBmiSrc);
        byte[] bHeader = new byte[cbBmiSrc];
        reader.read(bHeader);
        reader.moveTo(start + offBitsSrc);
        byte[] bData = new byte[cbBitsSrc];
        reader.read(bData);
        byte[] output = new byte[14 + cbBmiSrc + cbBitsSrc];
        WriterByteLittle writer = new WriterByteLittle(output);
        writer.putU16(19778);
        writer.putU32(output.length);
        writer.putU32(0);
        writer.putU32(14 + cbBmiSrc);
        writer.write(bHeader);
        writer.write(bData);
        space.bmpImage(xDest, yDest, output);
        space.setMatrix(cm);
    }

    private static void textOut(DataReader reader, Space space, boolean is16) throws IOException {
        reader.skip(16);
        int gMode = reader.getU32();
        int xSCale = reader.getU32();
        int yScale = reader.getU32();
        int refX = reader.getU32();
        int refY = reader.getU32();
        int nChars = reader.getU32();
        int offString = reader.getU32();
        int options = reader.getU32();
        reader.skip(16);
        int offDX = reader.getU32();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nChars; ++i) {
            char c = is16 ? (char)reader.getU16() : (char)reader.getU8();
            sb.append(c);
        }
        space.text(refX, refY, sb.toString());
    }

    private static void smalltextout(DataReader reader, Space space) throws IOException {
        int x = reader.getU32();
        int y = reader.getU32();
        int cChars = reader.getU32();
        int fuOptions = reader.getU32();
        int iGraphicsMode = reader.getU32();
        int exScale = reader.getU32();
        int eyScale = reader.getU32();
        reader.skip(16);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cChars; ++i) {
            char c = fuOptions == 512 ? (char)reader.getU16() : (char)reader.getU8();
            sb.append(c);
        }
        space.text(x, y, sb.toString());
    }
}

