/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.bmp;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.bmp.options.BmpEncoderOptions;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.png.data.BitWriter;
import com.idrsolutions.image.util.ImageUtils;
import com.idrsolutions.image.utility.BitReader;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BmpEncoder
extends JDeliImage
implements Encoder {
    private BmpEncoderOptions bmpEncoderOptions = new BmpEncoderOptions();

    public BmpEncoder(EncoderOptions format) {
        if (format != null) {
            this.bmpEncoderOptions = (BmpEncoderOptions)format;
        }
    }

    public BmpEncoder() {
    }

    @Override
    public BmpEncoderOptions getEncoderOptions() {
        return this.bmpEncoderOptions;
    }

    @Override
    public void write(BufferedImage image, OutputStream outputStream) throws IOException {
        int type;
        int ih;
        int iw;
        BufferedImage imageToCompress = ImageUtils.fixSubBufferedImage(image);
        BufferedImage test = BmpEncoder.testIndexed(imageToCompress, iw = imageToCompress.getWidth(), ih = imageToCompress.getHeight());
        if (test != null) {
            imageToCompress = test;
        }
        if (this.bmpEncoderOptions.getOutputSubtype() != -1) {
            type = this.bmpEncoderOptions.getOutputSubtype();
            if (type != imageToCompress.getType()) {
                test = new BufferedImage(image.getWidth(), image.getHeight(), type);
                test.getGraphics().drawImage(imageToCompress, 0, 0, null);
                imageToCompress = test;
            }
        } else {
            type = imageToCompress.getType();
        }
        int bps = BmpEncoder.getBPS(imageToCompress);
        int rowSize = (iw * bps + 31) / 32 * 4;
        int pixArrayLen = rowSize * ih;
        BmpEncoder.putLe16(outputStream, 19778);
        BmpEncoder.putLe32(outputStream, pixArrayLen + 54);
        BmpEncoder.putLe32(outputStream, 0);
        int offset = 40;
        offset += bps == 16 ? 30 : 14;
        int padding = 0;
        int nCol = 1 << bps;
        if (type == 13 || type == 12 || type == 10) {
            nCol = image.getColorModel().getClass() == IndexColorModel.class ? ((IndexColorModel)image.getColorModel()).getMapSize() : nCol;
            padding = nCol * 4;
            offset += padding;
        }
        int comp = type == 8 || type == 9 ? 3 : 0;
        BmpEncoder.putLe32(outputStream, offset);
        BmpEncoder.putLe32(outputStream, 40);
        BmpEncoder.putLe32(outputStream, iw);
        BmpEncoder.putLe32(outputStream, ih);
        BmpEncoder.putLe16(outputStream, 1);
        BmpEncoder.putLe16(outputStream, bps);
        BmpEncoder.putLe32(outputStream, comp);
        BmpEncoder.putLe32(outputStream, pixArrayLen);
        BmpEncoder.putLe32(outputStream, 0);
        BmpEncoder.putLe32(outputStream, 0);
        BmpEncoder.putLe32(outputStream, padding > 0 ? nCol : 0);
        BmpEncoder.putLe32(outputStream, padding > 0 ? nCol : 0);
        if (bps == 16) {
            if (type == 8) {
                BmpEncoder.putLe32(outputStream, 63488);
                BmpEncoder.putLe32(outputStream, 2016);
                BmpEncoder.putLe32(outputStream, 31);
                BmpEncoder.putLe32(outputStream, -1);
            } else {
                BmpEncoder.putLe32(outputStream, 31744);
                BmpEncoder.putLe32(outputStream, 992);
                BmpEncoder.putLe32(outputStream, 31);
                BmpEncoder.putLe32(outputStream, 0);
            }
        }
        if (padding > 0) {
            BmpEncoder.addPadding(imageToCompress, outputStream);
        }
        BmpEncoder.writeImage(imageToCompress, outputStream, bps, rowSize);
    }

    private static BufferedImage testIndexed(BufferedImage image, int iw, int ih) {
        int nComp = image.getColorModel().getNumComponents();
        int p = 0;
        int a = 255;
        int cp = 0;
        int count = 0;
        int dim = iw * ih;
        int[] countMap = new int[256];
        byte[] cpArr = new byte[dim];
        switch (image.getType()) {
            case 5: 
            case 6: 
            case 7: {
                byte[] pixBytes = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < dim; ++i) {
                    int hasInd;
                    if (nComp == 4) {
                        a = pixBytes[p++] & 0xFF;
                    }
                    int b = pixBytes[p++] & 0xFF;
                    int g = pixBytes[p++] & 0xFF;
                    int r = pixBytes[p++] & 0xFF;
                    int v = a << 24 | r << 16 | g << 8 | b;
                    if (count < 255) {
                        hasInd = -1;
                        int ii = count + 1;
                        for (int j = 0; j < ii; ++j) {
                            if (countMap[j] != v) continue;
                            hasInd = j;
                            break;
                        }
                        if (hasInd == -1) {
                            countMap[count] = v;
                            hasInd = count++;
                        }
                    } else {
                        return null;
                    }
                    cpArr[cp++] = (byte)hasInd;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < dim; ++i) {
                    int hasInd;
                    int v = pixInts[i];
                    if (count < 255) {
                        hasInd = -1;
                        int ii = count + 1;
                        for (int j = 0; j < ii; ++j) {
                            if (countMap[j] != v) continue;
                            hasInd = j;
                            break;
                        }
                        if (hasInd == -1) {
                            countMap[count] = v;
                            hasInd = count++;
                        }
                    } else {
                        return null;
                    }
                    cpArr[cp++] = (byte)hasInd;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return BmpEncoder.getOptimizedImage(iw, ih, count, nComp, countMap, cpArr);
    }

    private static BufferedImage getOptimizedImage(int iw, int ih, int nColors, int nComp, int[] countMap, byte[] cpArr) {
        int[] palette = new int[nColors];
        System.arraycopy(countMap, 0, palette, 0, nColors);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BitWriter bw = new BitWriter(bos);
        int bps = BmpEncoder.getAvailableBps(nColors);
        int paletteLen = 1 << bps;
        int gap = 8 - iw * bps % 8;
        int cp = 0;
        for (int y = 0; y < ih; ++y) {
            for (int x = 0; x < iw; ++x) {
                bw.writeBits(cpArr[cp++], bps);
            }
            if (gap == 8) continue;
            bw.writeBits(0, gap);
        }
        bw.end();
        byte[] aa = new byte[paletteLen];
        byte[] rr = new byte[paletteLen];
        byte[] gg = new byte[paletteLen];
        byte[] bb = new byte[paletteLen];
        for (int i = 0; i < nColors; ++i) {
            int v = palette[i];
            aa[i] = (byte)(v >> 24 & 0xFF);
            rr[i] = (byte)(v >> 16 & 0xFF);
            gg[i] = (byte)(v >> 8 & 0xFF);
            bb[i] = (byte)(v & 0xFF);
        }
        IndexColorModel cm = nComp == 4 ? new IndexColorModel(bps, paletteLen, rr, gg, bb, aa) : new IndexColorModel(bps, paletteLen, rr, gg, bb);
        BufferedImage img = bps <= 4 ? new BufferedImage(iw, ih, 12, cm) : new BufferedImage(iw, ih, 13, cm);
        byte[] dd = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        System.arraycopy(bos.toByteArray(), 0, dd, 0, dd.length);
        return img;
    }

    private static int getAvailableBps(int nColors) {
        switch (nColors) {
            case 1: 
            case 2: {
                return 1;
            }
        }
        if (nColors <= 16) {
            return 4;
        }
        return 8;
    }

    private static void writeImage(BufferedImage image, OutputStream os, int bps, int rowSize) throws IOException {
        switch (image.getType()) {
            case 12: {
                BmpEncoder.encodeBinary(image, bps, os);
                break;
            }
            case 10: 
            case 13: {
                BmpEncoder.encodeGrayOrIndexed(image, os, rowSize);
                break;
            }
            case 5: {
                BmpEncoder.encodeBYTE_BGR(image, os, rowSize);
                break;
            }
            case 6: 
            case 7: {
                BmpEncoder.encodeBYTE_ABGR(image, os);
                break;
            }
            case 4: {
                BmpEncoder.encodeINT_BGR(image, os, rowSize);
                break;
            }
            case 1: {
                BmpEncoder.encodeINT_RGB(image, os, rowSize);
                break;
            }
            case 2: 
            case 3: {
                BmpEncoder.encodeINT_ARGB(image, os);
                break;
            }
            case 9: {
                BmpEncoder.encodeUSHORT_RGB555(image, os);
            }
            case 8: {
                BmpEncoder.encodeUSHORT_RGB565(image, os);
            }
            default: {
                BufferedImage converted = new BufferedImage(image.getWidth(), image.getHeight(), 5);
                converted.getGraphics().drawImage(image, 0, 0, null);
                BmpEncoder.encodeBYTE_BGR(converted, os, rowSize);
            }
        }
    }

    private static void addPadding(BufferedImage image, OutputStream outputStream) throws IOException {
        switch (image.getType()) {
            case 10: {
                for (int i = 0; i < 256; ++i) {
                    byte v = (byte)i;
                    outputStream.write(new byte[]{v, v, v, -1});
                }
                break;
            }
            case 12: 
            case 13: {
                IndexColorModel icm = (IndexColorModel)image.getColorModel();
                int nCols = icm.getMapSize();
                byte[] r = new byte[nCols];
                byte[] g = new byte[nCols];
                byte[] b = new byte[nCols];
                byte[] a = new byte[nCols];
                icm.getReds(r);
                icm.getGreens(g);
                icm.getBlues(b);
                icm.getAlphas(a);
                for (int i = 0; i < nCols; ++i) {
                    outputStream.write(new byte[]{b[i], g[i], r[i], a[i]});
                }
                break;
            }
            default: {
                for (int i = 0; i < 256; ++i) {
                    outputStream.write(new byte[]{(byte)i, (byte)i, (byte)i, -1});
                }
            }
        }
    }

    private static void encodeBinary(BufferedImage image, int bps, OutputStream os) {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int iw = image.getWidth();
        int ih = image.getHeight();
        int rowSize8 = (iw * bps + 31) / 32 * 4 * 8;
        int iwx = rowSize8 - iw * bps;
        BitReader br = new BitReader(pix);
        BitWriter bw = new BitWriter(os);
        int buf8 = (iw * bps + 7) / 8;
        for (int y = ih - 1; y >= 0; --y) {
            br.moovBoundary(buf8 * y);
            for (int x = 0; x < iw; ++x) {
                bw.writeBits(br.readBits(bps), bps);
            }
            for (int i = 0; i < iwx; ++i) {
                bw.writeBits(0, 1);
            }
        }
        bw.end();
    }

    private static void encodeGrayOrIndexed(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int balance = rowSize - image.getWidth();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                os.write(pix[p++] & 0xFF);
            }
            for (int i = 0; i < balance; ++i) {
                os.write(0);
            }
        }
    }

    private static void encodeBYTE_BGR(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int pad = rowSize > image.getWidth() * 3 ? rowSize - image.getWidth() * 3 : 0;
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth() * 3;
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                os.write(pix[p++] & 0xFF);
                os.write(pix[p++] & 0xFF);
                os.write(pix[p++] & 0xFF);
            }
            for (int i = 0; i < pad; ++i) {
                os.write(0);
            }
        }
    }

    private static void encodeBYTE_ABGR(BufferedImage image, OutputStream os) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int iw = image.getWidth();
        int ih = image.getHeight();
        for (int y = ih - 1; y >= 0; --y) {
            int p = y * iw * 4;
            for (int x = 0; x < iw; ++x) {
                os.write(pix[p + 1] & 0xFF);
                os.write(pix[p + 2] & 0xFF);
                os.write(pix[p + 3] & 0xFF);
                os.write(pix[p] & 0xFF);
                p += 4;
            }
        }
    }

    private static void encodeINT_BGR(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        int[] pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int pad = rowSize > image.getWidth() * 3 ? rowSize - image.getWidth() * 3 : 0;
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                int t = pix[p++];
                os.write(t >> 16 & 0xFF);
                os.write(t >> 8 & 0xFF);
                os.write(t & 0xFF);
            }
            for (int i = 0; i < pad; ++i) {
                os.write(0);
            }
        }
    }

    private static void encodeINT_RGB(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        int[] pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int pad = rowSize > image.getWidth() * 3 ? rowSize - image.getWidth() * 3 : 0;
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                int t = pix[p++];
                os.write(t & 0xFF);
                os.write(t >> 8 & 0xFF);
                os.write(t >> 16 & 0xFF);
            }
            for (int i = 0; i < pad; ++i) {
                os.write(0);
            }
        }
    }

    private static void encodeUSHORT_RGB555(BufferedImage image, OutputStream os) throws IOException {
        short[] pixels = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        int iw = image.getWidth();
        int ih = image.getHeight();
        for (int y = ih - 1; y >= 0; --y) {
            int p = y * iw;
            for (int x = 0; x < iw; ++x) {
                short pix = pixels[p];
                byte[] pixel = new byte[]{(byte)pix, (byte)(pix >> 8)};
                os.write(pixel, 0, 2);
                ++p;
            }
        }
    }

    private static void encodeUSHORT_RGB565(BufferedImage image, OutputStream os) throws IOException {
        short[] pixels = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        int iw = image.getWidth();
        int ih = image.getHeight();
        for (int y = ih - 1; y >= 0; --y) {
            int p = y * iw;
            for (int x = 0; x < iw; ++x) {
                short pix = pixels[p];
                byte[] pixel = new byte[]{(byte)pix, (byte)(pix >> 8)};
                os.write(pixel, 0, 2);
                ++p;
            }
        }
    }

    private static void encodeINT_ARGB(BufferedImage image, OutputStream os) throws IOException {
        int[] pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                int t = pix[p++];
                os.write(t & 0xFF);
                os.write(t >> 8 & 0xFF);
                os.write(t >> 16 & 0xFF);
                os.write(t >> 24 & 0xFF);
            }
        }
    }

    private static void putLe16(OutputStream os, int v) throws IOException {
        os.write(v & 0xFF);
        os.write(v >> 8 & 0xFF);
    }

    private static void putLe32(OutputStream os, int v) throws IOException {
        os.write(v & 0xFF);
        os.write(v >> 8 & 0xFF);
        os.write(v >> 16 & 0xFF);
        os.write(v >> 24 & 0xFF);
    }

    private static int getBPS(BufferedImage image) {
        return switch (image.getType()) {
            case 12 -> image.getColorModel().getPixelSize();
            case 10, 13 -> 8;
            case 8, 9 -> 16;
            case 2, 3, 6, 7 -> 32;
            default -> 24;
        };
    }
}

