/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.dec;

import com.idrsolutions.image.avif.dec.D;

class Yuv {
    int bitdepth_ = 8;
    boolean is_monochrome_ = false;
    int y_width_ = 0;
    int uv_width_ = 0;
    int y_height_ = 0;
    int uv_height_ = 0;
    int[] left_border_ = new int[3];
    int[] right_border_ = new int[3];
    int[] top_border_ = new int[3];
    int[] bottom_border_ = new int[3];
    int[] stride_ = new int[3];
    int[][] buffer_ = new int[3][];
    int buffer_alloc_size_ = 0;
    int subsampling_x_ = 0;
    int subsampling_y_ = 0;

    Yuv() {
    }

    int stride(int plane) {
        return this.stride_[plane];
    }

    int[] data(int plane) {
        return this.buffer_[plane];
    }

    int height(int plane) {
        return plane == 0 ? this.y_height_ : this.uv_height_;
    }

    int alignment() {
        return 16;
    }

    int left_border(int plane) {
        return this.left_border_[plane];
    }

    int right_border(int plane) {
        return this.right_border_[plane];
    }

    int top_border(int plane) {
        return this.top_border_[plane];
    }

    int bottom_border(int plane) {
        return this.bottom_border_[plane];
    }

    boolean Realloc(int bitdepth, boolean is_monochrome, int width, int height, int subsampling_x, int subsampling_y, int left_border, int right_border, int top_border, int bottom_border) {
        int plane_align = 16;
        int uv_width = is_monochrome ? 0 : D.SubsampledValue(width, subsampling_x);
        int uv_height = is_monochrome ? 0 : D.SubsampledValue(height, subsampling_y);
        int uv_left_border = is_monochrome ? 0 : left_border >> subsampling_x;
        int uv_right_border = is_monochrome ? 0 : right_border >> subsampling_x;
        int uv_top_border = is_monochrome ? 0 : top_border >> subsampling_y;
        int uv_bottom_border = is_monochrome ? 0 : bottom_border >> subsampling_y;
        int y_stride = width + left_border + right_border;
        y_stride = D.Align(y_stride, 16);
        long y_plane_size = (height + top_border + bottom_border) * y_stride + (plane_align - 1);
        int uv_stride = uv_width + uv_left_border + uv_right_border;
        uv_stride = D.Align(uv_stride, 16);
        int uv_plane_size = is_monochrome ? 0 : (uv_height + uv_top_border + uv_bottom_border) * uv_stride + (plane_align - 1);
        this.stride_[0] = y_stride;
        this.stride_[1] = this.stride_[2] = uv_stride;
        int left_border_bytes = left_border;
        int uv_left_border_bytes = uv_left_border;
        this.buffer_[0] = new int[(int)(y_plane_size + (long)(top_border * y_stride) + (long)left_border_bytes)];
        this.buffer_[1] = new int[uv_plane_size + uv_top_border * uv_stride + uv_left_border_bytes];
        this.buffer_[2] = new int[uv_plane_size + uv_top_border * uv_stride + uv_left_border_bytes];
        this.y_width_ = width;
        this.y_height_ = height;
        this.left_border_[0] = left_border;
        this.right_border_[0] = right_border;
        this.top_border_[0] = top_border;
        this.bottom_border_[0] = bottom_border;
        this.uv_width_ = uv_width;
        this.uv_height_ = uv_height;
        this.left_border_[1] = this.left_border_[2] = uv_left_border;
        this.right_border_[1] = this.right_border_[2] = uv_right_border;
        this.top_border_[1] = this.top_border_[2] = uv_top_border;
        this.bottom_border_[1] = this.bottom_border_[2] = uv_bottom_border;
        this.subsampling_x_ = subsampling_x;
        this.subsampling_y_ = subsampling_y;
        this.bitdepth_ = bitdepth;
        this.is_monochrome_ = is_monochrome;
        return true;
    }
}

