/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.dec;

import com.idrsolutions.image.avif.dec.D;

class RawBit {
    static final int kMaximumLeb128Size = 8;
    static final int kLeb128ValueByteMask = 127;
    static final int kLeb128TerminationByteMask = 128;
    final byte[] data_;
    int bit_offset_;
    final int size_;
    int startByteOffset = 0;
    int startBitOffset = 0;

    RawBit(byte[] data, int offset, int size) {
        this.data_ = data;
        this.startByteOffset = offset;
        this.bit_offset_ = offset * 8;
        this.startBitOffset = this.startByteOffset * 8;
        this.size_ = size;
    }

    static int Mod8(int n) {
        return n & 7;
    }

    int DivideBy8(int n, boolean ceil) {
        return n + (ceil ? 7 : 0) >> 3;
    }

    int byte_offset() {
        return (this.bit_offset_ + 7 >> 3) - this.startByteOffset;
    }

    int bit_offset() {
        return this.bit_offset_ - this.startBitOffset;
    }

    int ReadBitImpl() {
        int byte_offset = this.DivideBy8(this.bit_offset_, false);
        int b = this.data_[byte_offset] & 0xFF;
        int shift = 7 - RawBit.Mod8(this.bit_offset_);
        ++this.bit_offset_;
        return b >> shift & 1;
    }

    boolean Finished() {
        return this.DivideBy8(this.bit_offset_, false) >= this.size_;
    }

    int ReadBit() {
        if (this.Finished()) {
            return -1;
        }
        return this.ReadBitImpl();
    }

    boolean CanReadLiteral(int num_bits) {
        if (this.Finished()) {
            return false;
        }
        int bit_offset = this.bit_offset_ + num_bits - 1;
        return this.DivideBy8(bit_offset, false) < this.size_;
    }

    long ReadLiteral(int num_bits) {
        if (!this.CanReadLiteral(num_bits)) {
            return -1L;
        }
        long literal = 0L;
        int bit = num_bits - 1;
        do {
            literal <<= 1;
            literal |= (long)this.ReadBitImpl();
        } while (--bit >= 0);
        return literal;
    }

    int ReadInverseSignedLiteral(int num_bits) {
        int sign_bit;
        int value = (int)this.ReadLiteral(num_bits + 1);
        if ((value & (sign_bit = 1 << num_bits)) != 0) {
            value -= 2 * sign_bit;
        }
        return value;
    }

    int ReadLittleEndian(int num_bytes) {
        int byte_offset = this.DivideBy8(this.bit_offset_, false);
        int value = 0;
        for (int i = 0; i < num_bytes; ++i) {
            int bb = this.data_[byte_offset] & 0xFF;
            value |= bb << i * 8;
            ++byte_offset;
        }
        this.bit_offset_ = byte_offset * 8;
        return value;
    }

    long ReadUnsignedLeb128() {
        long value64 = 0L;
        for (int i = 0; i < 8; ++i) {
            int byte_offset = this.DivideBy8(this.bit_offset_, false);
            int bb = this.data_[byte_offset] & 0xFF;
            this.bit_offset_ += 8;
            value64 |= (long)((bb & 0x7F) << i * 7);
            if ((bb & 0x80) != 0) continue;
            return value64;
        }
        return value64;
    }

    int ReadUvlc() {
        int literal;
        int bit;
        int leading_zeros = 0;
        while ((bit = this.ReadBit()) != 1) {
            ++leading_zeros;
        }
        if (leading_zeros != 0) {
            literal = (int)this.ReadLiteral(leading_zeros);
            literal += (1 << leading_zeros) - 1;
        } else {
            literal = 0;
        }
        return literal;
    }

    boolean AlignToNextByte() {
        while ((this.bit_offset_ & 7) != 0) {
            if (this.ReadBit() == 0) continue;
            return false;
        }
        return true;
    }

    boolean VerifyAndSkipTrailingBits(int num_bits) {
        if (this.ReadBit() != 1) {
            return false;
        }
        for (int i = 0; i < num_bits - 1; ++i) {
            if (this.ReadBit() == 0) continue;
            return false;
        }
        return true;
    }

    boolean SkipBytes(int num_bytes) {
        return (this.bit_offset_ & 7) != 0 ? false : this.SkipBits(num_bytes * 8);
    }

    boolean SkipBits(int num_bits) {
        if (this.Finished()) {
            return false;
        }
        int bit_offset = this.bit_offset_ + num_bits - 1;
        if (this.DivideBy8(bit_offset, false) >= this.size_) {
            return false;
        }
        this.bit_offset_ += num_bits;
        return true;
    }

    static int InverseRecenter(int r, int v) {
        if (v > r << 1) {
            return v;
        }
        if ((v & 1) != 0) {
            return r - (v + 1 >> 1);
        }
        return r + (v >> 1);
    }

    int DecodeUniform(int max) {
        int l = D.FloorLog2(max) + 1;
        int m = (1 << l) - max;
        int v = (int)this.ReadLiteral(l - 1);
        return v < m ? v : (v << 1) - m + this.ReadBit();
    }

    int DecodeSignedSubexpWithReference(int low, int high, int reference, int control) {
        int value = this.DecodeUnsignedSubexpWithReference(high - low, reference - low, control);
        return value += low;
    }

    int DecodeUnsignedSubexpWithReference(int mx, int reference, int control) {
        int v = this.DecodeSubexp(mx, control);
        int value = reference << 1 <= mx ? RawBit.InverseRecenter(reference, v) : mx - 1 - RawBit.InverseRecenter(mx - 1 - reference, v);
        return value;
    }

    int DecodeSubexp(int num_symbols, int control) {
        int b;
        int i = 0;
        int mk = 0;
        int value = 0;
        while (true) {
            int n = b = i != 0 ? control + i - 1 : control;
            if (b >= 32) {
                return 0;
            }
            int a = 1 << b;
            if (num_symbols <= mk + 3 * a) {
                value = this.DecodeUniform(num_symbols - mk);
                return value += mk;
            }
            int subexp_more_bits = this.ReadBit();
            if (subexp_more_bits == -1) {
                return 0;
            }
            if (subexp_more_bits == 0) break;
            ++i;
            mk += a;
        }
        int subexp_bits = (int)this.ReadLiteral(b);
        if (subexp_bits == -1) {
            return 0;
        }
        return subexp_bits + mk;
    }
}

